/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2.test;

import ix.icore.Sendable;
import ix.ip2.PanelFrame;
import ix.ip2.test.TestElement;
import ix.ip2.test.TestItem;
import ix.util.CatchingThread;
import ix.util.Debug;
import ix.util.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;

public abstract class PanelTest
implements TestElement {
    protected String menuText;
    protected PanelFrame frame;

    public String getMenuText() {
        return this.menuText;
    }

    public void setMenuText(String string) {
        this.menuText = string;
    }

    public String getFullMenuText() {
        return this.getMenuText();
    }

    public abstract List getTestItems();

    public void addToMenu(PanelFrame panelFrame) {
        TestItem testItem;
        this.frame = panelFrame;
        List list = this.getTestItems();
        String string = this.getFullMenuText();
        if (list.size() == 1 && (testItem = (TestItem)list.get(0)).getDelayBefore() <= 0) {
            panelFrame.addTest(string, new TestItemListener(testItem));
            return;
        }
        panelFrame.addTest(string, new TestSequenceListener(string, list));
    }

    void sendTest(String string, Sendable sendable) {
        this.frame.getSendPanel().sendCopy(string, sendable);
    }

    class SendingThread
    extends CatchingThread {
        TestSequenceListener listener;
        AbstractButton button;
        List testItems;
        int minDelay = 0;
        volatile boolean exit = false;

        public SendingThread(TestSequenceListener testSequenceListener, List list) {
            this.listener = testSequenceListener;
            this.testItems = list;
        }

        public void innerRun() {
            Iterator iterator = this.testItems.iterator();
            while (!this.exit && iterator.hasNext()) {
                TestItem testItem = (TestItem)iterator.next();
                String string = testItem.getToName();
                Sendable sendable = testItem.getContents();
                int n = testItem.getDelayBefore();
                if ((n = Math.max(this.minDelay, n)) > 0) {
                    Debug.noteln("Sleeping", n);
                    try {
                        Thread.sleep(n);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.exit) continue;
                Util.swingAndWait(new Runnable(this, string, sendable){
                    private final /* synthetic */ String val$toName;
                    private final /* synthetic */ Sendable val$contents;
                    private final /* synthetic */ SendingThread this$1;
                    {
                        this.this$1 = sendingThread;
                        this.val$toName = string;
                        this.val$contents = sendable;
                    }

                    public void run() {
                        this.this$1.send(this.val$toName, this.val$contents);
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ SendingThread this$1;
                {
                    this.this$1 = sendingThread;
                }

                public void run() {
                    this.this$1.listener.finished();
                }
            });
        }

        void send(String string, Sendable sendable) {
            try {
                PanelTest.this.sendTest(string, sendable);
            }
            catch (Throwable throwable) {
                Debug.noteException(throwable);
                this.reportException(throwable);
            }
        }
    }

    class TestSequenceListener
    implements ActionListener {
        String menuText;
        List testItems;
        SendingThread sender;
        AbstractButton button;

        public TestSequenceListener(String string, List list) {
            this.menuText = string;
            this.testItems = list;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.button = (AbstractButton)actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals(this.menuText)) {
                this.sender = new SendingThread(this, this.testItems);
                this.button.setText("Stop: " + this.menuText);
                this.sender.start();
            } else if (string.startsWith("Stop: ")) {
                this.sender.exit = true;
                Debug.noteln("Stopped messages for test", this.menuText);
            } else {
                Debug.noteln("Strange test button action", string);
            }
        }

        void finished() {
            this.button.setText(this.menuText);
        }
    }

    class TestItemListener
    implements ActionListener {
        TestItem item;

        TestItemListener(TestItem testItem) {
            this.item = testItem;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PanelTest.this.sendTest(this.item.getToName(), this.item.getContents());
        }
    }
}

