/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.domain.PatternAssignment;
import ix.icore.process.event.ProcessStatusEvent;
import ix.iface.util.CatchingActionListener;
import ix.ip2.Ip2;
import ix.ip2.StateViewer;
import ix.util.Debug;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class StateViewTable
extends JPanel
implements StateViewer {
    protected Ip2 ip2;
    final int PAT_COL = 0;
    final int VAL_COL = 1;
    final int patternWidth = 30;
    final int valueWidth = 20;
    JTable table;
    StateModel model;
    List patternData = new ArrayList();

    public StateViewTable(Ip2 ip2) {
        this.ip2 = ip2;
        this.model = new StateModel();
        this.table = new JTable(this.model);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.addMouseListener(new TableMouseListener());
        this.setLayout(new BorderLayout());
        this.add((Component)this.table.getTableHeader(), "North");
        this.add((Component)this.table, "Center");
    }

    public void reset() {
        this.patternData.clear();
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.invalidate();
    }

    public void statusUpdate(ProcessStatusEvent processStatusEvent) {
    }

    public void newBindings(ProcessStatusEvent processStatusEvent, Map map) {
    }

    public void stateChange(ProcessStatusEvent processStatusEvent, Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            LList lList = (LList)entry.getKey();
            Object v = entry.getValue();
            this.recordNewValue(lList, v);
        }
    }

    protected void recordNewValue(LList lList, Object object) {
        Debug.noteln("State viewer sees " + lList + " = " + object);
        PatternData patternData = this.getPatternData(lList);
        if (patternData == null) {
            patternData = new PatternData(lList, object);
            this.patternData.add(patternData);
            patternData.row = this.patternData.size() - 1;
            this.model.fireTableRowsInserted(patternData.row, patternData.row);
        } else {
            patternData.value = object;
            this.model.fireTableCellUpdated(patternData.row, 1);
        }
    }

    PatternData getPatternData(LList lList) {
        Iterator iterator = this.patternData.iterator();
        while (iterator.hasNext()) {
            PatternData patternData = (PatternData)iterator.next();
            if (!patternData.pattern.equals(lList)) continue;
            return patternData;
        }
        return null;
    }

    PatternData getPatternData(int n) {
        PatternData patternData = (PatternData)this.patternData.get(n);
        Debug.assert(patternData.row == n);
        return patternData;
    }

    class RowPopupMenu
    extends JPopupMenu
    implements ActionListener {
        int row = -1;

        RowPopupMenu() {
            this.add(this.makeMenuItem("Change Constraint"));
            this.add(this.makeMenuItem("Send Constraint"));
        }

        JMenuItem makeMenuItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(CatchingActionListener.listener(this));
            return jMenuItem;
        }

        void setRow(int n) {
            this.row = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PatternAssignment patternAssignment;
            PatternData patternData;
            String string = actionEvent.getActionCommand();
            Debug.noteln("Row popup command", string);
            if (string.equals("Change Constraint")) {
                patternData = StateViewTable.this.getPatternData(this.row);
                patternAssignment = new PatternAssignment(patternData.pattern, patternData.value);
                StateViewTable.this.ip2.frame.ensureChat();
                StateViewTable.this.ip2.frame.getSendPanel().initConstraintForMe(patternAssignment);
            }
            if (string.equals("Send Constraint")) {
                patternData = StateViewTable.this.getPatternData(this.row);
                patternAssignment = new PatternAssignment(patternData.pattern, patternData.value);
                StateViewTable.this.ip2.frame.ensureChat();
                StateViewTable.this.ip2.frame.getSendPanel().initConstraint(patternAssignment);
            } else {
                Debug.noteln("Nothing to do for", string);
            }
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        RowPopupMenu popup;

        TableMouseListener() {
            this.popup = new RowPopupMenu();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                int n = StateViewTable.this.table.rowAtPoint(mouseEvent.getPoint());
                Debug.noteln("Table right press in row", n);
                this.popup.setRow(n);
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class StateModel
    extends AbstractTableModel {
        final String[] columnName = new String[]{"Pattern", "Value"};

        StateModel() {
        }

        public String getColumnName(int n) {
            return this.columnName[n];
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return StateViewTable.this.patternData.size();
        }

        public Object getValueAt(int n, int n2) {
            PatternData patternData = StateViewTable.this.getPatternData(n);
            switch (n2) {
                case 0: {
                    return Lisp.elementsToString(patternData.pattern);
                }
                case 1: {
                    return patternData.value;
                }
            }
            throw new Error("Bogus column " + n2);
        }
    }

    class PatternData {
        LList pattern;
        Object value;
        int row;

        PatternData(LList lList, Object object) {
            this.pattern = lList;
            this.value = object;
        }
    }
}

