/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.IXAgent;
import ix.icore.domain.Domain;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.IconImage;
import ix.ip2.test.TestElement;
import ix.itest.SendPanel;
import ix.iview.InternalDomainEditor;
import ix.iview.SimpleDomainEditor;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.Util;
import ix.util.xml.XML;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public abstract class PanelFrame
extends JFrame
implements ActionListener {
    protected IXAgent agent;
    protected JMenu testMenu = new JMenu("Test", true);
    protected InternalDomainEditor domainEditor;
    static /* synthetic */ Class class$ix$icore$IXAgent;
    static /* synthetic */ Class class$ix$icore$domain$Domain;

    public PanelFrame(IXAgent iXAgent) {
        super(iXAgent.getAgentDisplayName());
        this.agent = iXAgent;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Debug.noteln("Main frame windowClosing event");
                if (Util.dialogConfirms(PanelFrame.this, "Are you sure you want to exit?")) {
                    System.exit(0);
                }
            }
        });
    }

    public InternalDomainEditor makeDomainEditor(IXAgent iXAgent, Domain domain) {
        String string = Parameters.getParameter("domain-editor-class", "ix.iview.SimpleDomainEditor");
        try {
            Debug.noteln("Trying domain editor class", string);
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{class$ix$icore$IXAgent == null ? (class$ix$icore$IXAgent = PanelFrame.class$("ix.icore.IXAgent")) : class$ix$icore$IXAgent, class$ix$icore$domain$Domain == null ? (class$ix$icore$domain$Domain = PanelFrame.class$("ix.icore.domain.Domain")) : class$ix$icore$domain$Domain};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            InternalDomainEditor internalDomainEditor = (InternalDomainEditor)constructor.newInstance(iXAgent, domain);
            if (internalDomainEditor instanceof JFrame) {
                ((Frame)((JFrame)((Object)internalDomainEditor))).setIconImage(IconImage.getIconImage("ip2-edit-icon.gif"));
            }
            return internalDomainEditor;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            Debug.noteln("Creating a SimpleDomainEditor instead.");
            return new SimpleDomainEditor(iXAgent, domain);
        }
    }

    public InternalDomainEditor getDomainEditor() {
        this.ensureDomainEditor();
        return this.domainEditor;
    }

    protected abstract void ensureDomainEditor();

    protected JMenuItem makeMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(CatchingActionListener.listener(this));
        return jMenuItem;
    }

    public abstract SendPanel getSendPanel();

    public void addTest(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(CatchingActionListener.listener(actionListener));
        this.testMenu.setEnabled(true);
        this.testMenu.add(jMenuItem);
    }

    public void addTestSeparator() {
        this.testMenu.addSeparator();
    }

    public void addTests(String string) {
        try {
            List list = (List)XML.objectFromFile(new File(string));
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    TestElement testElement = (TestElement)iterator.next();
                    testElement.addToMenu(this);
                }
            }
        }
        catch (Throwable throwable) {
            Debug.noteException(throwable);
            Util.displayAndWait(null, Strings.foldLongLine("Problem loading test-menu " + Strings.quote(string) + ": " + throwable));
        }
    }

    public abstract void actionPerformed(ActionEvent var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

