/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Activity;
import ix.icore.IXAgent;
import ix.icore.Issue;
import ix.icore.Report;
import ix.icore.domain.Domain;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainListener;
import ix.icore.domain.event.RefinementEvent;
import ix.icore.process.ProcessModelManager;
import ix.ip2.ActivityAgenda;
import ix.ip2.ActivityItem;
import ix.ip2.Agenda;
import ix.ip2.Ip2ModelManager;
import ix.ip2.IssueAgenda;
import ix.ip2.IssueItem;
import ix.ip2.ItemHandler;
import ix.ip2.WaitForReportsActivity;
import ix.ip2.WaitForReportsItem;
import ix.ip2.event.AgendaListener;
import ix.ip2.event.ControllerListener;
import ix.util.Debug;
import java.util.LinkedList;
import java.util.List;

public class PanelController
implements DomainListener {
    protected IXAgent agent;
    Domain domain;
    protected List listeners = new LinkedList();
    ProcessModelManager modelManager = new Ip2ModelManager(this);
    protected ActivityAgenda activities;
    protected Agenda issues;

    public PanelController(IXAgent iXAgent) {
        this.agent = iXAgent;
        this.activities = new ActivityAgenda(this);
        this.issues = new IssueAgenda(this);
    }

    public void reset() {
        this.modelManager.reset();
        this.activities.clear();
        this.issues.clear();
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
        this.domain.addDomainListener(this);
    }

    public Agenda getActivityAgenda() {
        return this.activities;
    }

    public Agenda getIssueAgenda() {
        return this.issues;
    }

    public void addActivity(Activity activity) {
        if (activity instanceof WaitForReportsActivity) {
            this.activities.addItem(new WaitForReportsItem(activity));
        } else {
            this.activities.addItem(new ActivityItem(activity));
        }
    }

    public void addIssue(Issue issue) {
        this.issues.addItem(new IssueItem(issue));
    }

    public void newReport(Report report) {
        if (!this.activities.acceptReport(report) && !this.issues.acceptReport(report)) {
            throw new Error("Failed to accept " + report);
        }
    }

    public void addActivityHandler(ItemHandler itemHandler) {
        this.activities.addItemHandler(itemHandler);
    }

    public void addIssueHandler(ItemHandler itemHandler) {
        this.issues.addItemHandler(itemHandler);
    }

    public void addItemHandler(ItemHandler itemHandler) {
        this.activities.addItemHandler(itemHandler);
        this.issues.addItemHandler(itemHandler);
    }

    public void reconsiderHandler(ItemHandler itemHandler, Object object) {
        Debug.noteln("Controller asked to reconsider", itemHandler);
        Debug.noteln("For reason", object);
        if (this.issues.handlers.contains(itemHandler)) {
            this.issues.reconsiderHandler(itemHandler, object);
        }
        if (this.activities.handlers.contains(itemHandler)) {
            this.activities.reconsiderHandler(itemHandler, object);
        }
    }

    public void addActivityListener(AgendaListener agendaListener) {
        this.activities.addAgendaListener(agendaListener);
        agendaListener.setAgendaManager(this.activities);
    }

    public void addIssueListener(AgendaListener agendaListener) {
        this.issues.addAgendaListener(agendaListener);
        agendaListener.setAgendaManager(this.issues);
    }

    public void refinementAdded(RefinementEvent refinementEvent) {
        Refinement refinement = refinementEvent.getRefinement();
        Debug.noteln("Panel Controller noting new ", refinement);
        this.activities.refinementAdded(refinement);
    }

    public void addControllerListener(ControllerListener controllerListener) {
        this.listeners.add(controllerListener);
    }
}

