/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Report;
import ix.icore.Status;
import ix.icore.Variable;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.IconImage;
import ix.iface.util.ToolFrame;
import ix.ip2.AgendaItem;
import ix.ip2.AgendaViewer;
import ix.ip2.HandlerAction;
import ix.ip2.event.AgendaItemEvent;
import ix.ip2.event.AgendaItemListener;
import ix.util.Debug;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public abstract class ItemEditor
implements ActionListener {
    protected String title;
    protected JFrame frame;
    protected Container contentPane;
    protected AgendaViewer agendaViewer;
    protected EditPanel editPanel;
    protected JMenuItem saveAsRefinementItem = this.makeMenuItem("Save As Refinement");

    ItemEditor(AgendaViewer agendaViewer, String string) {
        this.agendaViewer = agendaViewer;
        this.title = string;
        this.setUpFrame();
    }

    protected void setUpFrame() {
        this.frame = new ToolFrame(this.title);
        ((Frame)this.frame).setIconImage(IconImage.getIconImage(this));
        ((Component)this.frame).setSize(500, 300);
        this.frame.setJMenuBar(this.makeMenuBar());
        this.contentPane = this.frame.getContentPane();
        this.editPanel = this.makeEditPanel();
        this.contentPane.add(this.editPanel);
        this.frame.pack();
    }

    protected abstract EditPanel makeEditPanel();

    void setVisible(boolean bl) {
        ((Component)this.frame).setVisible(bl);
    }

    void showItem(AgendaItem agendaItem) {
        this.editPanel.showItem(agendaItem);
        this.setVisible(true);
    }

    void showNewItem() {
        this.editPanel.showNewItem();
        this.setVisible(true);
    }

    protected abstract JMenuBar makeMenuBar();

    protected JMenuItem makeMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(CatchingActionListener.listener(this));
        return jMenuItem;
    }

    public abstract void actionPerformed(ActionEvent var1);

    protected abstract class EditPanel
    extends JPanel
    implements ActionListener,
    AgendaItemListener {
        int textCols = 50;
        JTextArea itemText = new JTextArea(3, this.textCols);
        JTextArea commentText = new JTextArea(6, this.textCols);
        JButton modifyButton;
        Box newItemButtons = Box.createHorizontalBox();
        Box editItemButtons = Box.createHorizontalBox();
        AgendaItem editingItem = null;

        EditPanel() {
            this.setLayout(new BoxLayout(this, 1));
        }

        protected abstract void setUp();

        protected Box makeLeftLabel(String string) {
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(string));
            box.add(Box.createHorizontalGlue());
            return box;
        }

        protected JButton makeButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(CatchingActionListener.listener(this));
            return jButton;
        }

        void showItem(AgendaItem agendaItem) {
            this.editingItem = agendaItem;
            agendaItem.addItemListener(this);
            this.itemText.setText(Lisp.elementsToString(agendaItem.getPattern()));
            this.itemText.setEnabled(false);
            this.commentText.setText(agendaItem.getComments());
            this.commentText.setEnabled(true);
            this.ensureButtons(this.editItemButtons);
            Status status = agendaItem.getStatus();
            if (status == Status.BLANK || status == Status.POSSIBLE) {
                this.modifyButton.setEnabled(true);
            }
            ItemEditor.this.frame.validate();
        }

        void showNewItem() {
            this.editingItem = null;
            this.itemText.setText("");
            this.itemText.setEnabled(true);
            this.commentText.setText("");
            this.commentText.setEnabled(true);
            this.ensureButtons(this.newItemButtons);
            ItemEditor.this.frame.validate();
        }

        void ensureButtons(Box box) {
            Component component = this.getComponent(this.getComponentCount() - 1);
            Debug.assert(component == this.newItemButtons || component == this.editItemButtons);
            if (component != box) {
                this.remove(component);
                this.add(box);
                this.repaint();
            }
        }

        public abstract void actionPerformed(ActionEvent var1);

        void addItem() {
            Debug.assert(this.editingItem == null);
            String string = this.itemText.getText().trim();
            String string2 = this.commentText.getText();
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(ItemEditor.this.frame, "Empty item text", "Invalid item", 0);
                return;
            }
            try {
                LList lList = Lisp.elementsFromString(string);
                if (lList.length() < 1) {
                    throw new RuntimeException("Empty item pattern");
                }
                AgendaItem agendaItem = ItemEditor.this.agendaViewer.makeItem(lList);
                if (!string2.trim().equals("")) {
                    agendaItem.setComments(string2);
                }
                ItemEditor.this.agendaViewer.addItem(agendaItem);
                this.showItem(agendaItem);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                JOptionPane.showMessageDialog(this, new Object[]{"Cannot define item.", exception.getMessage()}, "Error while defining item", 0);
                return;
            }
        }

        void modifyItem() {
            Debug.assert(this.editingItem != null);
            this.editingItem.setComments(this.commentText.getText());
        }

        void copyItem() {
            Debug.assert(this.editingItem != null);
            if (!this.editingItem.getPatternVars().isEmpty()) {
                LList lList = (LList)Variable.revertVars(this.editingItem.getPattern());
                this.itemText.setText(Lisp.elementsToString(lList));
            }
            this.editingItem = null;
            this.itemText.setEnabled(true);
            this.commentText.setEnabled(true);
            this.ensureButtons(this.newItemButtons);
            ItemEditor.this.frame.validate();
        }

        public void statusChanged(AgendaItemEvent agendaItemEvent) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem != this.editingItem) {
                return;
            }
            Debug.noteln("Status change while editing item", agendaItem);
            Status status = agendaItem.getStatus();
            if (status == Status.BLANK || status != Status.POSSIBLE) {
                // empty if block
            }
        }

        public void priorityChanged(AgendaItemEvent agendaItemEvent) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem != this.editingItem) {
                return;
            }
            Debug.noteln("Priority change while editing item", agendaItem);
        }

        public void handlerActionsChanged(AgendaItemEvent agendaItemEvent) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem != this.editingItem) {
                return;
            }
            Debug.noteln("Handler actions changed while editing item", agendaItem);
        }

        public void newHandlerAction(AgendaItemEvent agendaItemEvent, HandlerAction handlerAction) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem != this.editingItem) {
                return;
            }
            Debug.noteln("New handler action while editing item", agendaItem);
        }

        public void newReport(AgendaItemEvent agendaItemEvent, Report report) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem != this.editingItem) {
                return;
            }
            Debug.noteln("New report while editing item", agendaItem);
            this.commentText.setText(agendaItem.getComments());
            this.commentText.setCaretPosition(agendaItem.getComments().length());
            ItemEditor.this.frame.validate();
        }

        public void agendaItemEdited(AgendaItemEvent agendaItemEvent) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem != this.editingItem) {
                return;
            }
            Debug.noteln("Item edited while editing", agendaItem);
        }
    }
}

