/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.ip2.AgendaViewer;
import ix.ip2.ItemEditor;
import ix.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;

class IssueEditor
extends ItemEditor {
    IssueEditor(AgendaViewer agendaViewer, String string) {
        super(agendaViewer, string);
    }

    protected ItemEditor.EditPanel makeEditPanel() {
        IssueEditPanel issueEditPanel = new IssueEditPanel();
        issueEditPanel.setBorder(BorderFactory.createTitledBorder("Issue"));
        return issueEditPanel;
    }

    protected JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.add(this.makeMenuItem("Close"));
        return jMenuBar;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("IssueEditor action:", string);
        if (string.equals("Close")) {
            ((Component)this.frame).setVisible(false);
        } else {
            Debug.noteln("Nothing to do for", string);
        }
    }

    class IssueEditPanel
    extends ItemEditor.EditPanel {
        IssueEditPanel() {
            this.modifyButton = this.makeButton("Modify Issue");
            this.setUp();
        }

        protected void setUp() {
            this.add(this.makeLeftLabel("Issue Pattern Text"));
            this.add(new JScrollPane(this.itemText));
            this.add(this.makeLeftLabel("Annotations"));
            this.add(new JScrollPane(this.commentText));
            this.newItemButtons.add(this.makeButton("Add Issue"));
            this.newItemButtons.add(this.makeButton("Clear"));
            this.newItemButtons.add(this.makeButton("Cancel"));
            this.editItemButtons.add(this.modifyButton);
            this.editItemButtons.add(this.makeButton("Copy Issue"));
            this.editItemButtons.add(this.makeButton("Clear"));
            this.editItemButtons.add(this.makeButton("Cancel"));
            this.add(this.newItemButtons);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Issue action:", string);
            if (string.equals("Add Issue")) {
                this.addItem();
            } else if (string.equals("Modify Issue")) {
                this.modifyItem();
            } else if (string.equals("Copy Issue")) {
                this.copyItem();
            } else if (string.equals("Clear")) {
                this.showNewItem();
            } else if (string.equals("Cancel")) {
                ((Component)IssueEditor.this.frame).setVisible(false);
                this.showNewItem();
            } else {
                Debug.noteln("Nothing to do for", string);
            }
        }
    }
}

