/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Issue;
import ix.icore.Report;
import ix.icore.Status;
import ix.ip2.Agenda;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ip2.IssueItem;
import ix.ip2.ItemHandler;
import ix.ip2.PanelController;
import ix.util.Debug;
import ix.util.lisp.LList;
import java.util.Iterator;

public class IssueAgenda
extends Agenda {
    AgendaItem openOtherReportsIssue = null;

    public IssueAgenda(PanelController panelController) {
        super(panelController);
    }

    public AgendaItem makeItem(LList lList) {
        return new IssueItem(new Issue(lList));
    }

    public void addItem(AgendaItem agendaItem) {
        agendaItem.setPattern(this.modelManager.putVariablesInPattern(agendaItem.getPattern()));
        agendaItem.computeStatus();
        super.addItem(agendaItem);
    }

    public void clear() {
        super.clear();
        this.openOtherReportsIssue = null;
    }

    public boolean acceptReport(Report report) {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            AgendaItem agendaItem = (AgendaItem)iterator.next();
            if (agendaItem instanceof OtherReportsIssue || !agendaItem.wantsReport(report)) continue;
            agendaItem.addReport(report);
            return true;
        }
        if (this.openOtherReportsIssue == null) {
            this.openOtherReportsIssue = new OtherReportsIssue("Note other reports");
            this.addItem(this.openOtherReportsIssue);
        }
        this.openOtherReportsIssue.addReport(report);
        return true;
    }

    public class OtherReportsIssue
    extends IssueItem {
        public OtherReportsIssue(String string) {
            super(new Issue(string));
            this.setStatus(Status.EXECUTING);
        }

        boolean wantsReport(Report report) {
            Debug.noteln("Other reports issue asked if it wants", report);
            return this.getStatus() != Status.COMPLETE;
        }

        public boolean wantsActionsFrom(ItemHandler itemHandler) {
            return false;
        }

        boolean actionCanBeTakenNow(HandlerAction handlerAction) {
            return this.getStatus() == Status.POSSIBLE || handlerAction instanceof HandlerAction.Manual && this.getStatus() == Status.EXECUTING;
        }

        public void setStatus(Status status) {
            if (status == Status.COMPLETE && this == IssueAgenda.this.openOtherReportsIssue) {
                IssueAgenda.this.openOtherReportsIssue = null;
            }
            super.setStatus(status);
        }

        void addReport(Report report) {
            super.addReport(report);
            if (this.getPriority().compareTo(report.getPriority()) < 0) {
                this.setPriority(report.getPriority());
            }
        }

        void setStatusBasedOn(Report report) {
        }
    }
}

