/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Activity;
import ix.icore.Issue;
import ix.icore.Status;
import ix.icore.TaskItem;
import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.domain.End;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.Ordering;
import ix.icore.domain.PatternAssignment;
import ix.icore.process.PNode;
import ix.icore.process.ProcessModelManager;
import ix.icore.process.state.Plan;
import ix.icore.process.state.PlanNode;
import ix.icore.process.state.PlanRefinement;
import ix.icore.process.state.PlanVariableDeclaration;
import ix.icore.process.state.VariableScope;
import ix.ip2.ActivityItem;
import ix.ip2.Agenda;
import ix.ip2.AgendaItem;
import ix.ip2.IssueItem;
import ix.ip2.PanelController;
import ix.ip2.WorldState;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.Function1;
import ix.util.MultiHashMap;
import ix.util.MultiMap;
import ix.util.Name;
import ix.util.Util;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import ix.util.match.Matcher;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class Ip2ModelManager
extends ProcessModelManager {
    public static final Symbol S_WORLD_STATE = Symbol.intern("world-state");
    public static final Symbol S_CONDITION = Symbol.intern("condition");
    public static final Symbol S_EFFECT = Symbol.intern("effect");
    protected PanelController controller;
    protected MultiMap nodeToConditions = new MultiHashMap();
    protected MultiMap nodeToEffects = new MultiHashMap();
    protected WorldState worldState = new WorldState();

    public Ip2ModelManager(PanelController panelController) {
        this.controller = panelController;
    }

    public void reset() {
        super.reset();
        this.nodeToConditions.clear();
        this.nodeToEffects.clear();
        this.worldState.clear();
    }

    public void newBindings(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Variable variable = (Variable)entry.getKey();
            Object v = entry.getValue();
            variable.setValue(v);
        }
        this.fireNewBindings(map);
        this.runSentinels();
    }

    public void addConstraint(Constraint constraint) {
        Debug.assert(constraint.getType() == S_WORLD_STATE);
        Symbol symbol = constraint.getRelation();
        if (symbol != S_EFFECT) {
            throw new RuntimeException("Can't handle " + constraint);
        }
        PatternAssignment patternAssignment = (PatternAssignment)constraint.getParameter(0);
        this.handleEffects(Lisp.list(patternAssignment));
    }

    protected void addConstraint(PNode pNode, Constraint constraint) {
        Debug.assert(constraint.getType() == S_WORLD_STATE);
        Symbol symbol = constraint.getRelation();
        PatternAssignment patternAssignment = (PatternAssignment)constraint.getParameter(0);
        if (symbol == S_CONDITION) {
            this.nodeToConditions.addValue(pNode, patternAssignment);
        } else if (symbol == S_EFFECT) {
            this.nodeToEffects.addValue(pNode, patternAssignment);
        } else {
            throw new RuntimeException("Can't handle " + constraint + " at " + pNode);
        }
    }

    public MatchEnv evalFilters(List list, MatchEnv matchEnv) {
        Debug.assert(!list.isEmpty());
        LList lList = LList.newLList(list);
        return this.filter((PatternAssignment)lList.car(), lList.cdr(), matchEnv);
    }

    protected MatchEnv filter(PatternAssignment patternAssignment, LList lList, MatchEnv matchEnv) {
        Debug.noteln("PMM filter", patternAssignment);
        MatchEnv matchEnv2 = this.filter1(patternAssignment, lList, matchEnv);
        Debug.noteln("result:", matchEnv2);
        return matchEnv2;
    }

    private MatchEnv filter1(PatternAssignment patternAssignment, LList lList, MatchEnv matchEnv) {
        Iterator iterator = this.worldState.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            MatchEnv matchEnv2 = this.matchFilter(patternAssignment, entry, matchEnv);
            if (matchEnv2 == null) continue;
            if (lList.isEmpty()) {
                return matchEnv2;
            }
            matchEnv2 = this.filter((PatternAssignment)lList.car(), lList.cdr(), matchEnv2);
            if (matchEnv2 == null) continue;
            return matchEnv2;
        }
        return null;
    }

    protected MatchEnv matchFilter(PatternAssignment patternAssignment, Map.Entry entry, MatchEnv matchEnv) {
        Debug.noteln("Matching " + patternAssignment + ", " + entry + ", " + matchEnv);
        MatchEnv matchEnv2 = new MatchEnv((Map)matchEnv);
        matchEnv2 = Matcher.match(patternAssignment.getPattern(), entry.getKey(), matchEnv2);
        if (matchEnv2 == null) {
            return null;
        }
        matchEnv2 = Matcher.match(patternAssignment.getValue(), entry.getValue(), matchEnv2);
        return matchEnv2;
    }

    public void statusChanged(PNode pNode) {
        Debug.noteln("PMM sees new status of", pNode);
        if (pNode.getStatus() == Status.COMPLETE) {
            this.handleCompletion(pNode);
        }
    }

    protected void handleCompletion(PNode pNode) {
        List list = (List)this.nodeToEffects.get(pNode);
        if (list == null) {
            return;
        }
        Set set = this.getVarsFromConstraints(list);
        Set set2 = Variable.unboundVarsIn(set);
        if (!set2.isEmpty()) {
            Debug.noteln("Unbound vars on completion of", pNode);
            Debug.noteln("Vars are ", set2);
            JOptionPane.showMessageDialog(null, new Object[]{"Unbound vars on completion of " + pNode, "Vars are: " + set2}, "Warning", 2);
            pNode.setStatus(Status.IMPOSSIBLE);
            this.addSentinel(new BindingSentinel(pNode, set2));
        } else {
            this.handleEffects(pNode, list);
        }
    }

    protected void handleEffects(PNode pNode, List list) {
        this.handleEffects(list);
    }

    protected void handleEffects(List list) {
        HashMap<LList, Object> hashMap = new HashMap<LList, Object>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PatternAssignment patternAssignment = (PatternAssignment)iterator.next();
            LList lList = patternAssignment.getPattern();
            Object object = patternAssignment.getValue();
            Debug.assert(Variable.isFullyBound(lList));
            Debug.assert(Variable.isFullyBound(object));
            this.worldState.put(lList, object);
            hashMap.put(lList, object);
        }
        this.fireStateChange(hashMap);
        this.runSentinels();
    }

    protected Set getVarsFromConstraints(List list) {
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PatternAssignment patternAssignment = (PatternAssignment)iterator.next();
            hashSet.addAll(patternAssignment.getVariables());
        }
        return hashSet;
    }

    public Plan getPlan() {
        return new PlanBuilder().getPlan();
    }

    public void setPlan(Plan plan) {
        new PlanInstaller(plan).installPlan();
    }

    public Variable mapVariableDeclaration(PlanVariableDeclaration planVariableDeclaration) {
        ItemVar itemVar = (ItemVar)planVariableDeclaration.getName();
        if (planVariableDeclaration.getScope() == VariableScope.GLOBAL) {
            Variable variable = this.getVariable(itemVar);
            if (variable == null) {
                variable = new Variable(itemVar);
                this.addVariable(variable);
            }
            return variable;
        }
        return new Variable(itemVar);
    }

    class PlanInstaller {
        Plan plan;

        PlanInstaller(Plan plan) {
            this.plan = plan;
        }

        void installPlan() {
            PNode.computeStatus = false;
            try {
                this.do_installPlan();
                Object var2_1 = null;
                PNode.computeStatus = true;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                PNode.computeStatus = true;
                throw throwable;
            }
        }

        void do_installPlan() {
            TaskItem taskItem;
            Object object;
            Object object2;
            if (this.plan.getWorldState() != null) {
                Ip2ModelManager.this.handleEffects(this.plan.getWorldState());
            }
            Iterator iterator = Collect.iterator(this.plan.getIssues());
            while (iterator.hasNext()) {
                object2 = (Issue)iterator.next();
                Ip2ModelManager.this.controller.addIssue((Issue)object2);
            }
            object2 = Collect.iterator(this.plan.getPlanNodes());
            while (object2.hasNext()) {
                object = (PlanNode)object2.next();
                taskItem = ((PlanNode)object).getActivity();
                Ip2ModelManager.this.controller.addActivity((Activity)taskItem);
                if (((PlanNode)object).getExpansion() == null) continue;
                this.installExpansion((PlanNode)object);
            }
            this.walkInstalledPlan(new PlanWalker(this){
                private final /* synthetic */ PlanInstaller this$1;
                {
                    this.this$1 = planInstaller;
                }

                public void visitActivityItem(ActivityItem activityItem) {
                    Debug.noteln("Visiting", activityItem);
                    activityItem.fireStatusChanged();
                    this.this$1.walkInstalledChildren(activityItem, this);
                }
            });
            object = Collect.iterator(this.plan.getIssues());
            while (object.hasNext()) {
                taskItem = (Issue)object.next();
                IssueItem issueItem = this.getItemForIssue((Issue)taskItem);
                Debug.noteln("Visiting", issueItem);
                issueItem.fireStatusChanged();
            }
        }

        void installExpansion(PlanNode planNode) {
            Object object;
            Activity activity = planNode.getActivity();
            ActivityItem activityItem = this.getItemForActivity(activity);
            PlanRefinement planRefinement = this.plan.getPlanRefinement(planNode.getExpansion());
            Debug.assert(planRefinement.getExpands().equals(planNode.getId()));
            activityItem.varTable = this.makeVarTable(planRefinement.getPlanVariableDeclarations());
            List list = planRefinement.getPlanNodes();
            if (list == null) {
                Debug.assert(planRefinement.getOrderings().isEmpty());
            } else {
                object = this.makeSubitems(activityItem, list);
                this.installSubitems(activityItem, (List)object, list);
                this.installOrderings(activityItem, planRefinement.getOrderings());
            }
            this.installConstraints(activityItem, planRefinement.getWorldStateConstraints());
            object = list.iterator();
            while (object.hasNext()) {
                PlanNode planNode2 = (PlanNode)object.next();
                if (planNode2.getExpansion() == null) continue;
                this.installExpansion(planNode2);
            }
        }

        ActivityItem getItemForActivity(Activity activity) {
            List list = Ip2ModelManager.this.nodes;
            return (ActivityItem)this.findItem(activity, list);
        }

        IssueItem getItemForIssue(Issue issue) {
            List list = Ip2ModelManager.this.controller.getIssueAgenda().getItems();
            return (IssueItem)this.findItem(issue, list);
        }

        AgendaItem findItem(TaskItem taskItem, List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AgendaItem agendaItem = (AgendaItem)iterator.next();
                if (agendaItem.getAbout() != taskItem) continue;
                return agendaItem;
            }
            throw new IllegalArgumentException("Can't find item for " + taskItem);
        }

        void walkInstalledPlan(PlanWalker planWalker) {
            Iterator iterator = Collect.iterator(this.plan.getPlanNodes());
            while (iterator.hasNext()) {
                PlanNode planNode = (PlanNode)iterator.next();
                Activity activity = planNode.getActivity();
                ActivityItem activityItem = this.getItemForActivity(activity);
                planWalker.visitActivityItem(activityItem);
            }
        }

        void walkInstalledChildren(ActivityItem activityItem, PlanWalker planWalker) {
            Iterator iterator = activityItem.children.iterator();
            while (iterator.hasNext()) {
                ActivityItem activityItem2 = (ActivityItem)iterator.next();
                planWalker.visitActivityItem(activityItem2);
            }
        }

        Map makeVarTable(List list) {
            HashMap<Object, Variable> hashMap = new HashMap<Object, Variable>();
            Iterator iterator = Collect.iterator(list);
            while (iterator.hasNext()) {
                Variable variable = (Variable)iterator.next();
                hashMap.put(variable.getName(), variable);
            }
            return hashMap;
        }

        List makeSubitems(ActivityItem activityItem, List list) {
            LinkedList<ActivityItem> linkedList = new LinkedList<ActivityItem>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PlanNode planNode = (PlanNode)iterator.next();
                Activity activity = planNode.getActivity();
                linkedList.add(new ActivityItem(activityItem, activity));
            }
            return linkedList;
        }

        void installSubitems(ActivityItem activityItem, List list, List list2) {
            Map map;
            activityItem.nameToChildMap = map = this.makeNameToChildMap(list, list2);
            activityItem.children = list;
            Agenda agenda = Ip2ModelManager.this.controller.getActivityAgenda();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ActivityItem activityItem2 = (ActivityItem)iterator.next();
                Debug.assert(activityItem2.parent == activityItem);
                Debug.assert(activityItem2.level == activityItem.level + 1);
                agenda.addItem(activityItem2);
            }
        }

        Map makeNameToChildMap(List list, List list2) {
            Debug.assert(list.size() == list2.size());
            HashMap<Name, ActivityItem> hashMap = new HashMap<Name, ActivityItem>();
            Iterator iterator = list.iterator();
            Iterator iterator2 = list2.iterator();
            while (iterator.hasNext()) {
                ActivityItem activityItem = (ActivityItem)iterator.next();
                PlanNode planNode = (PlanNode)iterator2.next();
                hashMap.put(planNode.getId(), activityItem);
            }
            return hashMap;
        }

        void installOrderings(ActivityItem activityItem, List list) {
            if (!list.isEmpty()) {
                activityItem.processOrderings(list);
            }
        }

        void installConstraints(ActivityItem activityItem, List list) {
            Iterator iterator = Collect.iterator(list);
            while (iterator.hasNext()) {
                Constraint constraint = (Constraint)iterator.next();
                Ip2ModelManager.this.addConstraint(activityItem, constraint);
            }
        }
    }

    static interface PlanWalker {
        public void visitActivityItem(ActivityItem var1);
    }

    class PlanBuilder {
        Util.NameGenerator nameGen = new Util.NameGenerator();
        Plan plan;
        List topNodes;
        List refinements;
        Map varToDclMap;
        static /* synthetic */ Class class$ix$ip2$IssueItem;

        PlanBuilder() {
        }

        Plan getPlan() {
            this.buildPlan();
            return this.plan;
        }

        Plan buildPlan() {
            this.plan = new Plan();
            this.topNodes = new LinkedList();
            this.refinements = new LinkedList();
            this.varToDclMap = new HashMap();
            List list = this.getVariables(Ip2ModelManager.this.varEnv);
            List list2 = this.makeVariableDeclarations(list);
            this.extendMap(this.varToDclMap, list, list2);
            List list3 = this.getIssues();
            List list4 = this.getWorldState();
            this.walkNodes();
            if (!list2.isEmpty()) {
                this.plan.setPlanVariableDeclarations(list2);
            }
            if (!list3.isEmpty()) {
                this.plan.setIssues(list3);
            }
            if (!this.topNodes.isEmpty()) {
                this.plan.setPlanNodes(this.topNodes);
            }
            if (!this.refinements.isEmpty()) {
                this.plan.setPlanRefinements(this.refinements);
            }
            if (!list4.isEmpty()) {
                this.plan.setWorldState(list4);
            }
            this.plan.setVarToDclMap(this.varToDclMap);
            return this.plan;
        }

        Name genId(String string) {
            return Name.valueOf(this.nameGen.nextName(string));
        }

        List getVariables(Map map) {
            LinkedList linkedList = new LinkedList(Variable.getAllVariables());
            linkedList.retainAll(map.values());
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Variable variable = (Variable)iterator.next();
                if (variable.getValue() == null) continue;
                iterator.remove();
            }
            return linkedList;
        }

        List makeVariableDeclarations(List list) {
            return (List)Collect.map(list, new Function1(this){
                private final /* synthetic */ PlanBuilder this$1;
                {
                    this.this$1 = planBuilder;
                }

                public Object funcall(Object object) {
                    Variable variable = (Variable)object;
                    return new PlanVariableDeclaration(this.this$1.genId("var"), variable);
                }
            });
        }

        Map extendMap(Map map, Collection collection, Collection collection2) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = collection2.iterator();
            while (iterator.hasNext() & iterator2.hasNext()) {
                Object e = iterator.next();
                Object e2 = iterator2.next();
                if (map.get(e) != null) {
                    throw new IllegalArgumentException("key already present");
                }
                map.put(e, e2);
            }
            Debug.assert(!iterator.hasNext() && !iterator2.hasNext());
            return map;
        }

        List getIssues() {
            List list = Ip2ModelManager.this.controller.getIssueAgenda().getItems();
            List list2 = (List)Collect.map(list, Fn.accessor(class$ix$ip2$IssueItem == null ? (class$ix$ip2$IssueItem = PlanBuilder.class$("ix.ip2.IssueItem")) : class$ix$ip2$IssueItem, "getAbout"));
            return list2;
        }

        List getWorldState() {
            return PatternAssignment.mapToAssignments(Ip2ModelManager.this.worldState);
        }

        void walkNodes() {
            Iterator iterator = Ip2ModelManager.this.nodes.iterator();
            while (iterator.hasNext()) {
                ActivityItem activityItem = (ActivityItem)iterator.next();
                if (activityItem.level != 0) continue;
                this.walkTopNode(activityItem);
            }
        }

        void walkTopNode(ActivityItem activityItem) {
            Activity activity = (Activity)activityItem.getAbout();
            PlanNode planNode = new PlanNode(this.genId("node"), activity);
            this.topNodes.add(planNode);
            if (activityItem.isExpanded()) {
                this.buildExpansion(activityItem, planNode);
            }
        }

        void buildExpansion(ActivityItem activityItem, PlanNode planNode) {
            Object object;
            List list;
            PlanRefinement planRefinement = new PlanRefinement();
            planRefinement.setId(this.genId("refine"));
            this.refinements.add(planRefinement);
            planNode.setExpansion(planRefinement.getId());
            planRefinement.setExpands(planNode.getId());
            List list2 = this.getVariables(activityItem.varTable);
            if (!list2.isEmpty()) {
                list = this.makeVariableDeclarations(list2);
                this.extendMap(this.varToDclMap, list2, list);
                planRefinement.setPlanVariableDeclarations(list);
            }
            list = activityItem.children;
            LinkedList<PlanNode> linkedList = new LinkedList<PlanNode>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (ActivityItem)iterator.next();
                Activity activity = (Activity)((AgendaItem)object).getAbout();
                PlanNode planNode2 = new PlanNode(this.genId(planNode.getId().toString()), activity);
                linkedList.add(planNode2);
                if (!((PNode)object).isExpanded()) continue;
                this.buildExpansion((ActivityItem)object, planNode2);
            }
            if (!linkedList.isEmpty()) {
                planRefinement.setPlanNodes(linkedList);
            }
            object = new LinkedList();
            object.addAll(this.buildOrderings(list, linkedList));
            object.addAll(this.buildConstraints(S_WORLD_STATE, S_CONDITION, (List)Ip2ModelManager.this.nodeToConditions.get(activityItem)));
            object.addAll(this.buildConstraints(S_WORLD_STATE, S_EFFECT, (List)Ip2ModelManager.this.nodeToEffects.get(activityItem)));
            if (!object.isEmpty()) {
                planRefinement.setConstraints((List)object);
            }
        }

        List buildOrderings(List list, List list2) {
            Object object;
            Object object2;
            Debug.assert(list.size() == list2.size());
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            Iterator iterator = list.iterator();
            Iterator iterator2 = list2.iterator();
            while (iterator.hasNext()) {
                object2 = (ActivityItem)iterator.next();
                object = (PlanNode)iterator2.next();
                hashMap.put(object2, object);
            }
            object2 = new LinkedList();
            object = list.iterator();
            while (object.hasNext()) {
                ActivityItem activityItem = (ActivityItem)object.next();
                PlanNode planNode = (PlanNode)hashMap.get(activityItem);
                Iterator iterator3 = activityItem.postNodes.iterator();
                while (iterator3.hasNext()) {
                    ActivityItem activityItem2 = (ActivityItem)iterator3.next();
                    PlanNode planNode2 = (PlanNode)hashMap.get(activityItem2);
                    object2.add(this.buildOrdering(planNode, planNode2));
                }
            }
            return object2;
        }

        Ordering buildOrdering(PlanNode planNode, PlanNode planNode2) {
            return new Ordering(new NodeEndRef(End.END, planNode.getId()), new NodeEndRef(End.BEGIN, planNode2.getId()));
        }

        List buildConstraints(Symbol symbol, Symbol symbol2, List list) {
            LinkedList<Constraint> linkedList = new LinkedList<Constraint>();
            if (list == null) {
                return linkedList;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PatternAssignment patternAssignment = (PatternAssignment)iterator.next();
                linkedList.add(new Constraint(symbol, symbol2, Lisp.list(patternAssignment)));
            }
            return linkedList;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    protected class BindingSentinel
    implements ProcessModelManager.Sentinel {
        PNode node;
        Set unbound;

        BindingSentinel(PNode pNode, Set set) {
            this.node = pNode;
            this.unbound = new HashSet(set);
        }

        public boolean isReady() {
            Debug.noteln("Testing BindingSentinel for", this.node);
            Set set = Variable.unboundVarsIn(this.unbound);
            return set.isEmpty();
        }

        public void run() {
            Debug.noteln("Able to complete", this.node);
            Debug.noteln("Because all variables bound.");
            this.node.setStatus(Status.COMPLETE);
        }
    }
}

