/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.ichat.ChatFrame;
import ix.iface.util.IconImage;
import ix.ip2.AgendaViewer;
import ix.ip2.Ip2;
import ix.ip2.PanelFrame;
import ix.ip2.StateViewer;
import ix.ispace.IspaceTool;
import ix.itest.SendPanel;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class Ip2Frame
extends PanelFrame
implements ActionListener {
    Container contentPane;
    ChatFrame chatFrame;
    IspaceTool ispaceTool;
    AgendaViewer activityViewer;
    AgendaViewer issueViewer;
    StateViewer stateViewer;
    Ip2 ip2;
    JMenu fileMenu = new JMenu("File");
    JMenu newMenu = new JMenu("New");
    JMenu toolsMenu = new JMenu("Tools");
    JSplitPane split1 = new JSplitPane(0);
    JSplitPane split2 = new JSplitPane(0);

    public Ip2Frame(Ip2 ip2) {
        super(ip2);
        this.ip2 = ip2;
    }

    protected void setUp() {
        ((Frame)this).setIconImage(IconImage.getIconImage(this));
        this.activityViewer = this.ip2.activityViewer;
        this.issueViewer = this.ip2.issueViewer;
        this.stateViewer = this.ip2.stateViewer;
        this.contentPane = this.getContentPane();
        ((Component)this).setSize(500, 400);
        this.setJMenuBar(this.makeMenuBar());
        JPanel jPanel = new JPanel();
        jPanel.add((Component)((Object)this.issueViewer));
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Issues"));
        JPanel jPanel2 = new JPanel();
        jPanel2.add((Component)((Object)this.activityViewer));
        JScrollPane jScrollPane2 = new JScrollPane(jPanel2);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("Activities"));
        JPanel jPanel3 = new JPanel();
        jPanel3.add((Component)((Object)this.stateViewer));
        JScrollPane jScrollPane3 = new JScrollPane(jPanel3);
        jScrollPane3.setBorder(BorderFactory.createTitledBorder("State"));
        this.split1.setTopComponent(jScrollPane);
        this.split1.setBottomComponent(this.split2);
        this.split2.setTopComponent(jScrollPane2);
        this.split2.setBottomComponent(jScrollPane3);
        this.contentPane.add(this.split1);
        this.contentPane.add((Component)this.ip2.makeLogoPanel(), "South");
    }

    protected void becomeVisible() {
        if (Parameters.haveParameter("frame-size")) {
            Dimension dimension = Parameters.getDimension("frame-size");
            this.pack();
            ((Component)this).setSize(dimension);
        } else {
            this.setReasonableSize();
        }
        super.validate();
        this.split1.setDividerLocation(0.33);
        this.split2.setDividerLocation(0.55);
        ((Component)this).setVisible(true);
    }

    protected void setReasonableSize() {
        Dimension dimension = this.getSize();
        int n = (int)Math.round(dimension.getHeight());
        this.pack();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension3 = this.getSize();
        int n2 = (int)Math.round(dimension3.getWidth());
        int n3 = (int)Math.round(dimension3.getHeight());
        int n4 = (int)(0.875 * dimension2.getHeight());
        int n5 = 30;
        int n6 = Math.max(Math.min(n3, n4), n);
        if (n3 != n6) {
            ((Component)this).setSize(new Dimension(n2 + n5, n6));
        }
    }

    protected void ensureDomainEditor() {
        if (this.domainEditor == null) {
            this.domainEditor = this.makeDomainEditor(this.ip2, this.ip2.domain);
        }
        this.domainEditor.setVisible(true);
    }

    public SendPanel getSendPanel() {
        this.ensureChatExists();
        return this.chatFrame.getSendPanel();
    }

    public void ensureChat() {
        this.ensureChatExists();
        this.chatFrame.setVisible(true);
    }

    public void ensureChatExists() {
        if (this.chatFrame == null) {
            this.chatFrame = new ChatFrame(this.ip2, this.ip2.getAgentDisplayName() + " Messenger");
        }
    }

    public void ensureIspaceTool() {
        if (this.ispaceTool == null) {
            this.ispaceTool = new IspaceTool(this.ip2);
        }
        this.ispaceTool.setVisible(true);
    }

    protected JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.fileMenu);
        this.fileMenu.add(this.makeMenuItem("Load Plan From ..."));
        this.fileMenu.add(this.makeMenuItem("Save Plan As ..."));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.makeMenuItem("Reset"));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.makeMenuItem("Exit"));
        jMenuBar.add(this.newMenu);
        this.newMenu.add(this.makeMenuItem("New Issue"));
        this.newMenu.add(this.makeMenuItem("New Activity"));
        jMenuBar.add(this.toolsMenu);
        this.toolsMenu.add(this.makeMenuItem("Domain Editor"));
        this.toolsMenu.add(this.makeMenuItem("I-Space"));
        this.toolsMenu.add(this.makeMenuItem("Messenger"));
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(this.testMenu);
        this.testMenu.setEnabled(false);
        this.ip2.addTestMenuItems();
        return jMenuBar;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("I-P2 action:", string);
        if (string.equals("Exit")) {
            if (Util.dialogConfirms(null, "Are you sure you want to exit?")) {
                System.exit(0);
            }
        } else if (string.equals("Reset")) {
            if (Util.dialogConfirms(null, "Are you sure you want to reset?")) {
                this.ip2.reset();
            }
        } else if (string.equals("Load Plan From ...")) {
            this.ip2.loadPlan();
        } else if (string.equals("Save Plan As ...")) {
            this.ip2.savePlanAs();
        } else if (string.equals("New Issue")) {
            this.issueViewer.getNewItemFromUser();
        } else if (string.equals("New Activity")) {
            this.activityViewer.getNewItemFromUser();
        } else if (string.equals("Domain Editor")) {
            this.ensureDomainEditor();
        } else if (string.equals("Messenger")) {
            this.ensureChat();
        } else if (string.equals("I-Space")) {
            this.ensureIspaceTool();
        } else {
            Debug.noteln("Nothing to do for", string);
        }
    }
}

