/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.ichat.ChatMessage;
import ix.icore.Activity;
import ix.icore.IXAgent;
import ix.icore.Issue;
import ix.icore.Report;
import ix.icore.ReportType;
import ix.icore.Status;
import ix.icore.TaskItem;
import ix.icore.YesNo;
import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.process.ProcessModelManager;
import ix.icore.process.state.Plan;
import ix.icore.process.state.PlanLoader;
import ix.icore.process.state.PlanSaver;
import ix.iface.domain.DomainParser;
import ix.iface.util.LogoPanel;
import ix.iface.util.Reporting;
import ix.ip2.ActivityHandler;
import ix.ip2.ActivityTableViewer;
import ix.ip2.ActivityViewTable;
import ix.ip2.AgendaItem;
import ix.ip2.AgendaViewer;
import ix.ip2.ForwardingHandler;
import ix.ip2.InvokeHandler;
import ix.ip2.Ip2Frame;
import ix.ip2.IssueHandler;
import ix.ip2.IssueTableViewer;
import ix.ip2.IssueViewTable;
import ix.ip2.NewIp2Frame;
import ix.ip2.PanelController;
import ix.ip2.StateViewTable;
import ix.ip2.StateViewer;
import ix.ip2.event.AgendaListener;
import ix.ispace.AgentData;
import ix.ispace.AgentRelationship;
import ix.ispace.VerbCapability;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Name;
import ix.util.Parameters;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class Ip2
extends IXAgent {
    protected Domain domain = new Domain();
    protected PanelController controller = new PanelController(this);
    protected Ip2Frame frame;
    boolean classic;
    AgendaViewer activityViewer;
    AgendaViewer issueViewer;
    StateViewer stateViewer;
    protected String logoLine1 = "I-X Process Panel";
    protected String logoLine2 = "Based on I-X Technology";
    protected String logoImage = "ip2-logo.gif";
    protected String domainName = null;

    public Ip2() {
        this.displayName = "Process Panel";
    }

    public static void main(String[] stringArray) {
        Util.printGreeting("I-P2");
        new Ip2().mainStartup(stringArray);
    }

    protected void processCommandLineArguments() {
        super.processCommandLineArguments();
        this.logoLine1 = Parameters.getParameter("logo-line-1", this.logoLine1);
        this.logoLine2 = Parameters.getParameter("logo-line-2", this.logoLine2);
        this.logoImage = Parameters.getParameter("logo-image", this.logoImage);
        this.classic = Parameters.getBoolean("classic", false);
        if (Parameters.haveParameter("domain")) {
            this.domainName = Parameters.getParameter("domain");
        }
    }

    public void startup() {
        this.activityViewer = this.makeActivityViewer();
        this.issueViewer = this.makeIssueViewer();
        this.stateViewer = this.makeStateViewer();
        this.controller.addActivityListener((AgendaListener)((Object)this.activityViewer));
        this.controller.addIssueListener((AgendaListener)((Object)this.issueViewer));
        this.addIssueHandlers();
        this.controller.setDomain(this.domain);
        this.readDomain(this.domain);
        this.controller.modelManager.addProcessStatusListener(this.stateViewer);
        this.frame = this.classic ? new Ip2Frame(this) : new NewIp2Frame(this);
        this.frame.setUp();
        this.frame.becomeVisible();
        String string = Parameters.getParameter("plan");
        if (string != null) {
            this.loadPlan(string);
        }
    }

    protected AgendaViewer makeActivityViewer() {
        if (this.classic) {
            return new ActivityViewTable(this);
        }
        return new ActivityTableViewer(this);
    }

    protected AgendaViewer makeIssueViewer() {
        if (this.classic) {
            return new IssueViewTable(this);
        }
        return new IssueTableViewer(this);
    }

    protected StateViewer makeStateViewer() {
        return new StateViewTable(this);
    }

    protected void readDomain(Domain domain) {
        if (this.domainName != null) {
            try {
                DomainParser.makeParser(this.domainName).readDomain(domain);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                throw new RuntimeException("Problem with domain");
            }
        }
    }

    protected JPanel makeLogoPanel() {
        ImageIcon imageIcon = Parameters.haveParameter("logo-image") ? new ImageIcon(this.logoImage) : Util.resourceImageIcon(this.logoImage);
        return new LogoPanel(this.symbolName, this.logoLine1, this.logoLine2, imageIcon);
    }

    protected void addTestMenuItems() {
        if (Parameters.haveParameter("test-menu")) {
            this.frame.addTests(Parameters.getParameter("test-menu"));
        }
    }

    public void reset() {
        this.controller.reset();
        this.activityViewer.reset();
        this.issueViewer.reset();
        this.stateViewer.reset();
        this.frame.validate();
    }

    public void loadPlan() {
        ProcessModelManager processModelManager = this.controller.modelManager;
        Plan plan = (Plan)new PlanLoader(this.frame, processModelManager).loadObject();
        if (plan != null) {
            processModelManager.setPlan(plan);
        }
    }

    public void loadPlan(String string) {
        ProcessModelManager processModelManager = this.controller.modelManager;
        Plan plan = (Plan)new PlanLoader(this.frame, processModelManager).loadObject(string);
        if (plan != null) {
            processModelManager.setPlan(plan);
        }
    }

    public void savePlanAs() {
        Plan plan = this.controller.modelManager.getPlan();
        new PlanSaver(this.frame).saveObject(plan);
    }

    public void handleNewIssue(Issue issue) {
        this.handleReceivedReport(issue);
        this.controller.addIssue(issue);
    }

    public void handleNewActivity(Activity activity) {
        this.handleReceivedReport(activity);
        this.controller.addActivity(activity);
    }

    private void handleReceivedReport(TaskItem taskItem) {
        if (taskItem.getReportBack() == YesNo.YES) {
            Name name = Name.valueOf(this.getAgentIPCName());
            Report report = new Report();
            report.setReportType(ReportType.PROGRESS);
            report.setText("Received by " + name + ", " + Reporting.dateString());
            report.setRef(taskItem.getRef());
            report.setSenderId(name);
            IPC.sendObject(taskItem.getSenderId().toString(), report);
        }
    }

    public void handleNewConstraint(Constraint constraint) {
        this.controller.modelManager.addConstraint(constraint);
    }

    public void handleNewReport(Report report) {
        this.controller.newReport(report);
    }

    public void handleNewChatMessage(ChatMessage chatMessage) {
        this.frame.ensureChat();
        this.frame.chatFrame.newMessage(chatMessage);
    }

    protected void addIssueHandlers() {
        this.controller.addIssueHandler(new IssueToActivityHandler());
        this.controller.addItemHandler(new InvokeHandler(this));
        this.addForwardingHandler("Escalate", AgentRelationship.SUPERIOR, true);
        this.addForwardingHandler("Pass", AgentRelationship.PEER, true);
        this.addForwardingHandler("Delegate", AgentRelationship.SUBORDINATE, true);
        this.controller.addActivityHandler(new ConnectHandler());
        this.controller.addActivityHandler(new SetCapabilitiesHandler());
    }

    public void addForwardingHandler(String string, AgentRelationship agentRelationship, boolean bl) {
        this.controller.addItemHandler(new ForwardingHandler(this, string, agentRelationship, bl));
    }

    public class SetCapabilitiesHandler
    extends ActivityHandler {
        Symbol S_SET_CAPABILITIES = Symbol.intern("set-capabilities");

        public SetCapabilitiesHandler() {
            super("Set agent capabilities");
        }

        public boolean appliesTo(AgendaItem agendaItem) {
            LList lList = agendaItem.getPattern();
            return lList.length() == 3 && lList.get(0) == this.S_SET_CAPABILITIES;
        }

        public void handle(AgendaItem agendaItem) {
            LList lList = agendaItem.getPattern();
            String string = lList.get(1).toString();
            List list = (List)lList.get(2);
            List list2 = this.makeVerbCapabilities(list);
            Ip2.this.contactManager.noteAgent(string);
            Ip2.this.contactManager.setCapabilities(string, list2);
            agendaItem.setStatus(Status.COMPLETE);
        }

        List makeVerbCapabilities(List list) {
            LinkedList<VerbCapability> linkedList = new LinkedList<VerbCapability>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof String) && !(e instanceof Symbol)) {
                    throw new IllegalArgumentException("Invalid verb " + e);
                }
                linkedList.add(VerbCapability.from(e.toString()));
            }
            return linkedList;
        }
    }

    public class ConnectHandler
    extends ActivityHandler {
        Symbol S_CONNECT = Symbol.intern("connect");

        public ConnectHandler() {
            super("Connect agent");
        }

        public boolean appliesTo(AgendaItem agendaItem) {
            LList lList = agendaItem.getPattern();
            return lList.length() == 3 && lList.get(0) == this.S_CONNECT;
        }

        public void handle(AgendaItem agendaItem) {
            LList lList = agendaItem.getPattern();
            String string = lList.get(1).toString();
            String string2 = lList.get(2).toString();
            AgentRelationship agentRelationship = AgentRelationship.valueOf(string2);
            AgentData agentData = Ip2.this.contactManager.getAgentData(string);
            if (agentData == null) {
                Ip2.this.contactManager.addAgent(string, agentRelationship);
            } else if (agentData.getRelationship() != agentRelationship) {
                Ip2.this.contactManager.changeRelationship(string, agentRelationship);
            }
            agendaItem.setStatus(Status.COMPLETE);
        }
    }

    public class IssueToActivityHandler
    extends IssueHandler {
        public IssueToActivityHandler() {
            super("Perform as activity");
        }

        public void handle(AgendaItem agendaItem) {
            Issue issue = (Issue)agendaItem.getAbout();
            Activity activity = new Activity(issue.getPattern());
            activity.setSenderId(issue.getSenderId());
            activity.setPriority(issue.getPriority());
            activity.setReportBack(issue.getReportBack());
            activity.setRef(issue.getRef());
            Ip2.this.controller.getIssueAgenda().removeItem(agendaItem);
            Ip2.this.controller.addActivity(activity);
        }
    }
}

