/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Status;
import ix.ip2.AgendaItem;
import ix.ip2.ItemHandler;
import ix.util.Debug;

public class HandlerAction {
    protected String shortDescription;

    HandlerAction() {
    }

    public void handle(AgendaItem agendaItem) {
        Debug.noteln("HandlerAction " + this.shortDescription + " handling item " + agendaItem);
        agendaItem.setStatus(Status.COMPLETE);
    }

    public boolean isStillValid() {
        return true;
    }

    public boolean isReady() {
        return true;
    }

    public void computeStatus() {
    }

    public String getActionDescription() {
        return this.shortDescription;
    }

    public String toString() {
        return "HandlerAction[" + this.shortDescription + "]";
    }

    static class NotApplicable
    extends Manual {
        public NotApplicable() {
            this.shortDescription = "N/A";
        }
    }

    static class Manual
    extends HandlerAction {
        public Manual() {
            this.shortDescription = "Done";
        }

        public Manual(String string) {
            this.shortDescription = "Done using " + string;
        }
    }

    public static class Automatic
    extends HandlerAction {
        ItemHandler handler;

        public Automatic(ItemHandler itemHandler) {
            this(itemHandler, itemHandler.getActionDescription());
        }

        public Automatic(ItemHandler itemHandler, String string) {
            this.handler = itemHandler;
            this.shortDescription = string;
        }

        public void handle(AgendaItem agendaItem) {
            Debug.noteln("Giving issue to handler", this.handler);
            this.handler.handle(agendaItem);
        }
    }

    static class NoAction
    extends HandlerAction {
        public NoAction() {
            this.shortDescription = "No Action";
        }

        public void handle(AgendaItem agendaItem) {
            Debug.noteln("No action for", agendaItem);
        }
    }
}

