/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.IXAgent;
import ix.icore.Status;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.ItemHandler;
import ix.ispace.AgentData;
import ix.ispace.AgentRelationship;
import ix.ispace.ContactManager;
import ix.ispace.VerbCapability;
import ix.ispace.event.ContactEvent;
import ix.ispace.event.ContactListener;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Fn;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ForwardingHandler
extends ItemHandler
implements ContactListener {
    protected IXAgent agent;
    protected String action;
    protected AgentRelationship rel;
    protected boolean reportBack;
    protected boolean capabilityDefault = true;
    protected ContactManager contactManager;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$ix$ispace$AgentData;

    public ForwardingHandler(IXAgent iXAgent, String string, AgentRelationship agentRelationship, boolean bl) {
        super(string + " to " + agentRelationship + " agents");
        this.agent = iXAgent;
        this.action = string;
        this.rel = agentRelationship;
        this.reportBack = bl;
        this.contactManager = iXAgent.getContactManager();
        this.contactManager.addContactListener(this);
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        List list = this.getToNames(agendaItem);
        Debug.noteln(this + " adding actions for agents " + list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            agendaItem.addAction(this.makeForwardingAction(string, agendaItem));
        }
    }

    public ForwardingAction makeForwardingAction(String string, AgendaItem agendaItem) {
        return new ForwardingAction(string, agendaItem);
    }

    protected List getToNames(AgendaItem agendaItem) {
        return (List)Collect.map(class$java$util$LinkedList == null ? (class$java$util$LinkedList = ForwardingHandler.class$("java.util.LinkedList")) : class$java$util$LinkedList, this.getToAgents(agendaItem), Fn.accessor(class$ix$ispace$AgentData == null ? (class$ix$ispace$AgentData = ForwardingHandler.class$("ix.ispace.AgentData")) : class$ix$ispace$AgentData, "getName"));
    }

    public List getToAgents(AgendaItem agendaItem) {
        VerbCapability verbCapability = VerbCapability.from(agendaItem.getPattern());
        List list = this.contactManager.getAgentData(this.rel);
        List list2 = this.contactManager.getAgentData(verbCapability, this.capabilityDefault);
        Debug.noteln("Agents with " + this.rel, list);
        Debug.noteln("Agents with " + verbCapability, list2);
        if (list == null || list2 == null) {
            return Collections.EMPTY_LIST;
        }
        return (List)Collect.intersection(list, list2);
    }

    public void handle(AgendaItem agendaItem) {
        throw new Error(this + " called directly");
    }

    public void contactChange(ContactEvent contactEvent) {
        AgentData agentData;
        AgentRelationship agentRelationship;
        if ((contactEvent.isNewContact() || contactEvent.isRelationshipChange() || contactEvent.isCapabilityChange()) && (agentRelationship = (agentData = contactEvent.getNewData()).getRelationship()) == this.rel) {
            Debug.noteln("Possible new forwarding target", agentData);
            ((Ip2)this.agent).controller.reconsiderHandler(this, contactEvent);
        }
    }

    public void reviseHandlerActions(AgendaItem agendaItem, Object object) {
        String string;
        ForwardingAction forwardingAction;
        ContactEvent contactEvent = (ContactEvent)object;
        AgentData agentData = contactEvent.getNewData();
        Debug.assert(agentData.getRelationship() == this.rel);
        if (agentData.hasCapability(VerbCapability.from(agendaItem.getPattern()), this.capabilityDefault) && agendaItem.findAction((forwardingAction = this.makeForwardingAction(string = agentData.getName(), agendaItem)).getActionDescription()) == null) {
            agendaItem.addAction(forwardingAction);
        }
    }

    public String toString() {
        return "ForwardingHandler[" + this.getActionDescription() + "]";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ForwardingAction
    extends HandlerAction {
        String toName;
        AgendaItem about;
        VerbCapability requiredCapability;

        ForwardingAction(String string, AgendaItem agendaItem) {
            this.toName = string;
            this.shortDescription = ForwardingHandler.this.action + " to " + string;
            this.about = agendaItem;
            this.requiredCapability = VerbCapability.from(agendaItem.getPattern());
        }

        public void handle(AgendaItem agendaItem) {
            Debug.assert(agendaItem == this.about);
            agendaItem.getAbout().forwardTo(this.toName, ForwardingHandler.this.reportBack);
            agendaItem.setStatus(ForwardingHandler.this.reportBack ? Status.EXECUTING : Status.COMPLETE);
        }

        public boolean isStillValid() {
            AgentData agentData = ForwardingHandler.this.contactManager.getAgentData(this.toName);
            return agentData != null && agentData.getRelationship() == ForwardingHandler.this.rel && agentData.hasCapability(this.requiredCapability, ForwardingHandler.this.capabilityDefault);
        }
    }
}

