/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.IXAgent;
import ix.icore.Variable;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.GridColumn;
import ix.iface.util.ToolFrame;
import ix.util.Debug;
import ix.util.lisp.Lisp;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BindingViewer
implements ActionListener {
    protected IXAgent agent;
    protected Set vars;
    protected Runnable whenFinished;
    protected JFrame frame;
    protected Container contentPane;
    protected VarPanel varPanel;
    protected Map newBindings;

    public BindingViewer(IXAgent iXAgent, Set set, Runnable runnable) {
        this.agent = iXAgent;
        this.vars = set;
        this.whenFinished = runnable;
        this.setUpFrame();
    }

    protected void setUpFrame() {
        this.frame = new ToolFrame(this.agent.getAgentDisplayName() + " Variable Binder");
        this.contentPane = this.frame.getContentPane();
        this.varPanel = new VarPanel(this.vars);
        this.contentPane.add((Component)this.varPanel, "Center");
        this.contentPane.add((Component)new ButtonPanel(), "South");
        this.frame.pack();
        ((Component)this.frame).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("BindingViewer action:", string);
        if (string.equals("Bind")) {
            this.newBindings = this.varPanel.getBindings();
            ((Component)this.frame).setVisible(false);
            this.whenFinished.run();
        } else if (string.equals("Cancel")) {
            Debug.assert(this.newBindings == null);
            ((Component)this.frame).setVisible(false);
            this.whenFinished.run();
        } else {
            Debug.noteln("Nothing to do for", string);
        }
    }

    class ButtonPanel
    extends JPanel {
        ButtonPanel() {
            this.add(this.makeButton("Bind"));
            this.add(this.makeButton("Cancel"));
        }

        protected JButton makeButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(CatchingActionListener.listener(BindingViewer.this));
            return jButton;
        }
    }

    class VarPanel
    extends JPanel {
        GridColumn varColumn = new GridColumn("Variable");
        GridColumn valColumn = new GridColumn("Value");
        Map varFields = new HashMap();
        List varList;

        VarPanel(Set set) {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(BorderFactory.createTitledBorder("Variables"));
            this.add(this.varColumn);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.valColumn);
            this.varList = new LinkedList(set);
            Collections.sort(this.varList);
            Iterator iterator = this.varList.iterator();
            while (iterator.hasNext()) {
                Variable variable = (Variable)iterator.next();
                JTextField jTextField = new JTextField(variable.getName().toString());
                JTextField jTextField2 = new JTextField(20);
                jTextField.setEditable(false);
                this.varFields.put(variable, jTextField2);
                this.varColumn.add(jTextField);
                this.valColumn.add(jTextField2);
            }
        }

        Map getBindings() {
            HashMap<Variable, Object> hashMap = new HashMap<Variable, Object>();
            Iterator iterator = this.varList.iterator();
            while (iterator.hasNext()) {
                Variable variable = (Variable)iterator.next();
                JTextField jTextField = (JTextField)this.varFields.get(variable);
                String string = jTextField.getText().trim();
                if (string.equals("")) continue;
                Object object = Lisp.readFromString(string);
                hashMap.put(variable, object);
            }
            return hashMap;
        }
    }
}

