/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Activity;
import ix.icore.Issue;
import ix.icore.Priority;
import ix.icore.Status;
import ix.icore.YesNo;
import ix.icore.domain.Refinement;
import ix.iface.ui.DefaultColourField;
import ix.iface.ui.TablePopupMenu;
import ix.iface.ui.table.IXTreeTable;
import ix.iface.ui.table.IXTreeTableNode;
import ix.ip2.AgendaItem;
import ix.ip2.AgendaItemTableModel;
import ix.ip2.AgendaManager;
import ix.ip2.AgendaViewer;
import ix.ip2.BindingViewer;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.ItemEditor;
import ix.ip2.event.AgendaEvent;
import ix.ip2.event.AgendaListener;
import ix.iview.util.PriorityRenderer;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.TwoKeyHashMap;
import ix.util.Util;
import ix.util.lisp.LList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public abstract class AgendaTableViewer
extends IXTreeTable
implements AgendaViewer,
AgendaListener {
    protected Ip2 ip2;
    AgendaManager agendaManager;
    ItemEditor itemEditor;
    AgendaItemTableModel model;
    private static final ImageIcon editableIcon = Util.resourceImageIcon("ix-symbol-editable.gif");
    final PriorityPopupMenu priorityPopup = new PriorityPopupMenu();
    private TableCellEditor mouseableEditor;
    private TwoKeyHashMap actionShadowingTable = new TwoKeyHashMap();
    static /* synthetic */ Class class$ix$icore$Priority;
    static /* synthetic */ Class class$ix$iview$util$EditablePriority;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$ix$ip2$HandlerAction$NoAction;

    public AgendaTableViewer(Ip2 ip2) {
        this.ip2 = ip2;
        this.setupAgendaTable();
        this.addMouseListener(new AgendaTableMouser());
        this.setParentsBold(true);
    }

    private void setupAgendaTable() {
        this.model = new AgendaItemTableModel(this);
        this.setModel(this.model);
        this.setAgendaRenderersNEditors();
        this.setPreferredScrollableViewportSize(new Dimension(500, 90));
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
    }

    private void setAgendaRenderersNEditors() {
        PriorityRenderer priorityRenderer = new PriorityRenderer(false);
        priorityRenderer.setToolTipText("Click for choices");
        this.setDefaultRenderer(class$ix$icore$Priority == null ? (class$ix$icore$Priority = AgendaTableViewer.class$("ix.icore.Priority")) : class$ix$icore$Priority, priorityRenderer);
        this.setDefaultRenderer(class$ix$iview$util$EditablePriority == null ? (class$ix$iview$util$EditablePriority = AgendaTableViewer.class$("ix.iview.util.EditablePriority")) : class$ix$iview$util$EditablePriority, priorityRenderer);
        JTextField jTextField = new JTextField();
        jTextField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = AgendaTableViewer.this.rowAtPoint(mouseEvent.getPoint());
                int n2 = AgendaTableViewer.this.columnAtPoint(mouseEvent.getPoint());
                AgendaItem agendaItem = (AgendaItem)AgendaTableViewer.this.model.getRowObject(n);
                if (agendaItem == null) {
                    Debug.noteln("Clicked on empty item");
                    return;
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    ItemPopupMenu itemPopupMenu = new ItemPopupMenu(agendaItem);
                    itemPopupMenu.noticeItemState();
                    itemPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.mouseableEditor = new DefaultCellEditor(jTextField);
        this.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = AgendaTableViewer.class$("java.lang.String")) : class$java$lang$String, this.mouseableEditor);
        jTextField.setEditable(false);
        jTextField.setBackground(Color.white);
    }

    public void setItemEditor(ItemEditor itemEditor) {
        this.itemEditor = itemEditor;
    }

    public void ensureItemEditor() {
        if (this.itemEditor == null) {
            this.itemEditor = this.makeItemEditor();
        }
        this.itemEditor.setVisible(true);
    }

    protected abstract ItemEditor makeItemEditor();

    public synchronized void reset() {
        this.clearTable();
        this.invalidate();
    }

    public synchronized void clearTable() {
        this.model.clearData();
    }

    public HandlerAction findHandlerAction(AgendaItem agendaItem, String string) {
        HandlerAction handlerAction = (HandlerAction)this.actionShadowingTable.get(agendaItem, string);
        return handlerAction != null ? handlerAction : agendaItem.findAction(string);
    }

    protected void setShadowingAction(AgendaItem agendaItem, String string, HandlerAction handlerAction) {
        this.actionShadowingTable.put(agendaItem, string, handlerAction);
    }

    public void actionSelected(AgendaItem agendaItem, String string) {
        HandlerAction handlerAction = this.findHandlerAction(agendaItem, string);
        Debug.assert(handlerAction != null, "Can't find action", string);
        HandlerAction handlerAction2 = this.model.getHandlerAction(agendaItem);
        if (handlerAction.equals(handlerAction2) || (handlerAction2 == null || (class$ix$ip2$HandlerAction$NoAction == null ? (class$ix$ip2$HandlerAction$NoAction = AgendaTableViewer.class$("ix.ip2.HandlerAction$NoAction")) : class$ix$ip2$HandlerAction$NoAction).isInstance(handlerAction2)) && (class$ix$ip2$HandlerAction$NoAction == null ? (class$ix$ip2$HandlerAction$NoAction = AgendaTableViewer.class$("ix.ip2.HandlerAction$NoAction")) : class$ix$ip2$HandlerAction$NoAction).isInstance(handlerAction) || handlerAction2 != null && string.equals(handlerAction2.getActionDescription())) {
            return;
        }
        if (agendaItem.actionCanBeTakenNow(handlerAction)) {
            this.handleItem(agendaItem, handlerAction);
        } else {
            Debug.noteln("Ignoring action selection");
            JOptionPane.showMessageDialog(this, "The selected action cannot be taken now", "Action selection", 1);
            this.model.setHandlerAction(agendaItem, handlerAction2);
        }
    }

    public void handleItem(AgendaItem agendaItem, HandlerAction handlerAction) {
        HandlerAction handlerAction2 = this.model.getHandlerAction(agendaItem);
        this.model.setHandlerAction(agendaItem, handlerAction);
        try {
            this.agendaManager.handleItem(agendaItem, handlerAction);
        }
        catch (Exception exception) {
            Debug.noteln("Exception while handling item", agendaItem);
            Debug.noteException(exception);
            JOptionPane.showMessageDialog(this, new Object[]{"Problem while handling item", exception.getMessage()}, "Problem while handling item", 0);
            this.model.setHandlerAction(agendaItem, handlerAction2);
        }
    }

    public void newHandlerAction(AgendaItem agendaItem, HandlerAction handlerAction) {
        Object object;
        Status status = agendaItem.getStatus();
        if (status == Status.COMPLETE || status == Status.EXECUTING || status == Status.IMPOSSIBLE) {
            return;
        }
        int n = this.getSelectedRow();
        int n2 = this.model.getObjectRow(agendaItem);
        try {
            this.setRowSelectionInterval(n2, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = handlerAction.getActionDescription();
        String string2 = null;
        List list = agendaItem.getActions();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (HandlerAction)iterator.next();
            if (object.equals(handlerAction) || !((HandlerAction)object).getActionDescription().equals(string)) continue;
            string2 = ((HandlerAction)object).getActionDescription();
            break;
        }
        if (string2 != null) {
            if (this.shouldReplaceAction(agendaItem, string2)) {
                this.setShadowingAction(agendaItem, handlerAction.getActionDescription(), handlerAction);
                Debug.assert(this.findHandlerAction(agendaItem, string2) == handlerAction);
            } else {
                Debug.assert(this.findHandlerAction(agendaItem, string2) != handlerAction);
            }
        } else {
            object = handlerAction.getActionDescription();
            Debug.noteln("Item", Util.quote(agendaItem.getShortDescription()));
            Debug.noteln(" has new action", object);
            String string3 = new HandlerAction.NotApplicable().getActionDescription();
            String string4 = new HandlerAction.NoAction().getActionDescription();
            String string5 = new HandlerAction.Manual().getActionDescription();
        }
        if (n >= 0) {
            this.setRowSelectionInterval(n, n);
        } else {
            this.clearSelection();
        }
    }

    boolean shouldReplaceAction(AgendaItem agendaItem, String string) {
        Object[] objectArray = new Object[]{"Replace existing action", "Ignore new action"};
        Object object = JOptionPane.showInputDialog(this, new Object[]{"Item " + Util.quote(agendaItem.getShortDescription()), "Already has an action " + Util.quote(string)}, "New Action", 1, null, objectArray, objectArray[0]);
        if (object == null) {
            return false;
        }
        return object.equals("Replace existing action");
    }

    public void getNewItemFromUser() {
        this.ensureItemEditor();
        this.itemEditor.showNewItem();
    }

    public AgendaItem makeItem(LList lList) {
        if (this.agendaManager == null) {
            Debug.error("AgendaManager not set!");
            return null;
        }
        return this.agendaManager.makeItem(lList);
    }

    public void addItem(AgendaItem agendaItem) {
        this.agendaManager.addItem(agendaItem);
    }

    public void saveExpansion(Refinement refinement) {
        this.ip2.frame.getDomainEditor().saveExpansion(refinement);
    }

    public void expandItem(AgendaItem agendaItem, Refinement refinement) {
        this.agendaManager.expandItem(agendaItem, refinement);
    }

    public void addItem(String string) {
        this.addItem(this.agendaManager.makeItem(string));
    }

    public void addItem(Priority priority, String string) {
        AgendaItem agendaItem = this.agendaManager.makeItem(string);
        agendaItem.setPriority(priority);
        this.addItem(agendaItem);
    }

    public void setAgendaManager(AgendaManager agendaManager) {
        this.agendaManager = agendaManager;
    }

    public void itemAdded(AgendaEvent agendaEvent, AgendaItem agendaItem) {
        this.itemAdded(agendaItem);
    }

    public synchronized void itemAdded(AgendaItem agendaItem) {
        this.model.itemAdded(agendaItem);
    }

    public void itemRemoved(AgendaEvent agendaEvent, AgendaItem agendaItem) {
        this.model.itemRemoved(agendaItem);
    }

    public void itemHandled(AgendaEvent agendaEvent, AgendaItem agendaItem, HandlerAction handlerAction) {
        this.model.itemHandled(agendaEvent, agendaItem, handlerAction);
    }

    public void newBindings(AgendaEvent agendaEvent, Map map) {
        this.model.fireTableChanged();
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        super.editingCanceled(changeEvent);
        this.model.fireTableChanged();
    }

    public void editingStopped(ChangeEvent changeEvent) {
        super.editingStopped(changeEvent);
        this.model.fireTableChanged();
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        return bl;
    }

    public boolean isDummyEditing(int n) {
        return this.isEditing() && this.getCellEditor().equals(this.mouseableEditor) && n == this.getEditingRow();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ItemPopupMenu
    extends JPopupMenu
    implements ActionListener {
        AgendaItem item;
        JMenuItem foldItem = this.makeMenuItem("Fold");
        JMenuItem bindItem = this.makeMenuItem("Bind Variables");
        static /* synthetic */ Class class$ix$ip2$ActivityItem;
        static /* synthetic */ Class class$ix$ip2$IssueItem;

        ItemPopupMenu(AgendaItem agendaItem) {
            this.item = agendaItem;
            this.add(this.makeMenuItem("Show Details"));
            this.add(this.foldItem);
            this.foldItem.setEnabled(false);
            this.add(this.bindItem);
            this.bindItem.setEnabled(false);
            if ((class$ix$ip2$ActivityItem == null ? (class$ix$ip2$ActivityItem = ItemPopupMenu.class$("ix.ip2.ActivityItem")) : class$ix$ip2$ActivityItem).isInstance(agendaItem)) {
                this.add(this.makeMenuItem("Send Activity"));
            } else if ((class$ix$ip2$IssueItem == null ? (class$ix$ip2$IssueItem = ItemPopupMenu.class$("ix.ip2.IssueItem")) : class$ix$ip2$IssueItem).isInstance(agendaItem)) {
                this.add(this.makeMenuItem("Send Issue"));
            }
            if (agendaItem.getAbout().getReportBack() == YesNo.YES) {
                this.add(this.makeMenuItem("Send Report"));
            }
        }

        JMenuItem makeMenuItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(this);
            return jMenuItem;
        }

        void noticeItemState() {
            IXTreeTableNode iXTreeTableNode = (IXTreeTableNode)AgendaTableViewer.this.model.getTreeNode(this.item);
            if (!iXTreeTableNode.isLeaf()) {
                this.foldItem.setEnabled(true);
            }
            if (iXTreeTableNode.expanded) {
                this.foldItem.setText("Fold");
            } else {
                this.foldItem.setText("Unfold");
            }
            if (this.item.getPatternVars().isEmpty()) {
                this.bindItem.setEnabled(false);
            } else {
                this.bindItem.setEnabled(true);
            }
        }

        String getSendItemCommand() {
            if ((class$ix$ip2$ActivityItem == null ? (class$ix$ip2$ActivityItem = ItemPopupMenu.class$("ix.ip2.ActivityItem")) : class$ix$ip2$ActivityItem).isInstance(this.item)) {
                return "Send Activity";
            }
            if ((class$ix$ip2$IssueItem == null ? (class$ix$ip2$IssueItem = ItemPopupMenu.class$("ix.ip2.IssueItem")) : class$ix$ip2$IssueItem).isInstance(this.item)) {
                return "Send Issue";
            }
            return "Send Item";
        }

        void sendActivity() {
            AgendaTableViewer.this.ip2.frame.getSendPanel().initActivity((Activity)this.item.getAbout());
        }

        void sendIssue() {
            AgendaTableViewer.this.ip2.frame.getSendPanel().initIssue((Issue)this.item.getAbout());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Item popup command", string);
            if (string.equals("Show Details")) {
                AgendaTableViewer.this.ensureItemEditor();
                AgendaTableViewer.this.itemEditor.showItem(this.item);
            } else if (string.equals("Fold")) {
                IXTreeTableNode iXTreeTableNode = (IXTreeTableNode)AgendaTableViewer.this.model.getTreeNode(this.item);
                int n = AgendaTableViewer.this.model.getObjectRow(this.item);
                AgendaTableViewer.this.model.unexpandNode(iXTreeTableNode, n);
                this.foldItem.setText("Unfold");
            } else if (string.equals("Unfold")) {
                IXTreeTableNode iXTreeTableNode = (IXTreeTableNode)AgendaTableViewer.this.model.getTreeNode(this.item);
                int n = AgendaTableViewer.this.model.getObjectRow(this.item);
                AgendaTableViewer.this.model.expandNode(iXTreeTableNode, n);
                this.foldItem.setText("Fold");
            } else if (string.equals("Send Activity")) {
                AgendaTableViewer.this.ip2.frame.ensureChat();
                this.sendActivity();
            } else if (string.equals("Send Issue")) {
                AgendaTableViewer.this.ip2.frame.ensureChat();
                this.sendIssue();
            } else if (string.equals("Bind Variables")) {
                BindingViewer[] bindingViewerArray;
                Set set = this.item.getUnboundVars();
                Debug.assert(!set.isEmpty(), "No variables to bind.");
                bindingViewerArray = new BindingViewer[]{new BindingViewer(AgendaTableViewer.this.ip2, set, new Runnable(this, bindingViewerArray){
                    private final /* synthetic */ BindingViewer[] val$binder;
                    private final /* synthetic */ ItemPopupMenu this$1;
                    {
                        this.this$1 = itemPopupMenu;
                        this.val$binder = bindingViewerArray;
                    }

                    public void run() {
                        if (this.val$binder[0].newBindings != null) {
                            ItemPopupMenu.access$100((ItemPopupMenu)this.this$1).ip2.controller.modelManager.newBindings(this.val$binder[0].newBindings);
                        }
                    }
                })};
            } else if (string.equals("Send Report")) {
                AgendaTableViewer.this.ip2.frame.ensureChat();
                AgendaTableViewer.this.ip2.frame.chatFrame.initReport(this.item.getAbout());
            } else {
                Debug.noteln("Nothing to do for", string);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static /* synthetic */ AgendaTableViewer access$100(ItemPopupMenu itemPopupMenu) {
            return itemPopupMenu.AgendaTableViewer.this;
        }
    }

    private class ActionPopupMenu
    extends TablePopupMenu
    implements ActionListener {
        AgendaItem agendaItem;
        String currentAction = "No Action";

        public ActionPopupMenu(JTable jTable, int n, int n2) {
            super(jTable);
            Object object;
            Object object2;
            AgendaItemTableModel agendaItemTableModel = (AgendaItemTableModel)jTable.getModel();
            this.agendaItem = (AgendaItem)agendaItemTableModel.getRowObject(n);
            AgendaItemTableModel.TreeAgendaItem treeAgendaItem = (AgendaItemTableModel.TreeAgendaItem)agendaItemTableModel.getTreeNode(this.agendaItem);
            if (treeAgendaItem.handlerAction != null) {
                this.currentAction = treeAgendaItem.handlerAction.getActionDescription();
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = this.agendaItem.getActions().iterator();
            while (iterator.hasNext()) {
                object2 = (HandlerAction)iterator.next();
                object = ((HandlerAction)object2).getActionDescription();
                if (arrayList.contains(object2 = ((AgendaTableViewer)jTable).findHandlerAction(this.agendaItem, (String)object))) continue;
                arrayList.add(object2);
            }
            object2 = ((AbstractList)arrayList).iterator();
            while (object2.hasNext()) {
                object = (HandlerAction)object2.next();
                Color color = ((HandlerAction)object).isReady() ? this.agendaItem.getStatus().getColor() : Color.gray;
                JMenuItem jMenuItem = this.add(new DefaultColourField(((HandlerAction)object).getActionDescription(), color));
                if (this.currentAction.equals(((HandlerAction)object).getActionDescription())) {
                    this.setSelected(jMenuItem);
                }
                jMenuItem.addActionListener(this);
            }
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            AgendaTableViewer.this.actionSelected(this.agendaItem, string);
        }
    }

    private class PriorityPopupMenu
    extends TablePopupMenu
    implements ActionListener {
        public PriorityPopupMenu() {
            super(AgendaTableViewer.this);
            ArrayList arrayList = new ArrayList(Priority.values());
            Collections.reverse(arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Priority priority = (Priority)iterator.next();
                JMenuItem jMenuItem = this.add(new DefaultColourField(Strings.capitalize(priority.toString()), priority.getColor()));
                jMenuItem.addActionListener(this);
            }
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Priority popup command", string);
            if (string == null) {
                return;
            }
            AgendaTableViewer.this.model.setPriorityValue(string, this.row, this.column);
        }
    }

    private class AgendaTableMouser
    extends MouseAdapter {
        private AgendaTableMouser() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (AgendaTableViewer.this.isEditing()) {
                AgendaTableViewer.this.removeEditor();
            }
            int n = AgendaTableViewer.this.rowAtPoint(mouseEvent.getPoint());
            int n2 = AgendaTableViewer.this.columnAtPoint(mouseEvent.getPoint());
            AgendaItem agendaItem = (AgendaItem)AgendaTableViewer.this.model.getRowObject(n);
            if (agendaItem == null) {
                Debug.noteln("Clicked on empty item");
                return;
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                ItemPopupMenu itemPopupMenu = new ItemPopupMenu(agendaItem);
                itemPopupMenu.noticeItemState();
                itemPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && n2 == 0) {
                AgendaTableViewer.this.model.cellClicked(mouseEvent, n, n2);
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && (n2 == AgendaTableViewer.this.model.DESCRIPTION_COL || n2 == AgendaTableViewer.this.model.COMMENTS_COL)) {
                AgendaTableViewer.this.editCellAt(n, n2);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (AgendaTableViewer.this.isEditing()) {
                AgendaTableViewer.this.removeEditor();
            }
            int n = AgendaTableViewer.this.rowAtPoint(mouseEvent.getPoint());
            int n2 = AgendaTableViewer.this.columnAtPoint(mouseEvent.getPoint());
            AgendaItem agendaItem = (AgendaItem)AgendaTableViewer.this.model.getRowObject(n);
            if (agendaItem == null) {
                Debug.noteln("Pressed on empty item");
                return;
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                ItemPopupMenu itemPopupMenu = new ItemPopupMenu(agendaItem);
                itemPopupMenu.noticeItemState();
                itemPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && n2 == AgendaTableViewer.this.model.PRIORITY_COL) {
                if (AgendaTableViewer.this.model.takesPriority(n)) {
                    AgendaTableViewer.this.priorityPopup.show(mouseEvent, n, n2);
                    AgendaTableViewer.this.priorityPopup.setSelected(Strings.capitalize(agendaItem.getPriority().toString()));
                }
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && n2 == AgendaTableViewer.this.model.ACTION_COL && AgendaTableViewer.this.model.takesAction(n)) {
                ActionPopupMenu actionPopupMenu = new ActionPopupMenu(AgendaTableViewer.this, n, n2);
                actionPopupMenu.show(mouseEvent, n, n2);
            }
        }
    }
}

