/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Priority;
import ix.icore.Report;
import ix.icore.Status;
import ix.iface.ui.EditableColourField;
import ix.iface.ui.table.AbstractTreeTableModel;
import ix.iface.ui.table.IXTreeTableNode;
import ix.ip2.AgendaItem;
import ix.ip2.AgendaTableViewer;
import ix.ip2.HandlerAction;
import ix.ip2.event.AgendaEvent;
import ix.ip2.event.AgendaItemEvent;
import ix.ip2.event.AgendaItemListener;
import ix.iview.util.EditablePriority;
import ix.util.Debug;
import ix.util.Strings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.tree.TreeNode;

public class AgendaItemTableModel
extends AbstractTreeTableModel {
    protected AgendaTableViewer table;
    public int DESCRIPTION_COL = 1;
    public int COMMENTS_COL = 2;
    public int PRIORITY_COL = 3;
    public int ACTION_COL = 4;
    private HashSet items = new HashSet();
    private HashSet disabled = new HashSet();
    static /* synthetic */ Class class$javax$swing$ImageIcon;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$ix$icore$Priority;
    static /* synthetic */ Class class$ix$iface$ui$FourField;
    static /* synthetic */ Class class$java$lang$Object;

    public AgendaItemTableModel(AgendaTableViewer agendaTableViewer) {
        this.table = agendaTableViewer;
        String[] stringArray = new String[]{"Description", "Annotations", "Priority", "Action"};
        this.setColumnNames(stringArray);
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = AgendaItemTableModel.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon;
        }
        if (n == this.DESCRIPTION_COL) {
            return class$java$lang$String == null ? (class$java$lang$String = AgendaItemTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        if (n == this.COMMENTS_COL) {
            return class$java$lang$String == null ? (class$java$lang$String = AgendaItemTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        if (n == this.PRIORITY_COL) {
            return class$ix$icore$Priority == null ? (class$ix$icore$Priority = AgendaItemTableModel.class$("ix.icore.Priority")) : class$ix$icore$Priority;
        }
        if (n == this.ACTION_COL) {
            return class$ix$iface$ui$FourField == null ? (class$ix$iface$ui$FourField = AgendaItemTableModel.class$("ix.iface.ui.FourField")) : class$ix$iface$ui$FourField;
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = AgendaItemTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public synchronized void itemAdded(AgendaItem agendaItem) {
        IXTreeTableNode iXTreeTableNode;
        if (agendaItem == null) {
            return;
        }
        AgendaItem agendaItem2 = agendaItem.getParent();
        if (agendaItem2 == null) {
            this.addData(agendaItem);
        } else {
            iXTreeTableNode = (IXTreeTableNode)this.getTreeNode(agendaItem2);
            int n = this.rows.indexOf(iXTreeTableNode);
            if (n == -1) {
                n = this.getObjectRow(agendaItem2);
            }
            this.expandNode(iXTreeTableNode, n);
        }
        iXTreeTableNode = (TreeAgendaItem)this.getTreeNode(agendaItem);
        agendaItem.addItemListener((AgendaItemListener)((Object)iXTreeTableNode));
        this.items.add(agendaItem);
    }

    public synchronized void itemRemoved(AgendaItem agendaItem) {
        Debug.noteln("Agenda Model removing item", agendaItem);
        TreeAgendaItem treeAgendaItem = (TreeAgendaItem)this.nodeMap.get(agendaItem);
        if (treeAgendaItem == null) {
            Debug.noteln("Removing item: no such item", agendaItem);
        } else {
            super.removeData(agendaItem);
            this.nodeMap.remove(agendaItem);
            this.items.remove(agendaItem);
            this.disabled.remove(agendaItem);
        }
    }

    public void clearData() {
        this.items.clear();
        super.clearData();
    }

    public String getNameString(TreeNode treeNode) {
        return ((TreeAgendaItem)treeNode).node.getShortDescription();
    }

    public Object getCellValueAt(Object object, int n) {
        AgendaItem agendaItem = ((TreeAgendaItem)object).node;
        if (n == this.DESCRIPTION_COL - 1) {
            String string = agendaItem.getShortDescription();
            return string;
        }
        if (n == this.COMMENTS_COL - 1) {
            Object object2;
            String string;
            List list = agendaItem.getReports();
            if (list == null || list.isEmpty()) {
                string = agendaItem.getComments();
            } else {
                object2 = (Report)list.get(list.size() - 1);
                string = ((Report)object2).getText();
            }
            object2 = Strings.firstLine(string).trim();
            return object2;
        }
        if (n == this.PRIORITY_COL - 1) {
            TreeAgendaItem treeAgendaItem = (TreeAgendaItem)object;
            boolean bl = treeAgendaItem.takesPriority();
            return new EditablePriority(agendaItem.getPriority(), bl);
        }
        if (n == this.ACTION_COL - 1) {
            List list;
            TreeAgendaItem treeAgendaItem = (TreeAgendaItem)object;
            HandlerAction handlerAction = treeAgendaItem.handlerAction;
            Color color = agendaItem.getStatus().getColor();
            if (handlerAction == null && (list = agendaItem.getActions()) != null && !list.isEmpty()) {
                handlerAction = (HandlerAction)list.get(0);
            }
            String string = handlerAction == null ? "No Action" : handlerAction.getActionDescription();
            boolean bl = treeAgendaItem.takesAction();
            return new EditableColourField(string, color, bl);
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == this.DESCRIPTION_COL || n2 == this.COMMENTS_COL;
    }

    public boolean takesPriority(int n) {
        TreeAgendaItem treeAgendaItem = (TreeAgendaItem)this.getRowNode(n);
        return treeAgendaItem.takesPriority();
    }

    public boolean takesAction(int n) {
        TreeAgendaItem treeAgendaItem = (TreeAgendaItem)this.getRowNode(n);
        return treeAgendaItem.takesAction();
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            this.fireTableCellUpdated(n, n2);
            return;
        }
        AgendaItem agendaItem = (AgendaItem)this.getRowObject(n);
        if (n2 == this.PRIORITY_COL) {
            this.setPriorityValue(agendaItem, object, n, n2);
        } else if (n2 == this.ACTION_COL) {
            String string = object.toString();
            this.actionSelected(agendaItem, string);
        }
        this.fireTableCellUpdated(n, n2);
    }

    public void setPriorityValue(AgendaItem agendaItem, Object object, int n, int n2) {
        try {
            Priority priority = Priority.valueOf(Strings.uncapitalize(object.toString()));
            if (!priority.equals(agendaItem.getPriority())) {
                agendaItem.setPriority(priority);
                this.fireTableCellUpdated(n, n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Debug.noteException(illegalArgumentException);
        }
    }

    public void setPriorityValue(Object object, int n, int n2) {
        this.setPriorityValue((AgendaItem)this.getRowObject(n), object, n, n2);
    }

    private void actionSelected(AgendaItem agendaItem, String string) {
        this.table.actionSelected(agendaItem, string);
    }

    public void itemHandled(AgendaEvent agendaEvent, AgendaItem agendaItem, HandlerAction handlerAction) {
        Debug.noteln("AITM: Handled item", agendaItem.getShortDescription());
        TreeAgendaItem treeAgendaItem = (TreeAgendaItem)this.getTreeNode(agendaItem);
        this.disabled.add(agendaItem);
        treeAgendaItem.disableActions();
        treeAgendaItem.setHandlerAction(handlerAction);
    }

    public void setHandlerAction(AgendaItem agendaItem, HandlerAction handlerAction) {
        TreeAgendaItem treeAgendaItem = (TreeAgendaItem)this.getTreeNode(agendaItem);
        treeAgendaItem.setHandlerAction(handlerAction);
    }

    public HandlerAction getHandlerAction(AgendaItem agendaItem) {
        TreeAgendaItem treeAgendaItem = (TreeAgendaItem)this.getTreeNode(agendaItem);
        return treeAgendaItem.handlerAction;
    }

    public void fireTableStructureChanged() {
    }

    public void fireTableChanged() {
        this.fireTableDataChanged();
    }

    public void fireItemChanged(TreeAgendaItem treeAgendaItem) {
        if (treeAgendaItem == null) {
            return;
        }
        int n = this.getObjectRow(treeAgendaItem.node);
        if (this.table.isDummyEditing(n)) {
            int n2 = this.table.getEditingColumn();
            this.fireTableRowsUpdated(n, n);
            this.table.editCellAt(n, n2);
        } else {
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void fireActionSelected(AgendaItem agendaItem, HandlerAction handlerAction) {
        if (agendaItem == null) {
            return;
        }
        int n = this.getObjectRow(agendaItem);
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, this.ACTION_COL);
        this.fireTableChanged(tableModelEvent);
    }

    public void fireItemDeleted(AgendaItem agendaItem) {
        int n = this.getObjectRow(agendaItem);
        this.fireTableRowsDeleted(n, n);
    }

    public IXTreeTableNode makeIXTreeTableNode(Object object) {
        if (object == null) {
            Debug.noteln("AITM: Cannot make a table node for null objects");
            return null;
        }
        return new TreeAgendaItem(this, (AgendaItem)object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class TreeAgendaItem
    extends IXTreeTableNode
    implements AgendaItemListener {
        public AgendaItem node;
        public HandlerAction handlerAction;
        public List handlerActions;
        private boolean takesAction = true;
        private boolean takesPriority = true;

        public TreeAgendaItem(AgendaItemTableModel agendaItemTableModel2, AgendaItem agendaItem) {
            super(agendaItemTableModel2, agendaItem);
            this.node = agendaItem;
            if (agendaItem == null) {
                Debug.noteln("Making TreeAgendaItem with null AgendaItem");
                new Throwable().printStackTrace();
            } else {
                this.noticeStatus();
            }
            if (AgendaItemTableModel.this.items.contains(agendaItem)) {
                agendaItem.addItemListener(this);
            }
        }

        public boolean takesAction() {
            return this.takesAction;
        }

        public void disableActions() {
            this.takesAction = false;
        }

        public void enableActions() {
            this.takesAction = true;
        }

        public boolean takesPriority() {
            return this.takesPriority;
        }

        public void disablePriority() {
            this.takesPriority = false;
        }

        public void enablePriority() {
            this.takesPriority = true;
        }

        protected void loadHandlerActions() {
            this.handlerActions = new ArrayList();
            Iterator iterator = this.node.getActions().iterator();
            while (iterator.hasNext()) {
                HandlerAction handlerAction = (HandlerAction)iterator.next();
                String string = handlerAction.getActionDescription();
                if (this.handlerActions.contains(handlerAction = AgendaItemTableModel.this.table.findHandlerAction(this.node, string))) continue;
                this.handlerActions.add(handlerAction);
            }
        }

        protected void noticeStatus() {
            Status status = this.node.getStatus();
            if ((status == Status.COMPLETE || status == Status.EXECUTING || status == Status.IMPOSSIBLE) && AgendaItemTableModel.this.disabled.contains(this.node)) {
                this.disableActions();
                this.disablePriority();
            }
        }

        public void setHandlerAction(HandlerAction handlerAction) {
            this.handlerAction = handlerAction;
            AgendaItemTableModel.this.fireItemChanged(this);
        }

        public Enumeration children() {
            List list = this.node.children;
            return new Enumeration(this, list){
                int i;
                private final /* synthetic */ List val$nodes;
                private final /* synthetic */ TreeAgendaItem this$1;
                {
                    this.this$1 = treeAgendaItem;
                    this.val$nodes = list;
                    this.i = this.val$nodes.size() - 1;
                }

                public boolean hasMoreElements() {
                    return this.i >= 0;
                }

                public Object nextElement() {
                    return this.val$nodes.get(this.i--);
                }
            };
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public TreeNode getChildAt(int n) {
            Object e = this.node.children.get(n);
            return this.model.getTreeNode(e);
        }

        public int getChildCount() {
            if (this.node.children == null) {
                return 0;
            }
            return this.node.children.size();
        }

        public int getIndex(TreeNode treeNode) {
            List list = this.node.children;
            return list.lastIndexOf(((IXTreeTableNode)treeNode).node);
        }

        public TreeNode getParent() {
            return this.model.getTreeNode(this.node.parent);
        }

        public boolean isLeaf() {
            if (this.node == null) {
                Debug.noteln("AITM: null node - should not happen!");
                return true;
            }
            if (this.node.children == null) {
                Debug.noteln("AITM: null children");
                return true;
            }
            return this.node.children.isEmpty();
        }

        public void statusChanged(AgendaItemEvent agendaItemEvent) {
            AgendaItemTableModel.this.disabled.add(this.node);
            this.noticeStatus();
            AgendaItemTableModel.this.fireItemChanged(this);
        }

        public void priorityChanged(AgendaItemEvent agendaItemEvent) {
            AgendaItemTableModel.this.fireItemChanged(this);
        }

        public void newHandlerAction(AgendaItemEvent agendaItemEvent, HandlerAction handlerAction) {
            AgendaItemTableModel.this.table.newHandlerAction(this.node, handlerAction);
        }

        public void handlerActionsChanged(AgendaItemEvent agendaItemEvent) {
            AgendaItemTableModel.this.fireItemChanged(this);
        }

        public void newReport(AgendaItemEvent agendaItemEvent, Report report) {
            AgendaItemTableModel.this.fireItemChanged(this);
        }

        public void agendaItemEdited(AgendaItemEvent agendaItemEvent) {
            Debug.noteln("AITM: got item change");
            AgendaItemTableModel.this.fireItemChanged(this);
        }
    }
}

