/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.IXAgent;
import ix.icore.Priority;
import ix.icore.Report;
import ix.icore.ReportType;
import ix.icore.Status;
import ix.icore.TaskItem;
import ix.icore.Variable;
import ix.icore.YesNo;
import ix.icore.domain.Refinement;
import ix.icore.process.PNode;
import ix.iface.util.Reporting;
import ix.ip2.HandlerAction;
import ix.ip2.ItemHandler;
import ix.ip2.event.AgendaItemEvent;
import ix.ip2.event.AgendaItemListener;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Name;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.match.MatchEnv;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AgendaItem
extends PNode {
    protected TaskItem about;
    protected List actions = new LinkedList();
    protected List reports = new LinkedList();
    protected List listeners = new LinkedList();

    public AgendaItem(TaskItem taskItem) {
        this(null, taskItem);
    }

    public AgendaItem(AgendaItem agendaItem, TaskItem taskItem) {
        super(agendaItem);
        this.about = taskItem;
        if (agendaItem != null) {
            taskItem.setPriority(agendaItem.getPriority());
        }
    }

    public TaskItem getAbout() {
        return this.about;
    }

    public LList getPattern() {
        return this.about.getPattern();
    }

    public Set getPatternVars() {
        return this.about.getPatternVars();
    }

    public Set getUnboundVars() {
        Set set = this.about.getUnboundVars();
        if (this.varTable != null) {
            set.addAll(Variable.unboundVarsIn(this.varTable.values()));
        }
        return set;
    }

    public void setPattern(LList lList) {
        this.about.setPattern(lList);
    }

    public String getShortDescription() {
        return Lisp.elementsToString(this.getPattern());
    }

    public int getLevel() {
        return this.level;
    }

    public AgendaItem getParent() {
        return (AgendaItem)this.parent;
    }

    public List getChildren() {
        return this.children;
    }

    public Status getStatus() {
        return this.about.getStatus();
    }

    public void setStatus(Status status) {
        if (this.getStatus() != status) {
            if (this.about.getReportBack() == YesNo.YES) {
                this.handleReportBack(status);
            }
            this.about.setStatus(status);
            super.setStatus(status);
            this.fireStatusChanged();
        }
    }

    public Priority getPriority() {
        return this.about.getPriority();
    }

    public void setPriority(Priority priority) {
        Debug.noteln("Changing priority of " + this + " to " + priority);
        this.about.setPriority(priority);
        this.firePriorityChanged();
    }

    public String getComments() {
        String string = this.about.getComments();
        return string == null ? "" : string;
    }

    public void setComments(String string) {
        this.about.setComments(string);
        this.fireAgendaItemEdited();
    }

    public List getActions() {
        return this.actions;
    }

    public boolean wantsActionsFrom(ItemHandler itemHandler) {
        return true;
    }

    public void addAction(HandlerAction handlerAction) {
        Debug.noteln(this + " adding " + handlerAction);
        Debug.assert(!this.hasAction(handlerAction), "Action added twice", handlerAction);
        HandlerAction handlerAction2 = this.findAction(handlerAction.getActionDescription());
        if (handlerAction2 != null) {
            Debug.noteln("Action description not unique", Util.quote(handlerAction.getActionDescription()));
        }
        this.actions.add(handlerAction);
        handlerAction.computeStatus();
        this.fireNewHandlerAction(handlerAction);
    }

    boolean hasAction(HandlerAction handlerAction) {
        return this.actions.contains(handlerAction);
    }

    HandlerAction findAction(String string) {
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            HandlerAction handlerAction = (HandlerAction)iterator.next();
            if (!handlerAction.getActionDescription().equals(string)) continue;
            return handlerAction;
        }
        return null;
    }

    boolean actionCanBeTakenNow(HandlerAction handlerAction) {
        return this.getStatus() == Status.POSSIBLE && handlerAction.isReady();
    }

    boolean wantsReport(Report report) {
        Name name = report.getRef();
        return name != null && name.equals(this.about.getId());
    }

    void addReport(Report report) {
        Debug.assert(this.wantsReport(report), "unwanted report", report);
        Debug.noteln(this + " accepts " + report);
        String string = System.getProperty("line.separator");
        String string2 = this.getComments();
        string2 = string2 + (string2.equals("") || string2.endsWith(string) ? "" : string) + Reporting.reportDescription(report) + string;
        this.setComments(string2);
        this.reports.add(report);
        this.fireNewReport(report);
        this.setStatusBasedOn(report);
    }

    void setStatusBasedOn(Report report) {
        if (report.isCompletion()) {
            if (report.isSuccess()) {
                this.setStatus(Status.COMPLETE);
            } else {
                Debug.assert(report.isFailure());
                this.setStatus(Status.IMPOSSIBLE);
            }
        } else if (report.isProgress()) {
            this.setStatus(Status.EXECUTING);
        }
    }

    List getReports() {
        return this.reports;
    }

    void handleReportBack(Status status) {
        ReportType reportType;
        Debug.assert(this.about.getReportBack() == YesNo.YES);
        if (status == Status.COMPLETE) {
            reportType = ReportType.SUCCESS;
        } else if (status == Status.IMPOSSIBLE) {
            reportType = ReportType.FAILURE;
        } else {
            return;
        }
        Report report = new Report("done - " + reportType);
        report.setReportType(reportType);
        report.setSenderId(Name.valueOf(IXAgent.getAgent().getAgentIPCName()));
        report.setRef(this.about.getRef());
        IPC.sendObject(this.about.getSenderId().toString(), report);
    }

    void expandOneLevel(Refinement refinement, MatchEnv matchEnv) {
        throw new Error("Attempt to expandOneLevel " + refinement);
    }

    void addItemListener(AgendaItemListener agendaItemListener) {
        if (!this.listeners.contains(agendaItemListener)) {
            this.listeners.add(agendaItemListener);
        }
    }

    void fireStatusChanged() {
        AgendaItemEvent agendaItemEvent = new AgendaItemEvent(this);
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                AgendaItemListener agendaItemListener = (AgendaItemListener)iterator.next();
                agendaItemListener.statusChanged(agendaItemEvent);
            }
        }
    }

    void firePriorityChanged() {
        AgendaItemEvent agendaItemEvent = new AgendaItemEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AgendaItemListener agendaItemListener = (AgendaItemListener)iterator.next();
            agendaItemListener.priorityChanged(agendaItemEvent);
        }
    }

    void fireHandlerActionsChanged() {
        AgendaItemEvent agendaItemEvent = new AgendaItemEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AgendaItemListener agendaItemListener = (AgendaItemListener)iterator.next();
            agendaItemListener.handlerActionsChanged(agendaItemEvent);
        }
    }

    void fireNewHandlerAction(HandlerAction handlerAction) {
        AgendaItemEvent agendaItemEvent = new AgendaItemEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AgendaItemListener agendaItemListener = (AgendaItemListener)iterator.next();
            agendaItemListener.newHandlerAction(agendaItemEvent, handlerAction);
        }
    }

    void fireNewReport(Report report) {
        AgendaItemEvent agendaItemEvent = new AgendaItemEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AgendaItemListener agendaItemListener = (AgendaItemListener)iterator.next();
            agendaItemListener.newReport(agendaItemEvent, report);
        }
    }

    void fireAgendaItemEdited() {
        AgendaItemEvent agendaItemEvent = new AgendaItemEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AgendaItemListener agendaItemListener = (AgendaItemListener)iterator.next();
            agendaItemListener.agendaItemEdited(agendaItemEvent);
        }
    }

    public String toString() {
        return "AgendaItem[about " + this.about + "]";
    }
}

