/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Report;
import ix.icore.Status;
import ix.icore.domain.Refinement;
import ix.icore.process.ProcessModelManager;
import ix.icore.process.event.ProcessStatusEvent;
import ix.icore.process.event.ProcessStatusListener;
import ix.ip2.AgendaItem;
import ix.ip2.AgendaManager;
import ix.ip2.HandlerAction;
import ix.ip2.ItemHandler;
import ix.ip2.PanelController;
import ix.ip2.event.AgendaEvent;
import ix.ip2.event.AgendaListener;
import ix.ispace.event.ContactEvent;
import ix.ispace.event.ContactListener;
import ix.util.Debug;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class Agenda
implements AgendaManager,
ProcessStatusListener,
ContactListener {
    protected PanelController controller;
    protected ProcessModelManager modelManager;
    protected List items = new LinkedList();
    protected List handlers = new LinkedList();
    protected List listeners = new LinkedList();

    public Agenda(PanelController panelController) {
        this.controller = panelController;
        this.modelManager = panelController.modelManager;
        this.modelManager.addProcessStatusListener(this);
        this.controller.agent.getContactManager().addContactListener(this);
    }

    public List getItems() {
        return this.items;
    }

    public void addItem(AgendaItem agendaItem) {
        this.addHandlerActions(agendaItem);
        this.items.add(agendaItem);
        this.fireItemAdded(agendaItem);
    }

    public void removeItem(AgendaItem agendaItem) {
        this.items.remove(agendaItem);
        this.fireItemRemoved(agendaItem);
    }

    public void clear() {
        this.items.clear();
    }

    public AgendaItem makeItem(String string) {
        return this.makeItem(Lisp.elementsFromString(string));
    }

    public abstract AgendaItem makeItem(LList var1);

    public void addHandlerActions(AgendaItem agendaItem) {
        agendaItem.addAction(new HandlerAction.NoAction());
        agendaItem.addAction(new HandlerAction.Manual());
        agendaItem.addAction(new HandlerAction.NotApplicable());
        Iterator iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            ItemHandler itemHandler = (ItemHandler)iterator.next();
            if (!itemHandler.appliesTo(agendaItem) || !agendaItem.wantsActionsFrom(itemHandler)) continue;
            itemHandler.addHandlerActions(agendaItem);
        }
    }

    public void handleItem(AgendaItem agendaItem, HandlerAction handlerAction) {
        Debug.assert(this.items.contains(agendaItem), "Stray item", agendaItem);
        Debug.assert(agendaItem.hasAction(handlerAction), "Stray action", handlerAction);
        handlerAction.handle(agendaItem);
    }

    public void addItemHandler(ItemHandler itemHandler) {
        this.handlers.add(itemHandler);
    }

    public void reconsiderHandler(ItemHandler itemHandler, Object object) {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            AgendaItem agendaItem = (AgendaItem)iterator.next();
            if (!itemHandler.appliesTo(agendaItem)) continue;
            itemHandler.reviseHandlerActions(agendaItem, object);
        }
    }

    public void expandItem(AgendaItem agendaItem, Refinement refinement) {
        throw new Error("Attempt to expand " + agendaItem);
    }

    public boolean acceptReport(Report report) {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            AgendaItem agendaItem = (AgendaItem)iterator.next();
            if (!agendaItem.wantsReport(report)) continue;
            agendaItem.addReport(report);
            return true;
        }
        return false;
    }

    public void statusUpdate(ProcessStatusEvent processStatusEvent) {
    }

    public void newBindings(ProcessStatusEvent processStatusEvent, Map map) {
        this.fireNewBindings(map);
        this.checkActionValidity();
        this.computeActionStatus();
    }

    public void stateChange(ProcessStatusEvent processStatusEvent, Map map) {
        this.computeActionStatus();
    }

    public void contactChange(ContactEvent contactEvent) {
        this.checkActionValidity();
    }

    protected void checkActionValidity() {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            AgendaItem agendaItem = (AgendaItem)iterator.next();
            this.checkActionValidity(agendaItem);
        }
    }

    protected void checkActionValidity(AgendaItem agendaItem) {
        boolean bl = false;
        Iterator iterator = agendaItem.getActions().iterator();
        while (iterator.hasNext()) {
            HandlerAction handlerAction = (HandlerAction)iterator.next();
            if (handlerAction.isStillValid()) continue;
            Debug.noteln("Removing " + handlerAction + " from " + agendaItem);
            iterator.remove();
            bl = true;
        }
        if (bl) {
            agendaItem.fireHandlerActionsChanged();
        }
    }

    protected void computeActionStatus() {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            AgendaItem agendaItem = (AgendaItem)iterator.next();
            this.computeActionStatus(agendaItem);
        }
    }

    protected void computeActionStatus(AgendaItem agendaItem) {
        Status status = agendaItem.getStatus();
        if (status == Status.COMPLETE || status == Status.EXECUTING || status == Status.IMPOSSIBLE) {
            return;
        }
        boolean bl = false;
        Iterator iterator = agendaItem.getActions().iterator();
        while (iterator.hasNext()) {
            HandlerAction handlerAction = (HandlerAction)iterator.next();
            boolean bl2 = handlerAction.isReady();
            handlerAction.computeStatus();
            if (handlerAction.isReady() == bl2) continue;
            bl = true;
        }
        if (bl) {
            agendaItem.fireHandlerActionsChanged();
        }
    }

    public void addAgendaListener(AgendaListener agendaListener) {
        this.listeners.add(agendaListener);
    }

    public void fireItemAdded(AgendaItem agendaItem) {
        Debug.noteln("fireItemAdded", agendaItem);
        AgendaEvent agendaEvent = new AgendaEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AgendaListener agendaListener = (AgendaListener)iterator.next();
            agendaListener.itemAdded(agendaEvent, agendaItem);
        }
    }

    public void fireItemRemoved(AgendaItem agendaItem) {
        Debug.noteln("fireItemAdded", agendaItem);
        AgendaEvent agendaEvent = new AgendaEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AgendaListener agendaListener = (AgendaListener)iterator.next();
            agendaListener.itemRemoved(agendaEvent, agendaItem);
        }
    }

    public void fireItemHandled(AgendaItem agendaItem, HandlerAction handlerAction) {
        Debug.noteln("fireItemHandled " + agendaItem + " " + handlerAction.getActionDescription());
        AgendaEvent agendaEvent = new AgendaEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AgendaListener agendaListener = (AgendaListener)iterator.next();
            agendaListener.itemHandled(agendaEvent, agendaItem, handlerAction);
        }
    }

    public void fireNewBindings(Map map) {
        AgendaEvent agendaEvent = new AgendaEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AgendaListener agendaListener = (AgendaListener)iterator.next();
            agendaListener.newBindings(agendaEvent, map);
        }
    }
}

