/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Status;
import ix.icore.domain.Refinement;
import ix.ip2.AgendaItem;
import ix.ip2.AgendaViewer;
import ix.ip2.ItemEditor;
import ix.ip2.event.AgendaItemEvent;
import ix.iview.SimpleDomainEditor;
import ix.util.Debug;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class ActivityEditor
extends ItemEditor {
    ActivityEditor(AgendaViewer agendaViewer, String string) {
        super(agendaViewer, string);
    }

    protected ItemEditor.EditPanel makeEditPanel() {
        ActivityEditPanel activityEditPanel = new ActivityEditPanel();
        activityEditPanel.setBorder(BorderFactory.createTitledBorder("Activity"));
        return activityEditPanel;
    }

    protected JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        this.saveAsRefinementItem.setEnabled(false);
        jMenu.add(this.saveAsRefinementItem);
        jMenu.addSeparator();
        jMenu.add(this.makeMenuItem("Close"));
        return jMenuBar;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("ActivityEditor action:", string);
        if (string.equals("Save As Refinement")) {
            Refinement refinement = ((ActivityEditPanel)this.editPanel).expansionPanel.makePartialRefinement();
            this.agendaViewer.saveExpansion(refinement);
        } else if (string.equals("Close")) {
            ((Component)this.frame).setVisible(false);
        } else {
            Debug.noteln("Nothing to do for", string);
        }
    }

    class ActivityEditPanel
    extends ItemEditor.EditPanel {
        JButton expansionButton;
        ExpansionPanel expansionPanel = new ExpansionPanel();

        ActivityEditPanel() {
            this.modifyButton = this.makeButton("Modify Activity");
            this.expansionButton = this.makeButton("Specify Subactivities");
            this.setUp();
        }

        protected void setUp() {
            this.add(this.makeLeftLabel("Activity Pattern Text"));
            this.add(new JScrollPane(this.itemText));
            this.add(this.makeLeftLabel("Annotations"));
            this.add(new JScrollPane(this.commentText));
            this.newItemButtons.add(this.makeButton("Add Activity"));
            this.newItemButtons.add(this.makeButton("Clear"));
            this.newItemButtons.add(this.makeButton("Cancel"));
            this.editItemButtons.add(this.modifyButton);
            this.editItemButtons.add(this.makeButton("Copy Activity"));
            this.editItemButtons.add(this.expansionButton);
            this.editItemButtons.add(this.makeButton("Clear"));
            this.editItemButtons.add(this.makeButton("Cancel"));
            this.add(this.newItemButtons);
        }

        void showItem(AgendaItem agendaItem) {
            this.ensureNoExpansionPanel();
            Status status = agendaItem.getStatus();
            this.expansionButton.setEnabled(status == Status.BLANK || status == Status.POSSIBLE);
            super.showItem(agendaItem);
        }

        void showNewItem() {
            this.ensureNoExpansionPanel();
            super.showNewItem();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Activity action:", string);
            if (string.equals("Add Activity")) {
                this.addItem();
            } else if (string.equals("Modify Activity")) {
                this.modifyItem();
            } else if (string.equals("Copy Activity")) {
                this.copyItem();
            } else if (string.equals("Specify Subactivities")) {
                this.addExpansionPanel();
            } else if (string.equals("Install Subactivities")) {
                this.addSubitems();
            } else {
                if (string.equals("Modify Subactivities")) {
                    throw new Error("Modify Subactivities button should be disabled");
                }
                if (string.equals("Clear")) {
                    this.showNewItem();
                } else if (string.equals("Cancel")) {
                    ((Component)ActivityEditor.this.frame).setVisible(false);
                    this.showNewItem();
                } else {
                    Debug.noteln("Nothing to do for", string);
                }
            }
        }

        void copyItem() {
            this.ensureNoExpansionPanel();
            super.copyItem();
        }

        void addSubitems() {
            Refinement refinement = this.expansionPanel.makePartialRefinement();
            ActivityEditor.this.agendaViewer.expandItem(this.editingItem, refinement);
        }

        public void statusChanged(AgendaItemEvent agendaItemEvent) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem != this.editingItem) {
                return;
            }
            Debug.noteln("Status change while editing item", agendaItem);
            Status status = agendaItem.getStatus();
            if (status != Status.BLANK && status != Status.POSSIBLE) {
                this.modifyButton.setEnabled(false);
                this.expansionButton.setEnabled(this.expansionButton.getText().equals("Specify Subactivities"));
            }
        }

        void addExpansionPanel() {
            Debug.assert(!this.expansionPanelIsShown());
            Debug.assert(this.editingItem != null, "can't edit new item subitems");
            this.expansionPanel.loadFromItem(this.editingItem);
            ActivityEditor.this.saveAsRefinementItem.setEnabled(true);
            if (this.editingItem.getChildren().isEmpty()) {
                this.expansionButton.setText("Install Subactivities");
                Status status = this.editingItem.getStatus();
                if (status == Status.BLANK || status == Status.POSSIBLE) {
                    this.expansionButton.setEnabled(true);
                } else {
                    this.expansionButton.setEnabled(false);
                }
            } else {
                this.expansionButton.setText("Modify Subactivities");
                this.expansionButton.setEnabled(false);
            }
            this.add((Component)this.expansionPanel, this.getComponentCount() - 1);
            ActivityEditor.this.frame.pack();
        }

        void ensureNoExpansionPanel() {
            if (this.expansionPanelIsShown()) {
                ActivityEditor.this.saveAsRefinementItem.setEnabled(false);
                this.expansionButton.setText("Specify Subactivities");
                this.expansionButton.setEnabled(true);
                this.remove(this.expansionPanel);
                ActivityEditor.this.frame.pack();
            }
        }

        boolean expansionPanelIsShown() {
            return this.getComponent(this.getComponentCount() - 2) == this.expansionPanel;
        }

        class ExpansionPanel
        extends JPanel {
            JTextArea subitemText;
            SimpleDomainEditor.TemporalConstraintPanel constraintPanel;

            ExpansionPanel() {
                this.subitemText = new JTextArea(5, ActivityEditPanel.this.textCols);
                this.constraintPanel = new SimpleDomainEditor.TemporalConstraintPanel();
                this.setLayout(new BoxLayout(this, 1));
                this.setUp();
            }

            void setUp() {
                this.add(ActivityEditPanel.this.makeLeftLabel("Subitems"));
                this.add(new JScrollPane(this.subitemText));
                this.add(ActivityEditPanel.this.makeLeftLabel("Constraints"));
                this.add(this.constraintPanel);
            }

            Refinement makePartialRefinement() {
                LList lList = Lisp.elementsFromString(ActivityEditPanel.this.itemText.getText().trim());
                String string = this.subitemText.getText().trim();
                List list = SimpleDomainEditor.parseNodes(string);
                String string2 = this.constraintPanel.getOrderingChoice();
                List list2 = string2.equals("Sequential") ? SimpleDomainEditor.sequentialOrderings(list) : null;
                Refinement refinement = new Refinement();
                refinement.setPattern(lList);
                refinement.setNodes(list);
                refinement.setOrderings(list2);
                refinement.setComments(ActivityEditPanel.this.commentText.getText());
                return refinement;
            }

            void loadFromItem(AgendaItem agendaItem) {
                Debug.noteln("Editing orderings of", agendaItem);
                List list = agendaItem.getChildren();
                List list2 = this.itemOrderings(agendaItem);
                Debug.noteln("Orderings = ", list2);
                this.subitemText.setText(this.subitemsToText(list));
                this.constraintPanel.loadFromOrderings(list, list2);
            }

            String subitemsToText(List list) {
                String string = System.getProperty("line.separator");
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AgendaItem agendaItem = (AgendaItem)iterator.next();
                    stringBuffer.append(Lisp.elementsToString(agendaItem.getPattern()));
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }

            List itemOrderings(AgendaItem agendaItem) {
                return Lisp.NIL;
            }
        }
    }
}

