/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Activity;
import ix.icore.Issue;
import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.domain.Refinement;
import ix.ip2.ActivityItem;
import ix.ip2.Agenda;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ip2.IssueItem;
import ix.ip2.PanelController;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.lisp.LList;
import ix.util.match.MatchEnv;
import ix.util.match.Matcher;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ActivityAgenda
extends Agenda {
    public ActivityAgenda(PanelController panelController) {
        super(panelController);
    }

    public AgendaItem makeItem(LList lList) {
        return new ActivityItem(new Activity(lList));
    }

    public void addItem(AgendaItem agendaItem) {
        agendaItem.setPattern(this.modelManager.putVariablesInPattern(agendaItem.getPattern()));
        this.modelManager.addNode(agendaItem);
        agendaItem.computeStatus();
        super.addItem(agendaItem);
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        super.addHandlerActions(agendaItem);
        Iterator iterator = this.controller.domain.getRefinements().iterator();
        while (iterator.hasNext()) {
            Refinement refinement = (Refinement)iterator.next();
            MatchEnv matchEnv = Matcher.match(refinement.getPattern(), agendaItem.getPattern());
            if (matchEnv == null) continue;
            if (Collect.isEmpty(refinement.getNodes()) && Collect.isEmpty(refinement.getConstraints())) {
                agendaItem.addAction(new HandlerAction.Manual(refinement.getName()));
                continue;
            }
            agendaItem.addAction(new ExpandAction(agendaItem, refinement, matchEnv));
        }
    }

    public void refinementAdded(Refinement refinement) {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            AgendaItem agendaItem = (AgendaItem)iterator.next();
            MatchEnv matchEnv = Matcher.match(refinement.getPattern(), agendaItem.getPattern());
            if (matchEnv == null) continue;
            if (Collect.isEmpty(refinement.getNodes()) && Collect.isEmpty(refinement.getConstraints())) {
                Debug.noteln("New manual primitive for", agendaItem);
                agendaItem.addAction(new HandlerAction.Manual(refinement.getName()));
                continue;
            }
            Debug.noteln("New expansion for", agendaItem);
            agendaItem.addAction(new ExpandAction(agendaItem, refinement, matchEnv));
        }
    }

    public void expandItem(AgendaItem agendaItem, Refinement refinement) {
        Refinement refinement2 = refinement;
        if (refinement2.getName() == null) {
            refinement2.setName("temporary partial schema");
        }
        ManualExpandAction manualExpandAction = new ManualExpandAction(agendaItem, refinement2);
        agendaItem.addAction(manualExpandAction);
        ((HandlerAction)manualExpandAction).handle(agendaItem);
        this.fireItemHandled(agendaItem, manualExpandAction);
    }

    class ManualExpandAction
    extends ExpandAction {
        ManualExpandAction(AgendaItem agendaItem, Refinement refinement) {
            super(agendaItem, refinement, new MatchEnv());
            this.shortDescription = "Expand as below";
        }

        public void handle(AgendaItem agendaItem) {
            this.do_expansion(agendaItem);
            if (agendaItem.getStatus() == Status.POSSIBLE) {
                agendaItem.setStatus(Collect.isEmpty(agendaItem.getChildren()) ? Status.COMPLETE : Status.EXECUTING);
            }
        }
    }

    class ExpandAction
    extends HandlerAction {
        AgendaItem item;
        Refinement refinement;
        MatchEnv env;
        List filterConds;
        MatchEnv filterEnv = null;

        ExpandAction(AgendaItem agendaItem, Refinement refinement, MatchEnv matchEnv) {
            this.item = agendaItem;
            this.refinement = refinement;
            this.env = matchEnv;
            this.filterConds = refinement.getFilterConditions();
            this.shortDescription = "Expand using " + refinement.getName();
        }

        public boolean isStillValid() {
            this.env = Matcher.match(this.refinement.getPattern(), this.item.getPattern());
            return this.env != null;
        }

        public boolean isReady() {
            return this.filterConds.isEmpty() || this.filterEnv != null;
        }

        public void computeStatus() {
            if (!this.filterConds.isEmpty()) {
                this.filterEnv = ActivityAgenda.this.modelManager.evalFilters(this.filterConds, this.env);
            }
        }

        public void handle(AgendaItem agendaItem) {
            Debug.assert(this.isReady(), this + " asked to handle " + agendaItem + " when not ready");
            Debug.assert(agendaItem == this.item);
            this.do_expansion(agendaItem);
            Debug.assert(agendaItem.getStatus() == Status.POSSIBLE);
            agendaItem.setStatus(Collect.isEmpty(agendaItem.getChildren()) ? Status.COMPLETE : Status.EXECUTING);
        }

        protected void do_expansion(AgendaItem agendaItem) {
            Object object;
            Debug.noteln("Expanding using", this.refinement);
            MatchEnv matchEnv = this.filterEnv != null ? this.filterEnv : this.env;
            agendaItem.expandOneLevel(this.refinement, matchEnv);
            this.applyEnv(matchEnv);
            Iterator iterator = Collect.iterator(agendaItem.getChildren());
            while (iterator.hasNext()) {
                object = (AgendaItem)iterator.next();
                ActivityAgenda.this.addItem((AgendaItem)object);
            }
            object = Collect.iterator(agendaItem.refinement.getIssues());
            while (object.hasNext()) {
                Issue issue = (Issue)object.next();
                ActivityAgenda.this.controller.getIssueAgenda().addItem(new IssueItem(issue));
            }
            if (agendaItem.refinement.getConstraints() != null) {
                ActivityAgenda.this.modelManager.addConstraints(agendaItem, agendaItem.refinement.getConstraints());
            }
        }

        protected void applyEnv(MatchEnv matchEnv) {
            HashMap hashMap = null;
            Iterator iterator = matchEnv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (!(k instanceof Variable)) continue;
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                hashMap.put(k, entry.getValue());
            }
            if (hashMap != null) {
                ActivityAgenda.this.modelManager.newBindings(hashMap);
            }
        }
    }
}

