/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.ichat.ChatMessage;
import ix.icore.Activity;
import ix.icore.Issue;
import ix.icore.Report;
import ix.icore.ReportType;
import ix.icore.YesNo;
import ix.icore.domain.Constraint;
import ix.util.IPC;
import ix.util.Name;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.xml.XML;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class Reporting {
    static SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy HH:mm:ss");

    private Reporting() {
    }

    public static String messageDescription(IPC.InputMessage inputMessage) {
        Object object = inputMessage.getContents();
        if (object instanceof Issue) {
            return Reporting.issueDescription((Issue)object);
        }
        if (object instanceof Activity) {
            return Reporting.activityDescription((Activity)object);
        }
        if (object instanceof Report) {
            return Reporting.reportDescription((Report)object);
        }
        if (object instanceof Constraint) {
            return Reporting.constraintDescription((Constraint)object);
        }
        if (object instanceof ChatMessage) {
            return Reporting.chatMessageDescription((ChatMessage)object);
        }
        return "Unexpected message containing: " + inputMessage;
    }

    public static String issueDescription(Issue issue) {
        Name name = issue.getSenderId();
        Name name2 = issue.getRef();
        YesNo yesNo = issue.getReportBack();
        return Reporting.dateString() + " Issue from " + name + (name2 == null ? "" : " ref=" + name2) + (yesNo == null ? "" : " report-back=" + yesNo) + " priority=" + issue.getPriority() + ": " + Util.quote(Reporting.patternDescription(issue.getPattern()));
    }

    public static String activityDescription(Activity activity) {
        Name name = activity.getSenderId();
        Name name2 = activity.getRef();
        YesNo yesNo = activity.getReportBack();
        return Reporting.dateString() + " Activity from " + name + (name2 == null ? "" : " ref=" + name2) + (yesNo == null ? "" : " report-back=" + yesNo) + " priority=" + activity.getPriority() + ": " + Util.quote(Reporting.patternDescription(activity.getPattern()));
    }

    public static String patternDescription(LList lList) {
        return Lisp.elementsToString(lList);
    }

    public static String constraintDescription(Constraint constraint) {
        Name name = constraint.getSenderId();
        return Reporting.dateString() + "Constraint from " + name + ":" + XML.objectToXMLString(constraint);
    }

    public static String reportDescription(Report report) {
        Name name = report.getSenderId();
        Name name2 = report.getRef();
        ReportType reportType = report.getReportType();
        return Reporting.dateString() + " Report from " + name + (name2 == null ? "" : " ref=" + name2) + (reportType == null ? "" : " type=" + reportType) + ": " + Util.quote(report.getText());
    }

    public static String chatMessageDescription(ChatMessage chatMessage) {
        String string = System.getProperty("line.separator");
        Name name = chatMessage.getSenderId();
        List list = Strings.breakIntoLines(chatMessage.getText());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Reporting.dateString()).append(" Message from ").append(name).append(":");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringBuffer.append(string).append("   ").append(string2);
        }
        return stringBuffer.toString();
    }

    public static String dateString() {
        return dateFormat.format(new Date());
    }
}

