/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.icore.Priority;
import ix.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class PriorityComboBox
extends JComboBox {
    public PriorityComboBox() {
        this.setRenderer(new PriorityCellRenderer());
        ArrayList arrayList = new ArrayList(Priority.values());
        Collections.reverse(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Priority priority = (Priority)iterator.next();
            this.addItem(priority);
        }
        this.setSelectedItem(Priority.NORMAL);
    }

    public Priority getSelectedPriority() {
        return (Priority)this.getSelectedItem();
    }

    public void setPriority(Priority priority) {
        this.setSelectedItem(priority);
        this.setBackground(priority.getColor());
    }

    public static class PriorityCellRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer {
        Map displayNames = new HashMap();
        Map selectedBorders = new HashMap();
        Map unselectedBorders = new HashMap();

        public PriorityCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Priority priority = (Priority)object;
            this.setText(Strings.capitalize(priority.toString()));
            this.setBackground(priority.getColor());
            this.setForeground(Color.black);
            if (bl) {
                this.setBorder(this.getBorder(this.selectedBorders, priority, true));
            } else {
                this.setBorder(this.getBorder(this.unselectedBorders, priority, false));
            }
            return this;
        }

        String getDisplayName(Priority priority) {
            String string = (String)this.displayNames.get(priority);
            if (string == null) {
                string = Strings.capitalize(priority.toString());
                this.displayNames.put(priority, string);
            }
            return string;
        }

        Border getBorder(Map map, Priority priority, boolean bl) {
            Border border = (Border)map.get(priority);
            if (border == null) {
                border = this.makeBorder(priority, bl);
                map.put(priority, border);
            }
            return border;
        }

        Border makeBorder(Priority priority, boolean bl) {
            if (bl) {
                return BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black, 1), BorderFactory.createMatteBorder(1, 4, 1, 5, priority.getColor()));
            }
            return BorderFactory.createMatteBorder(2, 5, 2, 5, priority.getColor());
        }
    }
}

