/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.util.Debug;
import ix.util.Strings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JOptionPane;

public class CatchingActionListener
implements ActionListener {
    ActionListener innerListener;
    static Map listenerCache = new WeakHashMap();

    public CatchingActionListener(ActionListener actionListener) {
        this.innerListener = actionListener;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.innerListener.actionPerformed(actionEvent);
        }
        catch (Throwable throwable) {
            Debug.noteException(throwable);
            this.handleException(actionEvent, throwable);
        }
    }

    public void handleException(ActionEvent actionEvent, Throwable throwable) {
        String string = actionEvent.getActionCommand();
        JOptionPane.showMessageDialog(null, new Object[]{"Problem during command " + Strings.quote(string), CatchingActionListener.description(throwable)}, "Error during " + string, 0);
    }

    public static String description(Throwable throwable) {
        return Strings.foldLongLine(Debug.describeException(throwable));
    }

    public static ActionListener listener(ActionListener actionListener) {
        ActionListener actionListener2 = (ActionListener)listenerCache.get(actionListener);
        if (actionListener2 == null) {
            actionListener2 = new CatchingActionListener(actionListener);
            listenerCache.put(actionListener, actionListener2);
        }
        return actionListener2;
    }

    public static void recordListener(ActionListener actionListener, ActionListener actionListener2) {
        listenerCache.put(actionListener, actionListener2);
    }
}

