/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui.table;

import ix.iface.ui.IXComboBox;
import ix.iface.ui.NDRenderer;
import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class IXDefaultCellEditor
implements FocusListener,
ActionListener,
PopupMenuListener,
CellEditorListener,
TableCellEditor {
    int colWidth;
    TableColumn column;
    IXEditorDelegate delegate;
    protected JComponent editorComponent;
    protected int clickCountToStart = 1;
    HashSet listeners = new HashSet();
    protected transient ChangeEvent changeEvent = null;

    public IXDefaultCellEditor(final IXComboBox iXComboBox) {
        this.editorComponent = iXComboBox;
        iXComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.delegate = new IXEditorDelegate(){

            public void setValue(Object object) {
                iXComboBox.setSelectedItem(object);
            }

            public Object getCellEditorValue() {
                return iXComboBox.getSelectedItem();
            }

            public boolean shouldSelectCell(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    return mouseEvent.getID() != 506;
                }
                return true;
            }

            public boolean stopCellEditing() {
                if (iXComboBox.isEditable()) {
                    iXComboBox.actionPerformed(new ActionEvent(IXDefaultCellEditor.this, 0, ""));
                }
                return super.stopCellEditing();
            }
        };
        iXComboBox.addActionListener(this.delegate);
        iXComboBox.setEditable(false);
        UIUtil.listenToCB(iXComboBox, this);
        ListCellRenderer listCellRenderer = iXComboBox.getRenderer();
        if (listCellRenderer == null) {
            iXComboBox.setRenderer(new NDRenderer(false));
        }
        iXComboBox.getEditor().addActionListener(this);
        this.addCellEditorListener(this);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        try {
            IXComboBox iXComboBox = (IXComboBox)this.editorComponent;
            iXComboBox.clearSelectedItem();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this.editorComponent;
    }

    public void adjustWidth(IXComboBox iXComboBox, JTable jTable, int n) {
        Debug.noteln("IXDCE: adjusting width");
        this.column = jTable.getColumnModel().getColumn(n);
        this.colWidth = this.column.getPreferredWidth();
        int n2 = 0;
        String string = "";
        int n3 = 0;
        while (n3 < iXComboBox.getItemCount()) {
            String string2 = iXComboBox.getItemAt(n3).toString();
            if (n2 < string2.length()) {
                n2 = string2.length();
                string = string2;
            }
            ++n3;
        }
        int n4 = ((Component)iXComboBox).getFontMetrics(iXComboBox.getFont()).stringWidth(string);
        int n5 = iXComboBox.getPreferredSize().width;
        Debug.noteln(" current width", n5);
        int n6 = iXComboBox.getPreferredSize().height;
        int n7 = Math.max(n4, n5);
        Dimension dimension = new Dimension(n7, n6);
        Debug.noteln(" new dimension:", dimension.toString());
        iXComboBox.setBounds(iXComboBox.getX(), iXComboBox.getY(), n7, n6);
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return this.delegate.shouldSelectCell(eventObject);
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Debug.noteln("***IXDE: Losing focus");
        this.stopCellEditing();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        Debug.noteln("IXDCE: canceling");
        this.cancelCellEditing();
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        Debug.noteln("IXDCE: stopping");
        this.stopCellEditing();
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        if (this.column != null) {
            this.column.setPreferredWidth(this.colWidth);
        }
    }

    public void editingStopped(ChangeEvent changeEvent) {
        if (this.column != null) {
            this.column.setPreferredWidth(this.colWidth);
        }
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.add(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.remove(cellEditorListener);
    }

    protected synchronized void fireEditingStopped() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)iterator.next()).editingStopped(this.changeEvent);
        }
    }

    protected synchronized void fireEditingCanceled() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)iterator.next()).editingCanceled(this.changeEvent);
        }
    }

    protected class IXEditorDelegate
    implements ActionListener,
    ItemListener {
        protected Object value;

        protected IXEditorDelegate() {
        }

        public Object getCellEditorValue() {
            return null;
        }

        public void setValue(Object object) {
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean startCellEditing(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void cancelCellEditing() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IXDefaultCellEditor.this.fireEditingStopped();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            IXDefaultCellEditor.this.fireEditingStopped();
        }
    }
}

