/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui.table;

import ix.iface.ui.table.AbstractIXTableModel;
import ix.iface.ui.table.IXTreeTableNode;
import ix.iface.ui.table.TableMouseListener;
import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import ix.util.Util;
import java.awt.event.MouseEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

public abstract class AbstractTreeTableModel
extends AbstractIXTableModel
implements TableMouseListener {
    public static final int INDENT_STEP = 4;
    public static final char LEAFC = ' ';
    public static final char OPENC = '-';
    public static final char CLOSEDC = '+';
    public static final ImageIcon LEAFI = null;
    public static final ImageIcon OPENI = Util.resourceImageIcon("ix-symbol-fold.gif");
    public static final ImageIcon CLOSEDI = Util.resourceImageIcon("ix-symbol-unfold.gif");
    protected ArrayList nodes = new ArrayList();
    public HashMap nodeMap = new HashMap();
    static /* synthetic */ Class class$javax$swing$ImageIcon;
    static /* synthetic */ Class class$java$lang$Character;

    public AbstractTreeTableModel() {
    }

    public AbstractTreeTableModel(TreeNode[] treeNodeArray) {
        this.setData(treeNodeArray);
    }

    public void setData(Collection collection) {
        this.clearData();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            IXTreeTableNode iXTreeTableNode = this.makeIXTreeTableNode(e);
            if (iXTreeTableNode == null) {
                Debug.noteln("WARNING: Tree table is ignoring node", e.toString());
                Debug.noteln(" It is of class " + e.getClass().getName());
                Debug.noteln(" and not a valid TreeNode.");
                continue;
            }
            if (this.rows.contains(iXTreeTableNode)) continue;
            this.rows.add(iXTreeTableNode);
            this.nodes.add(iXTreeTableNode);
        }
        this.fireTableDataChanged();
    }

    public void setData(Object[] objectArray) {
        this.setData(Arrays.asList(objectArray));
    }

    public void clearData() {
        this.rows.clear();
        this.nodes.clear();
        this.nodeMap.clear();
    }

    public void clearTable() {
        this.rows.clear();
        this.nodes.clear();
        this.fireTableDataChanged();
    }

    public void addData(Object object) {
        if (object == null) {
            Debug.noteln("AbstractTTM: Cannot add null data to table");
            new Throwable().printStackTrace();
        } else {
            IXTreeTableNode iXTreeTableNode = this.makeIXTreeTableNode(object);
            if (!this.rows.contains(iXTreeTableNode)) {
                this.rows.add(iXTreeTableNode);
                this.nodes.add(iXTreeTableNode);
                this.fireTableDataChanged();
            }
        }
    }

    public void removeData(Object object) {
        this.removeDataNode((IXTreeTableNode)this.getTreeNode(object));
    }

    private void addNode(IXTreeTableNode iXTreeTableNode, int n) {
        this.rows.add(n, iXTreeTableNode);
        if (iXTreeTableNode.expanded) {
            this.forceExpandNode(iXTreeTableNode, n);
        }
        this.fireTableDataChanged();
    }

    public void removeDataNode(IXTreeTableNode iXTreeTableNode) {
        if (iXTreeTableNode == null) {
            return;
        }
        boolean bl = this.removeChildData(iXTreeTableNode);
        if (this.rows.contains(iXTreeTableNode)) {
            this.rows.remove(iXTreeTableNode);
            ((AbstractCollection)this.nodes).remove(iXTreeTableNode);
            this.removeTreeNode(iXTreeTableNode.node);
            bl = true;
        }
        if (bl) {
            this.fireTableDataChanged();
        }
    }

    public void removeNodes(int n, int n2) {
        if (n == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            this.rows.remove(n2);
            ++n3;
        }
        this.fireTableDataChanged();
    }

    public void setColumnNames(String[] stringArray) {
        super.setColumnNames(stringArray);
        this.columnNames.add(0, "");
        Class clazz = this.determineTreeTypeClass();
        this.columnClasses.add(0, clazz);
    }

    public void setColumnFields(Class clazz, String[] stringArray) {
        super.setColumnFields(clazz, stringArray);
        this.columnFields.add(0, "treeType");
        this.columnNames.add(0, "");
        Class clazz2 = this.determineTreeTypeClass();
        this.columnClasses.add(0, clazz2);
    }

    private Class determineTreeTypeClass() {
        if (OPENI != null) {
            return class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = AbstractTreeTableModel.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon;
        }
        return class$java$lang$Character == null ? (class$java$lang$Character = AbstractTreeTableModel.class$("java.lang.Character")) : class$java$lang$Character;
    }

    public Object getRowObject(int n) {
        if (n < 0) {
            return null;
        }
        IXTreeTableNode iXTreeTableNode = (IXTreeTableNode)this.rows.get(n);
        return iXTreeTableNode.node;
    }

    public Object getRowNode(int n) {
        return this.rows.get(n);
    }

    public int getObjectRow(Object object) {
        TreeNode treeNode = this.getTreeNode(object);
        return super.getObjectRow(treeNode);
    }

    public Object getValueAt(int n, int n2) {
        IXTreeTableNode iXTreeTableNode = (IXTreeTableNode)this.rows.get(n);
        if (n2 == 0) {
            return this.getTreeNodeType(iXTreeTableNode);
        }
        if (n2 == 1) {
            return this.getTreeValueAt(iXTreeTableNode);
        }
        return this.getCellValueAt(iXTreeTableNode, n2 - 1);
    }

    protected Object getTreeValueAt(IXTreeTableNode iXTreeTableNode) {
        return this.toIndentedString(iXTreeTableNode);
    }

    public void expandNode(IXTreeTableNode iXTreeTableNode, int n) {
        if (iXTreeTableNode.expanded) {
            return;
        }
        this.forceExpandNode(iXTreeTableNode, n);
    }

    public void forceExpandNode(IXTreeTableNode iXTreeTableNode, int n) {
        Enumeration<? extends TreeNode> enumeration = iXTreeTableNode.children();
        if (enumeration != null) {
            LinkedList<Object> linkedList = new LinkedList<Object>(iXTreeTableNode.parentLine);
            linkedList.addLast(iXTreeTableNode.node);
            int n2 = iXTreeTableNode.indent + 4;
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = enumeration.nextElement();
                IXTreeTableNode iXTreeTableNode2 = (IXTreeTableNode)this.getTreeNode(treeNode, linkedList, n2);
                this.addNode(iXTreeTableNode2, n + 1);
                iXTreeTableNode.kids.add(iXTreeTableNode2);
            }
            iXTreeTableNode.setExpanded(true);
            this.fireTableDataChanged();
        }
    }

    public void unexpandNode(IXTreeTableNode iXTreeTableNode, int n) {
        if (!iXTreeTableNode.expanded) {
            return;
        }
        this.removeChildren(iXTreeTableNode, n);
        iXTreeTableNode.setExpanded(false);
        this.fireTableDataChanged();
    }

    protected void removeChildren(IXTreeTableNode iXTreeTableNode, int n) {
        if (!iXTreeTableNode.expanded) {
            return;
        }
        int n2 = iXTreeTableNode.kids.size();
        if (n2 != 0) {
            int n3 = n + 1;
            Iterator iterator = iXTreeTableNode.kids.iterator();
            while (iterator.hasNext()) {
                IXTreeTableNode iXTreeTableNode2 = (IXTreeTableNode)iterator.next();
                this.removeChildren(iXTreeTableNode2, n3);
                this.rows.remove(iXTreeTableNode2);
                ++n3;
            }
        }
    }

    protected boolean removeChildData(IXTreeTableNode iXTreeTableNode) {
        if (iXTreeTableNode.isLeaf()) {
            return false;
        }
        int n = iXTreeTableNode.kids.size();
        if (n != 0) {
            Iterator iterator = iXTreeTableNode.kids.iterator();
            while (iterator.hasNext()) {
                IXTreeTableNode iXTreeTableNode2 = (IXTreeTableNode)iterator.next();
                this.removeChildData(iXTreeTableNode2);
                this.rows.remove(iXTreeTableNode2);
                ((AbstractCollection)this.nodes).remove(iXTreeTableNode2);
                this.removeTreeNode(iXTreeTableNode2.node);
            }
            iXTreeTableNode.kids.clear();
            return true;
        }
        return false;
    }

    private String toIndentedString(IXTreeTableNode iXTreeTableNode) {
        String string = new String();
        int n = 0;
        while (n < iXTreeTableNode.indent) {
            string = string + " ";
            ++n;
        }
        string = string + this.getNameString(iXTreeTableNode);
        return string;
    }

    public Object getTreeNodeType(IXTreeTableNode iXTreeTableNode) {
        if ((class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = AbstractTreeTableModel.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon).isAssignableFrom(this.getColumnClass(0))) {
            return this.getTypeIcon(iXTreeTableNode);
        }
        return this.getTypeChar(iXTreeTableNode);
    }

    private ImageIcon getTypeIcon(IXTreeTableNode iXTreeTableNode) {
        ImageIcon imageIcon = null;
        imageIcon = iXTreeTableNode.isLeaf() ? LEAFI : (iXTreeTableNode.expanded ? OPENI : CLOSEDI);
        return imageIcon;
    }

    private Character getTypeChar(IXTreeTableNode iXTreeTableNode) {
        char c = iXTreeTableNode.isLeaf() ? (char)' ' : (iXTreeTableNode.expanded ? (char)'-' : '+');
        return new Character(c);
    }

    public void cellClicked(MouseEvent mouseEvent, int n, int n2) {
        IXTreeTableNode iXTreeTableNode;
        int n3 = mouseEvent.getModifiers();
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && n2 == 0 && !(iXTreeTableNode = (IXTreeTableNode)this.rows.get(n)).isLeaf()) {
            if (iXTreeTableNode.expanded) {
                this.unexpandNode(iXTreeTableNode, n);
            } else {
                this.expandNode(iXTreeTableNode, n);
            }
        }
    }

    public abstract Object getCellValueAt(Object var1, int var2);

    public abstract String getNameString(TreeNode var1);

    public void fireObjectChanged(Object object) {
        IXTreeTableNode iXTreeTableNode = (IXTreeTableNode)this.getTreeNode(object);
        if (iXTreeTableNode == null) {
            return;
        }
        int n = super.getObjectRow(iXTreeTableNode);
        if (iXTreeTableNode.expanded) {
            this.unexpandNode(iXTreeTableNode, n);
            this.expandNode(iXTreeTableNode, n);
        } else {
            this.fireTableDataChanged();
        }
    }

    public String defaultGetNameString(TreeNode treeNode) {
        return (String)super.defaultGetCellValueAt(treeNode, 0);
    }

    protected void deriveColumnFields() {
        super.deriveColumnFields();
        int n = AbstractTreeTableModel.findNameField(this.columnFields);
        String string = (String)this.columnFields.get(n);
        this.columnFields.remove(n);
        this.columnFields.add(0, string);
        String string2 = (String)this.columnNames.get(n);
        this.columnNames.remove(n);
        this.columnNames.add(0, string);
    }

    private static int findNameField(ArrayList arrayList) {
        int n = arrayList.indexOf("name");
        if (n != -1) {
            return n;
        }
        n = arrayList.indexOf("Name");
        if (n != -1) {
            return n;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            String string = UIUtil.toCapitalised((String)arrayList.get(n2));
            if (string.indexOf("NAME") != -1) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    public TreeNode getTreeNode(Object object) {
        if (object == null) {
            return null;
        }
        TreeNode treeNode = (TreeNode)this.nodeMap.get(object);
        if (treeNode == null) {
            treeNode = this.makeIXTreeTableNode(object);
            this.addTreeNode(object, treeNode);
        }
        return treeNode;
    }

    public TreeNode getTreeNode(Object object, List list, int n) {
        if (object == null) {
            return null;
        }
        IXTreeTableNode iXTreeTableNode = (IXTreeTableNode)this.nodeMap.get(object);
        if (iXTreeTableNode == null) {
            iXTreeTableNode = this.makeIXTreeTableNode(object, list, n);
            this.addTreeNode(object, iXTreeTableNode);
        } else if (list != null && !list.equals(iXTreeTableNode.parentLine) || list == null && iXTreeTableNode.parentLine != null || n != iXTreeTableNode.indent) {
            iXTreeTableNode = this.makeIXTreeTableNode(object, list, n);
            this.addTreeNode(object, iXTreeTableNode);
        }
        return iXTreeTableNode;
    }

    public void addTreeNode(Object object, TreeNode treeNode) {
        IXTreeTableNode iXTreeTableNode = (IXTreeTableNode)treeNode;
        this.nodeMap.put(object, treeNode);
    }

    public void removeTreeNode(Object object) {
        if (this.nodeMap.containsKey(object)) {
            this.nodeMap.remove(object);
        }
    }

    public abstract IXTreeTableNode makeIXTreeTableNode(Object var1);

    public IXTreeTableNode makeIXTreeTableNode(Object object, List list, int n) {
        IXTreeTableNode iXTreeTableNode = this.makeIXTreeTableNode(object);
        iXTreeTableNode.setParents(list);
        iXTreeTableNode.indent = n;
        return iXTreeTableNode;
    }

    public String ixTTNListToString(List list) {
        String string = "";
        if (list == null) {
            return string;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IXTreeTableNode iXTreeTableNode = (IXTreeTableNode)iterator.next();
            string = string + iXTreeTableNode.toString() + " (" + iXTreeTableNode.toDebug() + ") ";
        }
        return string.trim();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

