/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui.table;

import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractIXTableModel
extends AbstractTableModel {
    protected ArrayList columnFields = new ArrayList();
    protected ArrayList columnNames = new ArrayList();
    protected ArrayList columnClasses = new ArrayList();
    protected Class objectClass;
    protected List rows = new LinkedList();

    public AbstractIXTableModel() {
    }

    public AbstractIXTableModel(Object[] objectArray) {
        this.setData(objectArray);
    }

    public AbstractIXTableModel(Object[] objectArray, String[] stringArray) {
        this(objectArray);
        this.setColumnNames(stringArray);
    }

    public AbstractIXTableModel(Class clazz, Object[] objectArray) {
        this(objectArray);
        this.objectClass = clazz;
        this.deriveColumnFields();
    }

    public void setData(Object[] objectArray) {
        this.rows.clear();
        int n = 0;
        while (n < objectArray.length) {
            this.rows.add(objectArray[n]);
            ++n;
        }
        this.fireTableDataChanged();
    }

    public void addData(Object object) {
        if (!this.rows.contains(object)) {
            this.rows.add(object);
            this.fireTableDataChanged();
        }
    }

    public void removeData(Object object) {
        if (this.rows.remove(object)) {
            this.fireTableDataChanged();
        }
    }

    public void clearData() {
        this.rows.clear();
        this.fireTableDataChanged();
    }

    public Object getRowObject(int n) {
        if (n < 0) {
            return null;
        }
        return this.rows.get(n);
    }

    public int getObjectRow(Object object) {
        return this.rows.indexOf(object);
    }

    public Object getValueAt(int n, int n2) {
        Object e = this.rows.get(n);
        return this.getCellValueAt(e, n2);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        String[] stringArray = this.getColumnNames();
        return stringArray.length;
    }

    public String getColumnName(int n) {
        String[] stringArray = this.getColumnNames();
        return stringArray[n];
    }

    public Class getColumnClass(int n) {
        Class<?> clazz = null;
        try {
            clazz = (Class<?>)this.columnClasses.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            clazz = super.getColumnClass(n);
        }
        return clazz;
    }

    public abstract Object getCellValueAt(Object var1, int var2);

    public void setColumnNames(String[] stringArray) {
        this.columnNames = new ArrayList<String>(Arrays.asList(stringArray));
    }

    public void setColumnClasses(Class[] classArray) {
        this.columnClasses = new ArrayList<Class>(Arrays.asList(classArray));
    }

    protected String[] getColumnNames() {
        String[] stringArray = new String[]{};
        return this.columnNames.toArray(stringArray);
    }

    public void setColumnFields(Class clazz, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            try {
                Field field = clazz.getField(string);
                String string2 = UIUtil.toCapitalised(string);
                Class<?> clazz2 = field.getType();
                this.columnFields.add(string);
                this.columnNames.add(string2);
                this.columnClasses.add(clazz2);
            }
            catch (Exception exception) {
                Debug.noteln("AIXTM: Problem setting column field " + string);
                Debug.noteException(exception);
            }
            ++n;
        }
    }

    protected void deriveColumnFields() {
        if (this.objectClass == null) {
            return;
        }
        ArrayList<Field> arrayList = new ArrayList<Field>(Arrays.asList(this.objectClass.getFields()));
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!AbstractIXTableModel.useField(field)) continue;
            this.columnFields.add(field.getName());
            this.columnNames.add(UIUtil.toCapitalised(field.getName()));
        }
    }

    private static boolean useField(Field field) {
        int n = field.getModifiers();
        return !Modifier.isStatic(n) && !Modifier.isPrivate(n) && !Modifier.isProtected(n);
    }

    protected void defaultSetColumnFields(String[] stringArray) {
        if (this.objectClass == null) {
            return;
        }
        this.columnFields.clear();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            try {
                this.objectClass.getField(string);
                this.columnFields.add(string);
                this.columnNames.add(UIUtil.toCapitalised(string));
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                try {
                    String string2 = UIUtil.toUncapitalised(string);
                    this.objectClass.getField(string2);
                    this.columnFields.add(string2);
                    this.columnNames.add(string);
                }
                catch (Exception exception2) {
                    Debug.noteException(exception2);
                }
            }
            ++n;
        }
    }

    protected Object defaultGetCellValueAt(Object object, int n) {
        if (this.objectClass == null) {
            return null;
        }
        if (this.columnFields == null || this.columnFields.isEmpty()) {
            return null;
        }
        try {
            String string = (String)this.columnFields.get(n);
            Field field = this.objectClass.getField(string);
            return field.get(object);
        }
        catch (Exception exception) {
            Debug.note("Exception during defaultGetCellValueAt(" + object.toString() + ", " + n + ")");
            Debug.noteException(exception);
            return null;
        }
    }
}

