/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.IXButPanel;
import ix.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class JPreferencesDialog
extends JDialog
implements MouseListener {
    public JFrame frame;
    public Properties properties;
    public JPanel prefsPanel;
    public HashSet booleanKeys = new HashSet();
    public HashMap keyComponents = new HashMap();
    private HashSet listeners = new HashSet();
    static /* synthetic */ Class class$javax$swing$AbstractButton;

    public JPreferencesDialog(JFrame jFrame, Properties properties) {
        super(jFrame);
        this.frame = jFrame;
        this.properties = properties;
        this.setTitle(this.frame.getTitle() + " - Preferences");
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        ((Component)this).setSize(248, 94);
        ((Component)this).setVisible(false);
        this.prefsPanel = new JPanel();
        Object[] objectArray = new String[]{"Close", "Apply", "Save", "Default", "Reload"};
        IXButPanel iXButPanel = new IXButPanel(this, 0, objectArray);
        this.getContentPane().add(this.prefsPanel);
        this.getContentPane().add((Component)iXButPanel, "South");
        this.makeComponents();
        this.pack();
        ((Component)this).setSize(this.getWidth(), this.getHeight() + 1);
        this.validate();
    }

    public void show() {
        this.setKeyComponents(this.properties);
        super.show();
    }

    public void getPropertiesFromComponents() {
        this.getPropertiesFromComponents(this.properties.propertyNames());
    }

    public void setKeyComponents(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            List list = (List)this.keyComponents.get(string);
            if (list != null && list.size() != 0 && this.isBooleanProperty(string, string2)) {
                Component component = (Component)list.iterator().next();
                this.setBooleanComponent(string, component, string2);
                continue;
            }
            this.setKeyComponent(string, list, string2);
        }
    }

    public void getPropertiesFromComponents(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            String string3 = this.properties.getProperty(string2);
            List list = (List)this.keyComponents.get(string2);
            if (list == null || list.size() == 0) continue;
            if (this.isBooleanProperty(string2, string3)) {
                Component component = (Component)list.iterator().next();
                string = this.getPropertyFromBooleanComponent(string2, component);
            } else {
                string = this.getPropertyFromComponent(string2, list);
            }
            if (string3.equals(string)) continue;
            this.properties.setProperty(string2, string);
        }
    }

    public Component makeBooleanComponent(String string, String string2) {
        boolean bl = new Boolean(string2);
        return new JCheckBox(string, bl);
    }

    public void setBooleanComponent(String string, Component component, String string2) {
        boolean bl = new Boolean(string2);
        JCheckBox jCheckBox = (JCheckBox)component;
        jCheckBox.setSelected(bl);
    }

    public String getPropertyFromBooleanComponent(String string, Component component) {
        JCheckBox jCheckBox = (JCheckBox)component;
        if (jCheckBox != null) {
            return new Boolean(jCheckBox.isSelected()).toString();
        }
        return "";
    }

    public boolean isBooleanProperty(String string, String string2) {
        if (this.notedBooleanProperty(string)) {
            return true;
        }
        Boolean bl = new Boolean(string2);
        if (bl.booleanValue()) {
            return true;
        }
        return bl.toString().equals(string2);
    }

    public boolean notedBooleanProperty(String string) {
        return this.booleanKeys.contains(string);
    }

    public void noteBooleanProperty(String string) {
        this.booleanKeys.add(string);
    }

    private void applyPreferences() {
        this.applyPreferences(this.properties.propertyNames());
    }

    public void applyPreferences(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            String string3 = this.properties.getProperty(string2);
            List list = (List)this.keyComponents.get(string2);
            if (list != null && list.size() != 0 && this.isBooleanProperty(string2, string3)) {
                Component component = (Component)list.iterator().next();
                string = this.getPropertyFromBooleanComponent(string2, component);
            } else {
                string = this.getPropertyFromComponent(string2, list);
            }
            this.properties.setProperty(string2, string);
            this.firePropertyChanged(string2, string3, string);
        }
    }

    private void savePreferences() {
        this.getPropertiesFromComponents();
        this.writePreferences(this.properties);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writePreferences(Properties properties) {
        FileOutputStream fileOutputStream = null;
        File file = this.getPreferencesFile();
        fileOutputStream = new FileOutputStream(file);
        properties.store(fileOutputStream, "--------- properties (preferences)  ---------");
        Debug.noteln("Wrote preferences to file", file);
        Object var6_5 = null;
        if (fileOutputStream == null) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (FileNotFoundException fileNotFoundException) {
                fileOutputStream = null;
                Debug.noteln("Warning:");
                Debug.noteln("Can't find properties file. Can't save.");
                Debug.noteln("");
                Object var6_6 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException iOException) {
                Debug.error("Can't save properties.");
                Object var6_7 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties loadPreferences(Properties properties) {
        FileInputStream fileInputStream = null;
        try {
            try {
                File file = this.getPreferencesFile();
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                Properties properties2 = properties;
                Object var7_8 = null;
                if (fileInputStream == null) return properties2;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileInputStream = null;
                Debug.noteln("Warning:");
                Debug.noteln("Can't find properties file. Can't load.");
                Debug.noteln("");
                Properties properties3 = null;
                Object var7_9 = null;
                if (fileInputStream == null) return properties3;
                try {
                    fileInputStream.close();
                    return properties;
                }
                catch (IOException iOException) {
                    return properties;
                }
            }
            catch (IOException iOException) {
                Debug.noteln("Warning:");
                Debug.noteln("Can't read properties file. Can't load.");
                Debug.noteln("");
                Properties properties4 = null;
                Object var7_10 = null;
                if (fileInputStream == null) return properties4;
                try {}
                catch (IOException iOException2) {
                    return properties;
                }
                fileInputStream.close();
                return properties;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (fileInputStream == null) {
                throw throwable;
            }
            try {}
            catch (IOException iOException) {
                return properties;
            }
            fileInputStream.close();
            return properties;
        }
        try {}
        catch (IOException iOException) {
            return properties;
        }
        fileInputStream.close();
        return properties;
    }

    void closePreferences() {
        try {
            ((Component)this).setVisible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void makeComponents();

    public abstract void setKeyComponent(String var1, List var2, String var3);

    public abstract String getPropertyFromComponent(String var1, List var2);

    public abstract void setDefaultPreferences(Properties var1);

    public abstract File getPreferencesFile();

    public void mouseClicked(MouseEvent mouseEvent) {
        Component component;
        if (!(class$javax$swing$AbstractButton == null ? (class$javax$swing$AbstractButton = JPreferencesDialog.class$("javax.swing.AbstractButton")) : class$javax$swing$AbstractButton).isInstance(component = mouseEvent.getComponent())) {
            return;
        }
        AbstractButton abstractButton = (AbstractButton)component;
        String string = abstractButton.getActionCommand();
        if (string.equals("Close")) {
            this.closePreferences();
        } else if (string.equals("Default")) {
            Properties properties = new Properties();
            this.setDefaultPreferences(properties);
            this.setKeyComponents(properties);
        } else if (string.equals("Apply")) {
            this.applyPreferences();
        } else if (string.equals("Save")) {
            this.savePreferences();
        } else if (string.equals("Reload")) {
            Properties properties = new Properties();
            this.loadPreferences(properties);
            this.setKeyComponents(properties);
        } else if (string.equals("Cancel")) {
            this.setKeyComponents(this.properties);
            this.closePreferences();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    public void setPropertyChangeListeners(HashSet hashSet) {
        this.listeners = hashSet;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    public void firePropertyChanged(String string, String string2, String string3) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, string2, string3);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)iterator.next();
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

