/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.CardPanel;
import ix.iface.ui.FramePanel;
import ix.iface.ui.FrameSymbols;
import ix.iface.ui.IXToolItem;
import ix.iface.ui.JFrameMT;
import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JFrameMTP
extends JFrameMT
implements ActionListener,
ChangeListener,
ItemListener,
FrameSymbols {
    public boolean isAdjusting = true;
    private ArrayList panelStyles;
    private String panelStyle;
    private ArrayList panels = new ArrayList();
    protected JTabbedPane tabbedPane = new JTabbedPane();
    protected CardPanel cardsPanel;
    private JPanel currentPanel;
    public JMenu windowsMenu;
    public JMenu styleMenu;

    public JFrameMTP() {
        this.tabbedPane.addChangeListener(this);
        this.cardsPanel = new CardPanel(this);
        String[] stringArray = new String[]{"single", "tabbed", "card"};
        this.panelStyles = new ArrayList<String>(Arrays.asList(stringArray));
        this.panelStyle = "single";
        this.makeMenuToolBars();
        this.isAdjusting = false;
        this.fillMainPanel();
    }

    public JFrameMTP(String string) {
        this();
        this.setPanelStyle(string);
    }

    public String getPanelStyle() {
        return this.panelStyle;
    }

    public boolean setPanelStyle(String string) {
        Debug.noteln("Setting style to", string);
        if (this.panelStyle.equals(string)) {
            this.setStyleInMenu(string);
            return true;
        }
        if (this.panelStyles.contains(string)) {
            Dimension dimension = this.getSize();
            this.panelStyle = string;
            this.changePanelStyle();
            this.setStyleInMenu(string);
            ((Component)this).setSize(dimension);
            this.validate();
            return true;
        }
        String string2 = "Style " + string + " is not recognised." + "\nl" + "Please use one of " + this.panelStyles.toString() + ".";
        Debug.warn(string2);
        return false;
    }

    protected void setStyleInMenu(String string) {
        if (this.styleMenu == null) {
            return;
        }
        Component[] componentArray = this.styleMenu.getMenuComponents();
        String string2 = "style " + string;
        int n = 0;
        while (n < componentArray.length) {
            JMenuItem jMenuItem = (JMenuItem)componentArray[n];
            if (jMenuItem.getActionCommand().equals(string2)) {
                jMenuItem.setSelected(true);
            }
            ++n;
        }
    }

    public ArrayList getPanelStyles() {
        return this.panelStyles;
    }

    public void setPanelStyles(ArrayList arrayList) {
        Debug.noteln("Setting styles to", arrayList);
        this.panelStyles = arrayList;
    }

    public ArrayList getPanels() {
        return this.panels;
    }

    public JPanel getACurrentPanel() {
        if (this.currentPanel == null && this.panels.size() > 0) {
            this.setCurrentPanel((JPanel)this.panels.get(0));
        }
        return this.currentPanel;
    }

    public JPanel getCurrentPanel() {
        return this.currentPanel;
    }

    public void setCurrentPanel(JPanel jPanel) {
        if (this.updateCurrentPanel(jPanel)) {
            this.fillMainPanel();
        }
    }

    protected boolean updateCurrentPanel(JPanel jPanel) {
        if (jPanel == null) {
            return false;
        }
        String string = jPanel.getName();
        if (jPanel.equals(this.currentPanel)) {
            return true;
        }
        if (this.currentPanelChanging(this.currentPanel, jPanel)) {
            this.currentPanel = jPanel;
            this.setWindowsMenuSelection(string);
            this.adaptMenusToPanel(jPanel);
            return true;
        }
        Debug.noteln("JFMTP: CANCEL current panel changing");
        Debug.noteln(" Current panel now is", this.currentPanel.getName());
        this.setCurrentPanel(this.currentPanel);
        return true;
    }

    protected boolean updateCurrentPanel(String string) {
        JPanel jPanel = this.getNamedPanel(string);
        return this.updateCurrentPanel(jPanel);
    }

    protected boolean currentPanelChanging(JPanel jPanel, JPanel jPanel2) {
        return true;
    }

    protected void adaptMenusToPanel(JPanel jPanel) {
    }

    protected JPanel getNamedPanel(String string) {
        int n = 0;
        while (n < this.panels.size()) {
            JPanel jPanel = (JPanel)this.panels.get(n);
            if (jPanel.getName() == string) {
                return jPanel;
            }
            ++n;
        }
        return null;
    }

    protected void setWindowsMenuSelection(String string) {
        if (this.windowsMenu == null) {
            return;
        }
        Component[] componentArray = this.windowsMenu.getMenuComponents();
        if (componentArray == null) {
            Debug.noteln("null menu things");
        }
        int n = 0;
        while (n < componentArray.length) {
            JMenuItem jMenuItem = (JMenuItem)componentArray[n];
            if (jMenuItem.getActionCommand() == string && !jMenuItem.isSelected()) {
                jMenuItem.setSelected(true);
            }
            ++n;
        }
    }

    public void addPanel(JPanel jPanel, String string, String string2) {
        jPanel.setName(string);
        jPanel.setToolTipText(string2);
        this.panels.add(jPanel);
        if (this.panelStyle.equals("tabbed")) {
            this.isAdjusting = true;
            if (this.tabbedPane != null) {
                this.tabbedPane.addTab(string, null, jPanel, string2);
            }
            this.isAdjusting = false;
        } else if (this.panelStyle.equals("card") && this.cardsPanel != null) {
            this.cardsPanel.addPanel(jPanel, string);
        }
        if (this.currentPanel == null) {
            this.setCurrentPanel(jPanel);
        }
    }

    public void removeAllPanels() {
        this.panels.clear();
        if (this.panelStyle.equals("tabbed")) {
            this.isAdjusting = true;
            if (this.tabbedPane != null) {
                this.tabbedPane.removeAll();
            }
            this.isAdjusting = false;
        } else if (this.panelStyle.equals("card") && this.cardsPanel != null) {
            this.cardsPanel.removeAllPanels();
        }
        this.setCurrentPanel(null);
    }

    private void fillMainPanel() {
        JComponent jComponent;
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        if (this.panelStyle.equals("tabbed")) {
            jComponent = this.fillTabbedPane(this.tabbedPane);
        } else if (this.panelStyle.equals("card")) {
            jComponent = this.fillCardPanel(this.cardsPanel);
        } else if (this.panelStyle.equals("single")) {
            jComponent = this.fillSimplePanel();
        } else {
            UIUtil.notImplemented(this, "Panel style " + this.panelStyle);
            return;
        }
        this.mainJPanel.removeAll();
        if (jComponent != null) {
            this.mainJPanel.add((Component)jComponent, gridBagConstraints);
            jComponent.invalidate();
        }
        this.validate();
    }

    private JTabbedPane fillTabbedPane(JTabbedPane jTabbedPane) {
        JPanel jPanel;
        jTabbedPane.setEnabled(false);
        this.isAdjusting = true;
        jTabbedPane.removeAll();
        int n = 0;
        while (n < this.panels.size()) {
            jPanel = (JPanel)this.panels.get(n);
            this.tabbedPane.addTab(jPanel.getName(), null, jPanel, jPanel.getToolTipText());
            ++n;
        }
        jPanel = this.getACurrentPanel();
        if (jPanel != null) {
            jTabbedPane.setSelectedComponent(jPanel);
            jPanel.invalidate();
            jPanel.setVisible(true);
            jPanel.validate();
        }
        jTabbedPane.setEnabled(true);
        this.isAdjusting = false;
        return jTabbedPane;
    }

    private JPanel fillCardPanel(CardPanel cardPanel) {
        JPanel jPanel;
        cardPanel.setEnabled(false);
        this.isAdjusting = true;
        cardPanel.isAdjusting = true;
        cardPanel.removeAllPanels();
        int n = 0;
        while (n < this.panels.size()) {
            jPanel = (JPanel)this.panels.get(n);
            cardPanel.addPanel(jPanel, jPanel.getName());
            ++n;
        }
        jPanel = this.getACurrentPanel();
        if (jPanel != null) {
            cardPanel.setPanel(this.currentPanel.getName());
            jPanel.invalidate();
        }
        cardPanel.isAdjusting = false;
        this.isAdjusting = false;
        return cardPanel;
    }

    private JPanel fillSimplePanel() {
        JPanel jPanel = this.getACurrentPanel();
        return jPanel;
    }

    private JPanel getSimplePane() {
        return this.getACurrentPanel();
    }

    public void makeDefaultMenuToolbar() {
        super.makeDefaultMenuToolbar();
        this.makeStyleMenu(this.optionsMenu);
        this.makeWindowsMenu(this.viewMenu);
        this.adaptDefaultMenuToolbar();
    }

    public void makeViewMenu() {
        super.makeViewMenu();
        if (this.viewMenu.getItemCount() != 0) {
            this.viewMenu.addSeparator();
        }
        this.makeWindowsMenu(this.viewMenu);
    }

    public void makeOptionsMenu() {
        super.makeOptionsMenu();
        this.makeStyleMenu(this.optionsMenu);
    }

    public JMenu makeWindowsMenu(JComponent jComponent) {
        this.windowsMenu = this.makeMenu(jComponent, "Windows");
        this.fillWindowsMenu();
        return this.windowsMenu;
    }

    public JMenu makeWindowsMenu(JComponent jComponent, String string) {
        this.windowsMenu = this.makeMenu(jComponent, string);
        this.fillWindowsMenu();
        return this.windowsMenu;
    }

    public JMenu makeStyleMenu(JComponent jComponent) {
        this.styleMenu = this.makeMenu(jComponent, "Panel Style");
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < this.panelStyles.size()) {
            String string = (String)this.panelStyles.get(n);
            IXToolItem iXToolItem = new IXToolItem(this.styleMenu, this, "style " + string, string, "Set style of panel switching to " + string);
            JRadioButtonMenuItem jRadioButtonMenuItem = iXToolItem.makeRadioItem();
            buttonGroup.add(jRadioButtonMenuItem);
            iXToolItem.showItem();
            if (string == this.panelStyle) {
                jRadioButtonMenuItem.setSelected(true);
            }
            ++n;
        }
        return this.styleMenu;
    }

    public void fillWindowsMenu() {
        this.windowsMenu.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < this.panels.size()) {
            JPanel jPanel = (JPanel)this.panels.get(n);
            String string = jPanel.getName();
            IXToolItem iXToolItem = new IXToolItem(this.windowsMenu, this, string, string, "Switch to " + string + " panel");
            JRadioButtonMenuItem jRadioButtonMenuItem = iXToolItem.makeRadioItem();
            buttonGroup.add(jRadioButtonMenuItem);
            iXToolItem.showItem();
            ++n;
        }
        this.windowsMenu.setEnabled(true);
    }

    protected void changePanelStyle() {
        this.fillMainPanel();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.cardsPanel.isAdjusting) {
            return;
        }
        String string = (String)itemEvent.getItem();
        this.updateCurrentPanel(string);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.isAdjusting) {
            return;
        }
        Component component = (Component)changeEvent.getSource();
        if (!component.isEnabled()) {
            return;
        }
        if (component.equals(this.tabbedPane)) {
            Component component2 = ((JTabbedPane)component).getSelectedComponent();
            this.updateCurrentPanel((JPanel)component2);
        } else {
            Debug.noteln("Cannot process state change from", component);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isAdjusting) {
            return;
        }
        Object object = actionEvent.getSource();
        String string = ((AbstractButton)object).getActionCommand();
        FramePanel framePanel = (FramePanel)((Object)this.getCurrentPanel());
        if (framePanel != null && framePanel.frameActionPerformed(actionEvent)) {
            return;
        }
        Debug.noteln("JFrameMTP: action command is", string);
        if (string.equals("style tabbed")) {
            this.setPanelStyle("tabbed");
        } else if (string.equals("style card")) {
            this.setPanelStyle("card");
        } else if (string.equals("style single")) {
            this.setPanelStyle("single");
        } else {
            int n = 0;
            while (n < this.panels.size()) {
                JPanel jPanel = (JPanel)this.panels.get(n);
                if (string.equals(jPanel.getName())) {
                    this.setCurrentPanel(jPanel);
                    return;
                }
                ++n;
            }
            super.actionPerformed(actionEvent);
        }
    }
}

