/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.IXRenderer;
import ix.iface.util.RendererJText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public abstract class IXTextRenderer
extends RendererJText
implements IXRenderer,
TableCellRenderer,
ListCellRenderer {
    Border unselectedBorder = null;
    Border selectedBorder = null;
    Border lineSelectedBorder = null;
    Border lineUnselectedBorder = null;
    boolean isBordered = true;
    boolean isLined = false;
    int borderWidth = 2;
    int borderHeight = 5;

    public IXTextRenderer(boolean bl) {
        this.isBordered = bl;
        this.setOpaque(true);
        this.setBold(false);
    }

    public void setLined(boolean bl) {
        this.isLined = bl;
    }

    public void setBorderSize(int n, int n2) {
        this.borderWidth = n;
        this.borderHeight = n2;
    }

    public void setBold(boolean bl) {
        Font font;
        Font font2 = font = this.getFont();
        if (bl && font.isBold() || !bl && !font.isBold()) {
            return;
        }
        font2 = bl ? font.deriveFont(1) : font.deriveFont(0);
        this.setFont(font2);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color = jTable.getSelectionBackground();
        Color color2 = jTable.getBackground();
        return this.getCellRendererComponent(object, bl, bl2, color2, color);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Color color = jList.getSelectionBackground();
        Color color2 = jList.getBackground();
        return this.getCellRendererComponent(object, bl, bl2, color2, color);
    }

    private Component getCellRendererComponent(Object object, boolean bl, boolean bl2, Color color, Color color2) {
        Border border = null;
        if (bl) {
            if (this.isBordered) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(this.borderWidth, this.borderHeight, this.borderWidth, this.borderHeight, color2);
                }
                border = this.selectedBorder;
            } else if (this.isLined) {
                if (this.lineSelectedBorder == null) {
                    this.lineSelectedBorder = BorderFactory.createLineBorder(Color.black, 1);
                }
                border = this.lineSelectedBorder;
            }
            if (border != null) {
                this.setBorder(border);
            }
        } else {
            if (this.isBordered) {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(this.borderWidth, this.borderHeight, this.borderWidth, this.borderHeight, color);
                }
                border = this.unselectedBorder;
            } else if (this.isLined) {
                if (this.lineUnselectedBorder == null) {
                    this.lineUnselectedBorder = BorderFactory.createLineBorder(color, 1);
                }
                border = this.lineUnselectedBorder;
            }
            if (border != null) {
                this.setBorder(border);
            }
        }
        if (bl) {
            this.setBackground(color2);
        } else {
            this.setBackground(color);
        }
        this.setInfo(object);
        return this;
    }

    public abstract void setInfo(Object var1);
}

