/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.FourField;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

public abstract class IXPopupMenu
extends JPopupMenu {
    public IXPopupMenu() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                try {
                    MenuElement[] menuElementArray = IXPopupMenu.this.getSubElements();
                    int n = IXPopupMenu.this.getSelectionModel().getSelectedIndex();
                    if (n >= 0) {
                        JMenuItem jMenuItem = (JMenuItem)menuElementArray[n];
                        jMenuItem.setArmed(false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public IXPopupMenu(String string) {
        this();
        this.setLabel(string);
    }

    public JMenuItem add(String string) {
        return super.add(string);
    }

    public JMenuItem add(FourField fourField) {
        if (fourField == null) {
            return null;
        }
        JMenuItem jMenuItem = new JMenuItem();
        if (fourField.hasColour() && fourField.toColour() != null) {
            jMenuItem.setBackground(fourField.toColour());
        }
        String string = fourField.toString();
        if (fourField.hasSymbol() && fourField.toSymbol() != null) {
            jMenuItem.setText(string + " " + fourField.toSymbol());
        } else {
            jMenuItem.setText(string);
        }
        if (fourField.hasIcon() && fourField.toIcon() != null) {
            jMenuItem.setIcon(fourField.toIcon());
        }
        this.add(jMenuItem);
        return jMenuItem;
    }

    public JMenuItem findMenuItem(String string) {
        if (string == null) {
            return null;
        }
        MenuElement[] menuElementArray = this.getSubElements();
        int n = 0;
        while (n < menuElementArray.length) {
            JMenuItem jMenuItem = (JMenuItem)menuElementArray[n];
            if (string.equals(jMenuItem.getText())) {
                return jMenuItem;
            }
            ++n;
        }
        return null;
    }

    public void setSelected(JMenuItem jMenuItem) {
        if (jMenuItem != null) {
            MenuElement[] menuElementArray = this.getSubElements();
            int n = 0;
            while (n < menuElementArray.length) {
                JMenuItem jMenuItem2 = (JMenuItem)menuElementArray[n];
                if (jMenuItem != jMenuItem2 && jMenuItem2.isArmed()) {
                    jMenuItem2.setArmed(false);
                }
                ++n;
            }
            jMenuItem.setArmed(true);
            super.setSelected(jMenuItem);
        }
    }

    public void setSelected(String string) {
        JMenuItem jMenuItem = this.findMenuItem(string);
        this.setSelected(jMenuItem);
    }

    protected void clearArmed() {
        MenuElement[] menuElementArray = this.getSubElements();
        int n = 0;
        while (n < menuElementArray.length) {
            JMenuItem jMenuItem = (JMenuItem)menuElementArray[n];
            if (jMenuItem.isArmed()) {
                jMenuItem.setArmed(false);
            }
            ++n;
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
    }
}

