/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.AbstractEditorPanel;
import ix.iface.ui.FormModelListener;
import ix.iface.ui.IFormModel;
import ix.iface.ui.IXEditorPanel;
import ix.iface.ui.IXRenderer;
import ix.iface.ui.ListEditorPanel;
import ix.iface.ui.ThingEditorPanel;
import ix.util.Debug;
import ix.util.lisp.LListCollector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class IFormPanel
extends JPanel
implements MouseListener,
FormModelListener {
    protected IFormModel model;
    protected HashMap nameBits = new HashMap();
    protected HashMap displayBits = new HashMap();
    protected HashMap fieldRenderers = new HashMap();
    protected HashSet simpleFields = new HashSet();
    protected List listeners = new LListCollector();
    protected Container parent;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$ix$util$lisp$Symbol;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$reflect$Array;

    public IFormPanel() {
        super(new GridBagLayout());
        this.setRenderers();
    }

    public IFormPanel(IFormModel iFormModel) {
        super(new GridBagLayout());
        this.setModel(iFormModel);
        this.setRenderers();
    }

    public void setModel(IFormModel iFormModel) {
        this.model = iFormModel;
        this.ensurePanelBits(iFormModel);
        this.displayModelData();
        iFormModel.addModelListener(this);
    }

    public IFormModel getModel() {
        return this.model;
    }

    public void setRenderer(String string, IXRenderer iXRenderer) {
        this.fieldRenderers.put(string, iXRenderer);
        IXEditorPanel iXEditorPanel = this.getFieldBit(string);
        if (iXEditorPanel != null) {
            iXEditorPanel.setRenderer(iXRenderer);
        }
    }

    public void setSimpleField(String string) {
        this.simpleFields.add(new String(string));
    }

    public void unsetSimpleField(String string) {
        this.simpleFields.remove(new String(string));
    }

    public boolean isSimpleField(String string) {
        return this.simpleFields.contains(new String(string));
    }

    public void ensurePanelBits(IFormModel iFormModel) {
        if (iFormModel == null) {
            return;
        }
        this.model = iFormModel;
        iFormModel.startUpdate();
        Dimension dimension = this.getSize();
        if (!this.checkNameBits()) {
            this.makeNameBits();
        }
        if (!this.checkDisplayBits()) {
            this.makeDisplayBits();
        }
        this.setSize(dimension);
        iFormModel.ignoreUpdate();
    }

    private boolean checkNameBits() {
        return this.checkBits(this.model.getNameFields(), this.nameBits);
    }

    private boolean checkDisplayBits() {
        return this.checkBits(this.model.getDisplayFields(), this.displayBits);
    }

    private boolean checkBits(List list, HashMap hashMap) {
        if (list == null && hashMap == null) {
            return true;
        }
        if (list == null && hashMap.size() == 0) {
            return true;
        }
        if (list.size() == 0 && hashMap == null) {
            return true;
        }
        if (list == null || hashMap == null) {
            return false;
        }
        if (hashMap.size() != list.size()) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (hashMap.containsKey((String)iterator.next())) continue;
            return false;
        }
        return true;
    }

    private void makeNameBits() {
        IFormPanel.clearBits(this.nameBits);
        List list = this.model.getNameFields();
        if (list.isEmpty()) {
            return;
        }
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ThingEditorPanel thingEditorPanel = new ThingEditorPanel((MouseListener)this, this.model.getFieldName(string), new JTextField());
            this.nameBits.put(string, thingEditorPanel);
            this.addNameBit(string, thingEditorPanel, n);
            ++n;
        }
    }

    private void makeDisplayBits() {
        IFormPanel.clearBits(this.displayBits);
        int n = this.model.getNameFields().size();
        List list = this.model.getDisplayFields();
        if (list.isEmpty()) {
            return;
        }
        int n2 = 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            IXEditorPanel iXEditorPanel = this.makeDisplayBit(string);
            IXRenderer iXRenderer = (IXRenderer)this.fieldRenderers.get(string);
            if (iXRenderer != null) {
                iXEditorPanel.setRenderer(iXRenderer);
            }
            this.displayBits.put(string, iXEditorPanel);
            this.addDisplayBit(string, (JPanel)((Object)iXEditorPanel), n2, n);
            ++n2;
        }
    }

    private void addRenderer(String string, IXEditorPanel iXEditorPanel) {
        IXRenderer iXRenderer = (IXRenderer)this.fieldRenderers.get(string);
        if (iXRenderer != null) {
            iXEditorPanel.setRenderer(iXRenderer);
        }
    }

    protected static void clearBits(HashMap hashMap) {
        Collection collection = hashMap.values();
        if (collection.isEmpty()) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((JComponent)iterator.next()).setVisible(false);
        }
        hashMap.clear();
    }

    private void addNameBit(String string, JComponent jComponent, int n) {
        Insets insets = new Insets(4, 0, 4, 0);
        double d = this.model.getFieldWeight(string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(n, 0, 1, 1, d, 0.0, 11, 2, insets, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
    }

    private void addDisplayBit(String string, JComponent jComponent, int n, int n2) {
        Insets insets = new Insets(4, 0, 4, 0);
        double d = this.model.getFieldWeight(string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, n2, 1, 1.0, d, 17, 1, insets, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
    }

    protected IXEditorPanel makeDisplayBit(String string) {
        AbstractEditorPanel abstractEditorPanel;
        Class clazz;
        String string2 = this.model.getFieldName(string);
        if ((class$java$lang$Number == null ? (class$java$lang$Number = IFormPanel.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz = this.model.getFieldClass(string)) || (class$ix$util$lisp$Symbol == null ? (class$ix$util$lisp$Symbol = IFormPanel.class$("ix.util.lisp.Symbol")) : class$ix$util$lisp$Symbol).isAssignableFrom(clazz) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = IFormPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz)) {
            abstractEditorPanel = new ThingEditorPanel((MouseListener)this, string2, new JTextField());
        } else if (((class$java$util$Collection == null ? (class$java$util$Collection = IFormPanel.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz) || (class$java$lang$reflect$Array == null ? (class$java$lang$reflect$Array = IFormPanel.class$("java.lang.reflect.Array")) : class$java$lang$reflect$Array).isAssignableFrom(clazz)) && !this.isSimpleField(string)) {
            String[] stringArray = new String[]{"Add", "Edit", "Delete"};
            JList jList = new JList();
            jList.setVisibleRowCount(3);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(jList);
            abstractEditorPanel = new ListEditorPanel((MouseListener)this, string2, jScrollPane, stringArray);
        } else {
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(new JTextArea());
            abstractEditorPanel = new ThingEditorPanel((MouseListener)this, string2, jScrollPane);
        }
        abstractEditorPanel.setEnabled(this.model.isEditable(string));
        return abstractEditorPanel;
    }

    public void displayModelData() {
        if (this.model == null) {
            return;
        }
        this.clearFields();
        if (this.model.getObject() == null) {
            return;
        }
        Iterator iterator = this.getAllFields();
        while (iterator.hasNext()) {
            this.displayFieldData((String)iterator.next());
        }
    }

    public void displayFieldData(String string) {
        Object object = this.model.getValue(string);
        if (object == null) {
            return;
        }
        this.setFieldData(string, object);
    }

    public void setFieldData(String string, Object object) {
        IXEditorPanel iXEditorPanel = this.getFieldBit(string);
        if (iXEditorPanel != null) {
            Object object2 = this.renderValue(string, object);
            iXEditorPanel.setData(object2);
        }
    }

    public void clearFields() {
        Iterator iterator = this.getAllFields();
        while (iterator.hasNext()) {
            this.clearField((String)iterator.next());
        }
    }

    public void clearField(String string) {
        IXEditorPanel iXEditorPanel = this.getFieldBit(string);
        if (iXEditorPanel == null) {
            Debug.noteln("Cannot find panel for field " + string);
            return;
        }
        iXEditorPanel.removeData();
    }

    protected Object renderValue(String string, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof AbstractCollection) {
            return ((AbstractCollection)object).toArray();
        }
        return object;
    }

    protected Object deRenderValue(String string, Object object) {
        Class<?> clazz;
        if (object == null) {
            return null;
        }
        Class clazz2 = this.model.getFieldClass(string);
        if (clazz2.isAssignableFrom(clazz = object.getClass())) {
            return object;
        }
        if (clazz == (class$java$lang$reflect$Array == null ? (class$java$lang$reflect$Array = IFormPanel.class$("java.lang.reflect.Array")) : class$java$lang$reflect$Array) && (class$java$util$Collection == null ? (class$java$util$Collection = IFormPanel.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz2)) {
            try {
                Collection collection = (Collection)clazz2.newInstance();
                collection.addAll(Arrays.asList((Object[])object));
                return collection;
            }
            catch (Exception exception) {
                Debug.noteln("deRenderValue: caught problem with field " + string);
                Debug.noteln("Data is of type " + object.getClass());
                Debug.noteException(exception);
                return object;
            }
        }
        return object;
    }

    protected void setRenderers() {
    }

    public IXEditorPanel getFieldBit(String string) {
        IXEditorPanel iXEditorPanel = (IXEditorPanel)this.nameBits.get(string);
        if (iXEditorPanel == null) {
            iXEditorPanel = (IXEditorPanel)this.displayBits.get(string);
        }
        return iXEditorPanel;
    }

    public Object getFieldData(String string) {
        IXEditorPanel iXEditorPanel = this.getFieldBit(string);
        if (iXEditorPanel == null) {
            return null;
        }
        return iXEditorPanel.getData();
    }

    public void saveFieldData(String string) {
        Object object = this.getFieldData(string);
        Object object2 = this.deRenderValue(string, object);
        this.model.setValue(string, object2);
    }

    public void saveToObject() {
        Object object = this.model.getObject();
        LListCollector lListCollector = new LListCollector(this.model.getNameFields());
        lListCollector.addAll(this.model.getDisplayFields());
        Iterator iterator = lListCollector.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object2 = this.getFieldData(string);
            Object object3 = this.deRenderValue(string, object2);
            this.model.setValue(string, object3);
        }
    }

    public void saveToObject(Object object) {
        LListCollector lListCollector = new LListCollector(this.model.getNameFields());
        lListCollector.addAll(this.model.getDisplayFields());
        Iterator iterator = lListCollector.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object2 = this.getFieldData(string);
            Object object3 = this.deRenderValue(string, object2);
            this.model.setValue(object, string, object3);
        }
    }

    private Iterator getAllFields() {
        LListCollector lListCollector = new LListCollector(this.model.getNameFields());
        lListCollector.addAll(this.model.getDisplayFields());
        return lListCollector.iterator();
    }

    public void clear() {
        this.model.clearData();
    }

    public void formModelChanged(String string) {
        if (string.equals("object")) {
            this.displayModelData();
        } else if (string.equals("fieldNames")) {
            List list = this.model.getNameFields();
            this.updateNames(list, this.nameBits);
            list = this.model.getDisplayFields();
            this.updateNames(list, this.displayBits);
        } else {
            this.model.startUpdate();
            this.setModel(this.model);
            this.model.ignoreUpdate();
        }
    }

    public void updateNames(List list, HashMap hashMap) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.model.getFieldName(string);
            if (string2 == null) continue;
            IXEditorPanel iXEditorPanel = (IXEditorPanel)hashMap.get(string);
            if (iXEditorPanel == null) {
                Debug.noteln("Cannot find bit for " + string2);
                continue;
            }
            iXEditorPanel.setLabel(string2);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            MouseListener mouseListener = (MouseListener)iterator.next();
            mouseListener.mouseClicked(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            MouseListener mouseListener = (MouseListener)iterator.next();
            mouseListener.mouseEntered(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            MouseListener mouseListener = (MouseListener)iterator.next();
            mouseListener.mouseExited(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            MouseListener mouseListener = (MouseListener)iterator.next();
            mouseListener.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            MouseListener mouseListener = (MouseListener)iterator.next();
            mouseListener.mouseReleased(mouseEvent);
        }
    }

    public void addFormMouseListener(MouseListener mouseListener) {
        this.listeners.add(mouseListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

