/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpFrame
extends JFrame
implements ActionListener,
HyperlinkListener {
    private JEditorPane htmlPane = new JEditorPane();
    private URL original;

    private HelpFrame() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(550, 650);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setActionCommand("close");
        jMenuItem.addActionListener(this);
        JMenuItem jMenuItem2 = new JMenuItem("Back to original help page");
        jMenuItem2.setActionCommand("back");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        jMenu.add(jMenuItem);
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.htmlPane);
        this.getContentPane().add("Center", jScrollPane);
        this.setTitle("Help");
    }

    public HelpFrame(URL uRL) {
        this();
        this.displayURL(uRL);
        this.original = uRL;
    }

    public HelpFrame(String string) {
        this();
        try {
            URL uRL;
            this.original = uRL = UIUtil.resourceURL(string);
            this.displayURL(uRL);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    public boolean displayURL(URL uRL) {
        Debug.noteln("Displaying url", uRL.toString());
        try {
            this.htmlPane.setPage(uRL);
            return true;
        }
        catch (IOException iOException) {
            if (uRL != null && !uRL.getProtocol().equals("http")) {
                UIUtil.warning(this, "Cannot deal with non-http links in URL: " + uRL.toString());
            } else {
                UIUtil.warning(this, "Attempted to read a bad URL: " + uRL.toString());
            }
            return false;
        }
    }

    private void displayOriginal() {
        if (this.original != null) {
            this.displayURL(this.original);
        } else {
            UIUtil.warning(this, "No original help page found");
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL uRL = this.htmlPane.getPage();
            if (!this.displayURL(hyperlinkEvent.getURL())) {
                Debug.noteln("The bad link's description is", hyperlinkEvent.getDescription());
                this.displayURL(uRL);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = ((AbstractButton)object).getActionCommand();
        Debug.noteln("HelpFrame: action command is", string);
        if (string == "close") {
            ((Component)this).setVisible(false);
        } else if (string == "back") {
            this.displayOriginal();
        } else {
            String string2 = ((AbstractButton)object).getText();
            if (string2 == "" || string2 == null) {
                string2 = string;
            }
            UIUtil.notImplemented(this, string2);
        }
    }
}

