/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.AbstractIFormModel;
import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import ix.util.lisp.LListCollector;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class GenericIFormModel
extends AbstractIFormModel {
    public GenericIFormModel(Class clazz) {
        super(clazz);
    }

    public GenericIFormModel(Object object) {
        super(object);
    }

    public void setFields() {
        if (this.baseObjectClass == null) {
            Debug.noteln("Cannot set fields for a null base object class.");
            return;
        }
        this.nameFields = this.deriveNameFields();
        this.displayFields = this.deriveDisplayFields();
        LListCollector lListCollector = new LListCollector(this.nameFields);
        lListCollector.addAll(this.displayFields);
        this.deriveNames(lListCollector);
        this.deriveClasses(lListCollector);
    }

    protected void deriveNames(List list) {
        this.fieldNames.clear();
        if (list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.fieldNames.put(string, this.deriveName(string));
        }
    }

    protected String deriveName(String string) {
        return UIUtil.toCapitalised(string);
    }

    protected void deriveClasses(List list) {
        this.fieldClasses.clear();
        if (list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Class clazz = this.deriveClass(string);
            this.fieldClasses.put(string, clazz);
        }
    }

    protected Class deriveClass(String string) {
        try {
            Field field = this.stringToField(string);
            return field.getType();
        }
        catch (Exception exception) {
            Debug.note("Working on class " + this.getObjectClass().getName());
            Debug.noteln("Fields are: " + UIUtil.fieldsToNames(this.getObjectClass().getFields()));
            Debug.noteln(" Problem deriving class for field " + string);
            Debug.noteException(exception);
            return null;
        }
    }

    protected List deriveNameFields() {
        Class clazz = this.getObjectClass();
        if (clazz == null) {
            Debug.noteln("FormModel: base object class not known.");
            return null;
        }
        List<String> list = new LListCollector();
        list = (List)AbstractIFormModel.addIfField(list, clazz, "name");
        if ((list = (List)AbstractIFormModel.addIfField(list, clazz, "Name")).isEmpty()) {
            Field[] fieldArray = clazz.getFields();
            int n = 0;
            while (n < fieldArray.length) {
                String string = fieldArray[n].getName().toUpperCase();
                if (string.indexOf("NAME") != -1) {
                    list.add(fieldArray[n].getName());
                }
                ++n;
            }
        }
        list = (List)AbstractIFormModel.addIfField(list, clazz, "id");
        list = (List)AbstractIFormModel.addIfField(list, clazz, "Id");
        list = (List)AbstractIFormModel.addIfField(list, clazz, "ID");
        return list;
    }

    protected List deriveDisplayFields() {
        Class clazz = this.getObjectClass();
        if (clazz == null) {
            Debug.noteln("FormModel: base object class not known.");
            return null;
        }
        LListCollector lListCollector = new LListCollector(Arrays.asList(clazz.getFields()));
        LListCollector lListCollector2 = new LListCollector();
        Iterator iterator = lListCollector.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!this.useField(field)) continue;
            lListCollector2.add(field.getName());
        }
        return lListCollector2;
    }

    protected boolean useField(Field field) {
        int n = field.getModifiers();
        return !Modifier.isStatic(n) && !Modifier.isPrivate(n) && !Modifier.isProtected(n) && !this.nameFields.contains(field.getName());
    }
}

