/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.FormModelListener;
import ix.iface.ui.IFormModel;
import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractIFormModel
implements IFormModel {
    List nameFields = Lisp.NIL;
    List displayFields = Lisp.NIL;
    HashMap fieldNames = new HashMap();
    HashMap fieldClasses = new HashMap();
    protected Object baseObject;
    Class baseObjectClass;
    HashSet listeners = new HashSet();
    boolean isUpdating = false;

    public AbstractIFormModel(Class clazz) {
        this.baseObjectClass = clazz;
        this.setFields();
    }

    public AbstractIFormModel(Object object) {
        this(object.getClass());
        this.baseObject = object;
    }

    public void clearData() {
        this.setObject(null);
    }

    public String getFieldName(String string) {
        return (String)this.fieldNames.get(string);
    }

    public Class getFieldClass(String string) {
        return (Class)this.fieldClasses.get(string);
    }

    public double getFieldWeight(String string) {
        return 1.0;
    }

    public void setNameFields(List list) {
        this.nameFields = list;
        this.fieldNames.clear();
        this.fieldClasses.clear();
        this.deriveNames();
        this.deriveClasses();
        this.fireModelChanged("nameFields");
    }

    public void setNameFields(String[] stringArray) {
        LListCollector lListCollector = new LListCollector(Arrays.asList(stringArray));
        this.setNameFields(lListCollector);
    }

    public void setDisplayFields(List list) {
        this.displayFields = list;
        this.fieldNames.clear();
        this.fieldClasses.clear();
        this.deriveNames();
        this.deriveClasses();
        this.fireModelChanged("displayFields");
    }

    public void setDisplayFields(String[] stringArray) {
        LListCollector lListCollector = new LListCollector(Arrays.asList(stringArray));
        this.setDisplayFields(lListCollector);
    }

    public List getNameFields() {
        return this.nameFields;
    }

    public List getNameNames() {
        return this.getFieldNames(this.nameFields);
    }

    public List getNameClasses() {
        return this.getFieldClasses(this.nameFields);
    }

    public List getDisplayFields() {
        return this.displayFields;
    }

    public List getDisplayNames() {
        return this.getFieldNames(this.displayFields);
    }

    public List getDisplayClasses() {
        return this.getFieldClasses(this.displayFields);
    }

    public void setObject(Object object) {
        boolean bl = false;
        if (object != null && !object.getClass().equals(this.baseObjectClass)) {
            this.setObjectClass(object.getClass());
            bl = true;
        }
        if (!(object == null && this.baseObject == null || object != null && object.equals(this.baseObject))) {
            bl = true;
        }
        this.baseObject = object;
        if (bl) {
            this.fireModelChanged("object");
        } else if (this.baseObject != null) {
            this.fireModelChanged("allFields");
        }
    }

    public Object getObject() {
        return this.baseObject;
    }

    public void setObjectClass(Class clazz) {
        if (this.baseObjectClass.equals(clazz)) {
            return;
        }
        if (this.baseObjectClass != null) {
            this.clearFields();
        }
        this.baseObjectClass = clazz;
        this.setFields();
    }

    public Class getObjectClass() {
        if (this.baseObjectClass == null && this.baseObject != null) {
            this.baseObjectClass = this.baseObject.getClass();
        }
        return this.baseObjectClass;
    }

    public Object getValue(String string) {
        return UIUtil.getObjectFieldValue(this.baseObject, string);
    }

    public void setValue(String string, Object object) {
        this.setValue(this.baseObject, string, object);
        this.fireModelChanged("Field " + string);
    }

    public void setValue(Object object, String string, Object object2) {
        Class clazz = this.getFieldClass(string);
        UIUtil.setObjectFieldValue(object, string, clazz, object2);
    }

    public Field stringToField(String string) throws NoSuchFieldException, IllegalAccessException {
        Class clazz = this.getObjectClass();
        if (clazz == null) {
            return null;
        }
        return clazz.getField(string);
    }

    public Field stringToField(Class clazz, String string) throws NoSuchFieldException, IllegalAccessException {
        if (clazz == null) {
            return null;
        }
        return clazz.getField(string);
    }

    public void setFields() {
        if (this.baseObjectClass == null) {
            Debug.noteln("Cannot set fields for a null base object class.");
            return;
        }
        this.isUpdating = true;
        if (this.nameFields.isEmpty()) {
            this.nameFields = this.deriveNameFields();
        }
        if (this.displayFields.isEmpty()) {
            this.displayFields = this.deriveDisplayFields();
        }
        LListCollector lListCollector = new LListCollector(this.nameFields);
        lListCollector.addAll(this.displayFields);
        if (this.fieldNames.isEmpty()) {
            this.deriveNames(lListCollector);
        }
        if (this.fieldClasses.isEmpty()) {
            this.deriveClasses(lListCollector);
        }
        this.isUpdating = false;
        this.fireModelChanged("allFields");
    }

    private void clearFields() {
        this.nameFields = Lisp.NIL;
        this.displayFields = Lisp.NIL;
        this.fieldNames.clear();
        this.fieldClasses.clear();
        this.baseObject = null;
    }

    protected List lookupFieldNames(List list) {
        return AbstractIFormModel.lookupFieldMaps(list, this.fieldNames);
    }

    protected List lookupFieldClasses(List list) {
        return AbstractIFormModel.lookupFieldMaps(list, this.fieldClasses);
    }

    private static List lookupFieldMaps(List list, HashMap hashMap) {
        if (list.isEmpty()) {
            return Lisp.NIL;
        }
        LListCollector lListCollector = new LListCollector();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            lListCollector.addElement(hashMap.get(string));
        }
        return lListCollector;
    }

    private List getFieldNames(List list) {
        return this.lookupFieldNames(list);
    }

    private List getFieldClasses(List list) {
        return this.lookupFieldClasses(list);
    }

    protected void deriveNames() {
        LListCollector lListCollector = new LListCollector(this.nameFields);
        lListCollector.addAll(this.displayFields);
        this.deriveNames(lListCollector);
    }

    protected void deriveClasses() {
        LListCollector lListCollector = new LListCollector(this.nameFields);
        lListCollector.addAll(this.displayFields);
        this.deriveClasses(lListCollector);
    }

    protected abstract void deriveNames(List var1);

    protected abstract void deriveClasses(List var1);

    protected abstract List deriveNameFields();

    protected abstract List deriveDisplayFields();

    public static Collection addIfField(Collection collection, Class clazz, String string) {
        try {
            Field field = clazz.getField(string);
            collection.add(string);
            return collection;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return collection;
        }
    }

    public boolean isEditable(String string) {
        return true;
    }

    public void startUpdate() {
        this.isUpdating = true;
    }

    public void endUpdate() {
        this.isUpdating = false;
        this.fireModelChanged("allFields");
    }

    public void ignoreUpdate() {
        this.isUpdating = false;
    }

    public void fireModelChanged(String string) {
        if (this.isUpdating) {
            return;
        }
        if (this.listeners.isEmpty()) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            FormModelListener formModelListener = (FormModelListener)iterator.next();
            formModelListener.formModelChanged(string);
        }
    }

    public void addModelListener(FormModelListener formModelListener) {
        this.listeners.add(formModelListener);
    }
}

