/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.domain;

import ix.icore.domain.Domain;
import ix.iface.domain.DomainParser;
import ix.iface.domain.SyntaxException;
import ix.util.Debug;
import ix.util.xml.XML;
import java.io.File;
import java.io.FileNotFoundException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XMLTF_Parser
extends DomainParser {
    String filename;
    protected String SAXDriverClass = "org.apache.xerces.parsers.SAXParser";

    public XMLTF_Parser(String string) throws FileNotFoundException {
        this.filename = string;
    }

    public XMLTF_Parser(File file) throws FileNotFoundException {
        this(file.getPath());
    }

    public Domain readDomain() {
        return this.readDomain(new Domain());
    }

    public Domain readDomain(Domain domain) {
        return this.readDomainJDOM(domain);
    }

    public Domain readDomainJDOM(Domain domain) {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder(this.SAXDriverClass);
            Document document = sAXBuilder.build(new File(this.filename));
            this.fillInDomain(domain, document);
        }
        catch (JDOMException jDOMException) {
            Debug.noteException(jDOMException, false);
            throw new SyntaxException(jDOMException.toString());
        }
        catch (Exception exception) {
            Debug.noteException(exception, false);
            throw new SyntaxException(exception.toString());
        }
        domain.checkConsistency();
        return domain;
    }

    protected void fillInDomain(Domain domain, Document document) {
        Domain domain2 = (Domain)XML.objectFromDocument(document);
        domain.takeFrom(domain2);
    }
}

