/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.domain;

import ix.icore.Issue;
import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.domain.VariableDeclaration;
import ix.iface.domain.DomainWriter;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

public class LTF_Writer
extends DomainWriter {
    File domainName;
    Writer out;

    public LTF_Writer(File file) {
        this.domainName = file;
    }

    public void writeDomain(Domain domain) throws IOException {
        this.out = new BufferedWriter(new FileWriter(this.domainName));
        this.outDomain(domain);
        this.out.flush();
    }

    void outDomain(Domain domain) {
        Iterator iterator = domain.getRefinements().iterator();
        while (iterator.hasNext()) {
            Refinement refinement = (Refinement)iterator.next();
            this.outRefinement(refinement);
            if (!iterator.hasNext()) continue;
            this.outln("");
        }
    }

    void outRefinement(Refinement refinement) {
        this.outRefinementHeader(refinement);
        List list = refinement.getVariableDeclarations();
        List list2 = refinement.getNodes();
        List list3 = refinement.getOrderings();
        List list4 = refinement.getConstraints();
        List list5 = refinement.getIssues();
        String string = refinement.getComments();
        if (list != null) {
            this.outVarDcls(list);
        }
        if (list2 != null) {
            this.outNodes(list2);
        }
        if (list3 != null) {
            this.outOrderings(list3);
        }
        if (list4 != null) {
            this.outConstraints(list4);
        }
        if (list5 != null) {
            this.outIssues(list5);
        }
        if (string != null && !string.equals("")) {
            this.outComments(string);
        }
        this.outln(")");
    }

    void outRefinementHeader(Refinement refinement) {
        this.out("(refinement ");
        this.out(refinement.getName());
        this.out(" ");
        this.out(refinement.getPattern());
    }

    void outVarDcls(List list) {
        this.out(2, "(variables");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VariableDeclaration variableDeclaration = (VariableDeclaration)iterator.next();
            this.out(" ");
            this.out(variableDeclaration.getName());
        }
        this.out(")");
    }

    void outNodes(List list) {
        this.out(2, "(nodes");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NodeSpec nodeSpec = (NodeSpec)iterator.next();
            this.outNode(nodeSpec);
        }
        this.out(")");
    }

    void outNode(NodeSpec nodeSpec) {
        this.out(4, "(");
        this.out(nodeSpec.getId());
        this.out(" ");
        this.out(nodeSpec.getPattern());
        this.out(")");
    }

    void outOrderings(List list) {
        this.out(2, "(orderings");
        this.out(4, "");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Ordering ordering = (Ordering)iterator.next();
            this.outOrdering(ordering);
            if (!iterator.hasNext()) continue;
            this.out(" ");
        }
        this.out(")");
    }

    void outOrdering(Ordering ordering) {
        NodeEndRef nodeEndRef = ordering.getFrom();
        NodeEndRef nodeEndRef2 = ordering.getTo();
        this.out("(");
        this.outNodeEndRef(nodeEndRef);
        this.out(" ");
        this.outNodeEndRef(nodeEndRef2);
        this.out(")");
    }

    void outNodeEndRef(NodeEndRef nodeEndRef) {
        this.out(nodeEndRef.getNode());
    }

    void outConstraints(List list) {
        this.out(2, "(constraints");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            this.outConstraint(constraint);
        }
        this.out(")");
    }

    void outConstraint(Constraint constraint) {
        this.out(4, "(");
        this.out(constraint.getType());
        this.out(" ");
        this.out(constraint.getRelation());
        Iterator iterator = constraint.getParameters().iterator();
        while (iterator.hasNext()) {
            this.out(" ");
            this.outConstraintParameter(iterator.next());
        }
        this.out(")");
    }

    void outConstraintParameter(Object object) {
        if (object instanceof PatternAssignment) {
            this.outPV((PatternAssignment)object);
        } else {
            Debug.assert(false, "Unexpected constraint parameter", object);
        }
    }

    void outPV(PatternAssignment patternAssignment) {
        this.out(patternAssignment.getPattern());
        this.out(" = ");
        this.out(patternAssignment.getValue());
    }

    void outIssues(List list) {
        this.out(2, "(issues");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Issue issue = (Issue)iterator.next();
            this.outIssue(issue);
        }
        this.out(")");
    }

    void outIssue(Issue issue) {
        this.out(4, Lisp.list(Symbol.intern("issue"), issue.getPattern()));
    }

    void outComments(String string) {
        List list = Strings.breakIntoLines(string);
        this.out(2, ";(comments");
        this.out(2, ";  \"");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            this.out(string2);
            if (!iterator.hasNext()) continue;
            this.out(2, ";");
        }
        this.out("\"");
        this.out(")");
        this.outln("");
    }

    void out(String string) {
        try {
            this.out.write(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    void out(Object object) {
        this.out(object.toString());
    }

    void out(int n, String string) {
        this.outln("");
        this.out(Strings.repeat(n, " "));
        this.out(string);
    }

    void out(int n, Object object) {
        this.out(n, object.toString());
    }

    void outln(String string) {
        this.out(string);
        this.out("\n");
    }
}

