/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.domain;

import ix.icore.Issue;
import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.domain.End;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.domain.VariableDeclaration;
import ix.iface.domain.DomainParser;
import ix.iface.domain.LTF_Symbols;
import ix.iface.domain.SyntaxException;
import ix.util.Debug;
import ix.util.Name;
import ix.util.lisp.Cons;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.LispFileReader;
import ix.util.lisp.LispReadException;
import ix.util.lisp.LispReader;
import ix.util.lisp.Symbol;
import ix.util.match.MatchCase;
import ix.util.match.MatchEnv;
import ix.util.match.MatchTable;
import ix.util.match.SimpleMatcher;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;

public class LTF_Parser
extends DomainParser
implements LTF_Symbols {
    protected String filename;
    protected LispReader lin;
    protected Object lastRead = "Start of file";
    protected MatchTable parsers = new MatchTable();

    public LTF_Parser(String string) throws FileNotFoundException {
        this.filename = string;
        this.lin = new LispFileReader(string);
        this.addConstraintParsers();
    }

    public LTF_Parser(File file) throws FileNotFoundException {
        this(file.getPath());
    }

    public LTF_Parser() {
        this.addConstraintParsers();
    }

    public Domain readDomain() {
        return this.readDomain(new Domain());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Domain readDomain(Domain domain) {
        Debug.noteln("Reading definitions from", this.filename);
        try {
            Object object;
            while ((object = this.lin.readObject()) != Lisp.EOF) {
                if (!(object instanceof LList)) {
                    this.syntaxError("Found " + object + " when expecting a refinement definition");
                    continue;
                }
                LList lList = (LList)object;
                this.lastRead = object;
                Symbol symbol = (Symbol)lList.elementAt(0);
                if (symbol == LTF_Symbols.S_REFINEMENT) {
                    Refinement refinement = null;
                    try {
                        refinement = this.makeRefinement(lList);
                    }
                    catch (SyntaxException syntaxException) {
                        Debug.noteln("Rethrowing syntax exception.");
                        throw syntaxException;
                    }
                    catch (Exception exception) {
                        Debug.noteln("Problem with " + lList);
                        Debug.noteException(exception);
                        this.syntaxError(exception.toString());
                        continue;
                    }
                    domain.addRefinement(refinement);
                    continue;
                }
                this.syntaxError("Illegal definition type " + symbol);
            }
        }
        catch (LispReadException lispReadException) {
            Debug.noteException(lispReadException, false);
            this.syntaxError(lispReadException.toString());
        }
        domain.checkConsistency();
        return domain;
    }

    protected void syntaxError(String string) {
        throw new SyntaxException(string + " in or after " + this.lastRead);
    }

    public Refinement makeRefinement(LList lList) {
        Debug.assert(lList.get(0) == LTF_Symbols.S_REFINEMENT);
        Refinement refinement = new Refinement();
        refinement.setName(lList.get(1).toString());
        refinement.setPattern((LList)lList.get(2));
        LList lList2 = lList.drop(3);
        while (!lList2.isEmpty()) {
            Cons cons = (Cons)lList2.car();
            Symbol symbol = (Symbol)cons.car();
            LList lList3 = cons.cdr();
            if (symbol == LTF_Symbols.S_VARIABLES) {
                refinement.setVariableDeclarations(this.makeVarDcls(lList3));
            } else if (symbol == LTF_Symbols.S_NODES) {
                refinement.setNodes(this.makeNodes(lList3));
            } else if (symbol == LTF_Symbols.S_ORDERINGS) {
                refinement.setOrderings(this.makeOrderings(lList3));
            } else if (symbol == LTF_Symbols.S_CONSTRAINTS) {
                refinement.setConstraints(this.makeConstraints(lList3));
            } else if (symbol == LTF_Symbols.S_ISSUES) {
                refinement.setIssues(this.makeIssues(lList3));
            } else {
                this.syntaxError("Invalid clause " + cons);
            }
            lList2 = lList2.cdr();
        }
        return refinement;
    }

    public LList makeVarDcls(LList lList) {
        LListCollector lListCollector = new LListCollector();
        Iterator iterator = lList.iterator();
        while (iterator.hasNext()) {
            ItemVar itemVar = (ItemVar)iterator.next();
            lListCollector.add(new VariableDeclaration(itemVar));
        }
        return lListCollector.contents();
    }

    public LList makeNodes(LList lList) {
        LListCollector lListCollector = new LListCollector();
        Iterator iterator = lList.iterator();
        while (iterator.hasNext()) {
            Cons cons = (Cons)iterator.next();
            Name name = Name.valueOf(cons.get(0));
            LList lList2 = (LList)cons.get(1);
            lListCollector.add(new NodeSpec(name, lList2));
        }
        return lListCollector.contents();
    }

    public LList makeOrderings(LList lList) {
        LListCollector lListCollector = new LListCollector();
        LList lList2 = LTF_Parser.expandAllOrderings(lList);
        while (!lList2.isEmpty()) {
            Cons cons = (Cons)lList2.car();
            Name name = Name.valueOf(cons.get(0));
            Name name2 = Name.valueOf(cons.get(1));
            lListCollector.add(new Ordering(new NodeEndRef(End.END, name), new NodeEndRef(End.BEGIN, name2)));
            lList2 = lList2.cdr();
        }
        return lListCollector.contents();
    }

    public LList makeConstraints(LList lList) {
        LListCollector lListCollector = new LListCollector();
        Iterator iterator = lList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Constraint constraint = (Constraint)this.parsers.match(e);
            if (constraint == null) {
                this.syntaxError("Invalid constraint " + e);
                continue;
            }
            lListCollector.add(constraint);
        }
        return lListCollector.contents();
    }

    public LList makeIssues(LList lList) {
        LListCollector lListCollector = new LListCollector();
        Iterator iterator = lList.iterator();
        while (iterator.hasNext()) {
            LList lList2 = (LList)iterator.next();
            if (lList2.get(0) != LTF_Symbols.S_ISSUE) {
                this.syntaxError("Invalid issue syntax in " + lList2);
                continue;
            }
            LList lList3 = (LList)lList2.get(1);
            lListCollector.add(new Issue(lList3));
        }
        return lListCollector.contents();
    }

    public static LList expandAllOrderings(LList lList) {
        LListCollector lListCollector = new LListCollector();
        LList lList2 = lList;
        while (lList2 != Lisp.NIL) {
            lListCollector.concLList(LTF_Parser.expandOrdering((LList)lList2.car()));
            lList2 = lList2.cdr();
        }
        return lListCollector.contents();
    }

    public static LList expandOrdering(LList lList) {
        LListCollector lListCollector = new LListCollector();
        LList lList2 = lList;
        while (lList2 != Lisp.NIL) {
            Object object = lList2.car();
            Object object2 = lList2.cdr().car();
            lListCollector.concLList(LTF_Parser.expandOrderPair(object, object2));
            lList2 = lList2.cdr();
        }
        return lListCollector.contents();
    }

    static LList expandOrderPair(Object object, Object object2) {
        LListCollector lListCollector = new LListCollector();
        LList lList = LTF_Parser.ensureList(object);
        while (lList != Lisp.NIL) {
            LList lList2 = LTF_Parser.ensureList(object2);
            while (lList2 != Lisp.NIL) {
                lListCollector.addElement(Lisp.list(lList.car(), lList2.car()));
                lList2 = lList2.cdr();
            }
            lList = lList.cdr();
        }
        return lListCollector.contents();
    }

    static LList ensureList(Object object) {
        return object instanceof LList ? (LList)object : Lisp.list(object);
    }

    public Constraint parseConstraint(Object object) {
        return (Constraint)this.parsers.match(object);
    }

    protected void addConstraintParsers() {
        this.parsers.addCase(new ConstraintParser("(world-state condition ?pattern = ?value)"){

            public Constraint makeConstraint(LList lList, MatchEnv matchEnv) {
                LList lList2 = (LList)matchEnv.get(LTF_Symbols.Q_PATTERN);
                Object v = matchEnv.get(LTF_Symbols.Q_VALUE);
                return new Constraint((Symbol)lList.get(0), (Symbol)lList.get(1), Lisp.list(new PatternAssignment(lList2, v)));
            }
        });
        this.parsers.addCase(new ConstraintParser("(world-state effect ?pattern = ?value)"){

            public Constraint makeConstraint(LList lList, MatchEnv matchEnv) {
                LList lList2 = (LList)matchEnv.get(LTF_Symbols.Q_PATTERN);
                Object v = matchEnv.get(LTF_Symbols.Q_VALUE);
                return new Constraint((Symbol)lList.get(0), (Symbol)lList.get(1), Lisp.list(new PatternAssignment(lList2, v)));
            }
        });
    }

    protected static abstract class ConstraintParser
    extends MatchCase {
        ConstraintParser(String string) {
            this.pattern = Lisp.readFromString(string);
        }

        public Object tryMatch(Object object) {
            Debug.noteln("Matching against", this.pattern);
            return SimpleMatcher.match(this.pattern, object);
        }

        public Object ifSelected(Object object, Object object2) {
            return this.makeConstraint((LList)object, (MatchEnv)object2);
        }

        public abstract Constraint makeConstraint(LList var1, MatchEnv var2);
    }
}

