/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.domain;

import ix.icore.domain.Domain;
import ix.iface.domain.DomainFileFilter;
import ix.iface.domain.DomainParser;
import ix.iface.domain.LTF_Writer;
import ix.iface.domain.XMLTF_Writer;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.Util;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public abstract class DomainWriter {
    public abstract void writeDomain(Domain var1) throws IOException;

    public static DomainWriter makeWriter(String string) throws IOException {
        return DomainWriter.makeWriter(new File(string));
    }

    public static DomainWriter makeWriter(File file) throws IOException {
        Object object;
        if (file.getParentFile() == null) {
            object = DomainParser.getLibraryDirectory();
            Debug.noteln("Resolving " + file + " against " + object);
            file = new File((File)object, file.getPath());
        }
        if (((String)(object = file.getName())).endsWith(".xml")) {
            return new XMLTF_Writer(file);
        }
        if (((String)object).endsWith(".lsp")) {
            return new LTF_Writer(file);
        }
        throw new IOException("File " + file.getName() + " does not have type .xml");
    }

    public static File saveDomain(Component component, Domain domain) {
        File file;
        File file2;
        File file3 = DomainParser.getLibraryDirectory();
        do {
            if ((file = DomainWriter.chooseFileToWrite(component, file3)) != null) continue;
            return null;
        } while ((file2 = DomainWriter.saveDomain(component, domain, file)) == null);
        return file2;
    }

    public static File saveDomain(Component component, Domain domain, File file) {
        if (domain.getRefinements() == null || domain.getRefinements().isEmpty()) {
            switch (JOptionPane.showConfirmDialog(component, new String[]{"The domain does not contain any refinements.", "Are you sure you want to save it?"}, "Confirm", 0)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
            }
        }
        if (file.exists()) {
            switch (JOptionPane.showConfirmDialog(component, "Overwrite " + Util.quote(file.getPath()), "Confirm", 0)) {
                case 0: {
                    DomainWriter.renameToBackup(file);
                    break;
                }
                case 1: {
                    return null;
                }
            }
        }
        Debug.noteln("Writing domain to", file);
        try {
            DomainWriter.makeWriter(file).writeDomain(domain);
            return file;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(component, new Object[]{"Problem saving " + Util.quote(file.getPath()), iOException.getMessage()}, "Trouble saving domain", 0);
            return null;
        }
    }

    private static File chooseFileToWrite(Component component, File file) {
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setFileFilter(new DomainFileFilter());
        int n = jFileChooser.showSaveDialog(component);
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public static void renameToBackup(File file) {
        Debug.assert(file.exists(), "No file", file);
        String string = file.getName();
        String[] stringArray = Strings.breakAtLast(".", string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = string2 + ".bak";
        File file2 = new File(file.getParentFile(), string4);
        if (file2.exists()) {
            Debug.noteln("Deleting existing backup", file2);
            file2.delete();
        }
        Debug.noteln("Renameing " + file + " to " + file2);
        file.renameTo(file2);
    }
}

