/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.domain;

import ix.icore.domain.Domain;
import ix.iface.domain.DomainFileFilter;
import ix.iface.domain.LTF_Parser;
import ix.iface.domain.SyntaxException;
import ix.iface.domain.XMLTF_Parser;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Util;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public abstract class DomainParser {
    public abstract Domain readDomain();

    public abstract Domain readDomain(Domain var1);

    public static File getLibraryDirectory() {
        return new File(Parameters.getParameter("domain-library", "domain-library"));
    }

    public static DomainParser makeParser(String string) throws FileNotFoundException {
        return DomainParser.makeParser(new File(string));
    }

    public static DomainParser makeParser(File file) throws FileNotFoundException {
        Object object;
        if (file.getParentFile() == null) {
            object = DomainParser.getLibraryDirectory();
            Debug.noteln("Resolving " + file + " against " + object);
            file = new File((File)object, file.getPath());
        }
        if (((String)(object = file.getName())).endsWith(".xml")) {
            return new XMLTF_Parser(file);
        }
        if (((String)object).endsWith(".lsp")) {
            return new LTF_Parser(file);
        }
        throw new IllegalArgumentException("Do not know how to parse " + file);
    }

    public static File loadDomain(Component component, Domain domain) {
        File file;
        File file2;
        File file3 = DomainParser.getLibraryDirectory();
        do {
            if ((file = DomainParser.chooseDomain(component, file3)) != null) continue;
            return null;
        } while ((file2 = DomainParser.loadDomain(component, domain, file)) == null);
        return file2;
    }

    private static File loadDomain(Component component, Domain domain, File file) {
        try {
            Domain domain2 = new Domain();
            DomainParser.makeParser(file).readDomain(domain2);
            if (domain2.getName() != null) {
                Debug.noteln("Domain has name", domain2.getName());
            }
            domain.takeFrom(domain2);
            return file;
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(component, "Can't find file " + Util.quote(file.getPath()), "File not found", 0);
            return null;
        }
        catch (SyntaxException syntaxException) {
            JOptionPane.showMessageDialog(component, new Object[]{"Exception while parsing " + Util.quote(file.getPath()), syntaxException.getMessage()}, "Syntax Exception", 0);
            return null;
        }
        catch (Exception exception) {
            Debug.noteException(exception, false);
            JOptionPane.showMessageDialog(component, exception.toString(), "Exception", 0);
            return null;
        }
    }

    private static File chooseDomain(Component component, File file) {
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setFileFilter(new DomainFileFilter());
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }
}

