/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.process.state;

import ix.icore.Variable;
import ix.icore.process.ProcessModelManager;
import ix.icore.process.state.PlanVariable;
import ix.icore.process.state.PlanVariableDeclaration;
import ix.ip2.Ip2ModelManager;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.Util;
import ix.util.xml.XML;
import ix.util.xml.XMLLoader;
import ix.util.xml.XMLTranslator;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Document;

public class PlanLoader
extends XMLLoader {
    Ip2ModelManager processModel;
    Map varMap = new HashMap();

    public PlanLoader(Component component, ProcessModelManager processModelManager) {
        super(component);
        this.xmlt = (XMLTranslator)Util.makeInstance(XML.defaultTranslator.getClass());
        this.xmlt.setOmitImplAttributes(true);
        this.xmlt.setPostfilter(this.makePostfilter());
        this.processModel = (Ip2ModelManager)processModelManager;
    }

    public Object loadObject(String string) {
        Document document = this.readFrom(new File(string));
        if (document != null) {
            return this.xmlt.objectFromDocument(document);
        }
        return null;
    }

    Function1 makePostfilter() {
        return new VarPostfilter();
    }

    class VarPostfilter
    implements Function1 {
        VarPostfilter() {
        }

        public Object funcall(Object object) {
            if (object instanceof PlanVariable) {
                return this.filterPlanVariable((PlanVariable)object);
            }
            if (object instanceof PlanVariableDeclaration) {
                return this.filterDeclaration((PlanVariableDeclaration)object);
            }
            return object;
        }

        Variable filterDeclaration(PlanVariableDeclaration planVariableDeclaration) {
            Variable variable = (Variable)PlanLoader.this.varMap.get(planVariableDeclaration.getId());
            Debug.assert(variable == null, "Variable declared twice", planVariableDeclaration);
            variable = PlanLoader.this.processModel.mapVariableDeclaration(planVariableDeclaration);
            PlanLoader.this.varMap.put(planVariableDeclaration.getId(), variable);
            return variable;
        }

        Variable filterPlanVariable(PlanVariable planVariable) {
            Variable variable = (Variable)PlanLoader.this.varMap.get(planVariable.getId());
            Debug.assert(variable != null, "Unknown variable", planVariable);
            return variable;
        }
    }
}

