/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.process;

import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.process.PNode;
import ix.icore.process.event.ProcessStatusEvent;
import ix.icore.process.event.ProcessStatusListener;
import ix.icore.process.state.Plan;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.lisp.LList;
import ix.util.match.MatchEnv;
import ix.util.match.SimpleMatcher;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class ProcessModelManager {
    protected List nodes = new LinkedList();
    protected Map varEnv = new HashMap();
    protected List processStatusListeners = new LinkedList();
    protected List sentinels = new LinkedList();

    public void reset() {
        this.nodes.clear();
        this.varEnv.clear();
        this.sentinels.clear();
    }

    public Variable getVariable(Object object) {
        return (Variable)this.varEnv.get(object);
    }

    public void addVariable(Variable variable) {
        Debug.assert(this.varEnv.get(variable.getName()) == null, "Variable already exists");
        this.varEnv.put(variable.getName(), variable);
    }

    public void addNode(PNode pNode) {
        Debug.noteln("PMM adding node", pNode);
        pNode.modelManager = this;
        this.nodes.add(pNode);
    }

    public void addConstraints(PNode pNode, List list) {
        Debug.noteln("PMM adding constraints for node", pNode);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            Debug.noteln("--- adding ", constraint);
            this.addConstraint(pNode, constraint);
        }
    }

    protected abstract void addConstraint(PNode var1, Constraint var2);

    public abstract void addConstraint(Constraint var1);

    public abstract MatchEnv evalFilters(List var1, MatchEnv var2);

    public abstract void newBindings(Map var1);

    public abstract void statusChanged(PNode var1);

    public LList putVariablesInPattern(LList lList) {
        return (LList)SimpleMatcher.emptyEnv.instantiateTree(lList, new MakeVarIfUnbound());
    }

    public abstract Plan getPlan();

    public abstract void setPlan(Plan var1);

    public void addSentinel(Sentinel sentinel) {
        this.sentinels.add(sentinel);
    }

    public void removeSentinel(Sentinel sentinel) {
        this.sentinels.remove(sentinel);
    }

    public void runSentinels() {
        Iterator iterator = this.sentinels.iterator();
        while (iterator.hasNext()) {
            Sentinel sentinel = (Sentinel)iterator.next();
            if (!sentinel.isReady()) continue;
            iterator.remove();
            sentinel.run();
        }
    }

    public void addProcessStatusListener(ProcessStatusListener processStatusListener) {
        this.processStatusListeners.add(processStatusListener);
    }

    public void fireStatusUpdate() {
        ProcessStatusEvent processStatusEvent = new ProcessStatusEvent(this);
        Iterator iterator = this.processStatusListeners.iterator();
        while (iterator.hasNext()) {
            ProcessStatusListener processStatusListener = (ProcessStatusListener)iterator.next();
            processStatusListener.statusUpdate(processStatusEvent);
        }
    }

    public void fireNewBindings(Map map) {
        ProcessStatusEvent processStatusEvent = new ProcessStatusEvent(this);
        Iterator iterator = this.processStatusListeners.iterator();
        while (iterator.hasNext()) {
            ProcessStatusListener processStatusListener = (ProcessStatusListener)iterator.next();
            processStatusListener.newBindings(processStatusEvent, map);
        }
    }

    public void fireStateChange(Map map) {
        ProcessStatusEvent processStatusEvent = new ProcessStatusEvent(this);
        Iterator iterator = this.processStatusListeners.iterator();
        while (iterator.hasNext()) {
            ProcessStatusListener processStatusListener = (ProcessStatusListener)iterator.next();
            processStatusListener.stateChange(processStatusEvent, map);
        }
    }

    protected static interface Sentinel
    extends Runnable {
        public boolean isReady();
    }

    class MakeVarIfUnbound
    implements Function1 {
        MakeVarIfUnbound() {
        }

        public Object funcall(Object object) {
            Variable variable = (Variable)ProcessModelManager.this.varEnv.get(object);
            if (variable == null) {
                variable = new Variable(object);
                ProcessModelManager.this.varEnv.put(object, variable);
            }
            return variable;
        }
    }
}

