/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.process;

import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.domain.End;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.icore.domain.Refinement;
import ix.icore.process.PNodeMaker;
import ix.icore.process.ProcessModelManager;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.Name;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.match.MatchEnv;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class PNode {
    public ProcessModelManager modelManager;
    public static boolean computeStatus = true;
    public int level = 0;
    public PNode parent = null;
    public List children = Lisp.NIL;
    public Map nameToChildMap;
    public Map varTable;
    public List preNodes = new LinkedList();
    public List postNodes = new LinkedList();
    public Refinement refinement = null;

    public PNode(PNode pNode) {
        this.parent = pNode;
        if (pNode != null) {
            this.level = pNode.level + 1;
        }
    }

    public abstract Status getStatus();

    public boolean isAncestorOf(PNode pNode) {
        PNode pNode2 = pNode.parent;
        while (pNode2 != null) {
            if (this == pNode2) {
                return true;
            }
            pNode2 = pNode2.parent;
        }
        return false;
    }

    public boolean isDescendentOf(PNode pNode) {
        return pNode.isAncestorOf(this);
    }

    public boolean isExpanded() {
        return this.varTable != null;
    }

    public void expandOneLevel(Refinement refinement, MatchEnv matchEnv, PNodeMaker pNodeMaker) {
        this.varTable = new HashMap();
        this.nameToChildMap = new HashMap();
        Debug.assert(this.refinement == null);
        MakeVarIfUnbound makeVarIfUnbound = new MakeVarIfUnbound(this.varTable);
        this.refinement = refinement.instantiate(matchEnv, makeVarIfUnbound);
        Debug.noteln("varTable after expansion", this.varTable);
        LListCollector lListCollector = new LListCollector();
        Iterator iterator = Collect.iterator(this.refinement.getNodes());
        while (iterator.hasNext()) {
            NodeSpec nodeSpec = (NodeSpec)iterator.next();
            LList lList = nodeSpec.getPattern();
            PNode pNode = pNodeMaker.makePNode(this, lList);
            lListCollector.add(pNode);
            this.nameToChildMap.put(nodeSpec.getId(), pNode);
        }
        this.children = lListCollector.contents();
        if (this.refinement.getOrderings() != null) {
            this.processOrderings(this.refinement.getOrderings());
        }
        PNode.allComputeStatus(this.children);
    }

    public void processOrderings(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Ordering ordering = (Ordering)iterator.next();
            Debug.assert(ordering.getFrom().getEnd() == End.END);
            Debug.assert(ordering.getTo().getEnd() == End.BEGIN);
            Name name = ordering.getFrom().getNode();
            Name name2 = ordering.getTo().getNode();
            PNode pNode = this.getChild(name);
            PNode pNode2 = this.getChild(name2);
            pNode.linkBefore(pNode2);
        }
    }

    protected PNode getChild(Name name) {
        PNode pNode = (PNode)this.nameToChildMap.get(name);
        if (pNode == null) {
            throw new RuntimeException("No child " + name);
        }
        return pNode;
    }

    protected void linkBefore(PNode pNode) {
        Debug.noteln("- " + this + " --> " + pNode);
        this.postNodes.add(pNode);
        pNode.preNodes.add(this);
    }

    public void computeStatus() {
        if (!computeStatus) {
            return;
        }
        if (this.getStatus() == Status.BLANK) {
            if ((this.parent == null || this.parent.getStatus() == Status.EXECUTING) && PNode.allHaveStatus(this.preNodes, Status.COMPLETE)) {
                this.setStatus(Status.POSSIBLE);
            }
        } else if (this.getStatus() == Status.EXECUTING) {
            Debug.assert(!this.children.isEmpty(), "Executing w/o children");
            if (PNode.allHaveStatus(this.children, Status.COMPLETE)) {
                this.setStatus(Status.COMPLETE);
            }
        }
    }

    public void setStatus(Status status) {
        Debug.noteln("Setting status of " + this + " to " + status);
        Debug.assert(computeStatus);
        this.modelManager.statusChanged(this);
        if (status == Status.COMPLETE) {
            if (this.parent != null) {
                this.parent.computeStatus();
            }
            PNode.allComputeStatus(this.postNodes);
        } else if (status == Status.EXECUTING) {
            PNode.allComputeStatus(this.children);
        } else if (status == Status.POSSIBLE && !this.children.isEmpty()) {
            this.setStatus(Status.EXECUTING);
        }
    }

    public static boolean allHaveStatus(List list, Status status) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PNode pNode = (PNode)iterator.next();
            if (pNode.getStatus() == status) continue;
            return false;
        }
        return true;
    }

    public static void allComputeStatus(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PNode pNode = (PNode)iterator.next();
            pNode.computeStatus();
        }
    }

    public class MakeVarIfUnbound
    implements Function1 {
        protected Map nameToVarMap;

        public MakeVarIfUnbound(Map map) {
            this.nameToVarMap = map;
        }

        public Object funcall(Object object) {
            Variable variable = (Variable)this.nameToVarMap.get(object);
            if (variable == null) {
                variable = new Variable(object);
                Debug.noteln("Creating variable " + variable + " for " + object);
                variable.sourceNode = PNode.this;
                this.nameToVarMap.put(object, variable);
            }
            return variable;
        }
    }
}

