/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.domain;

import ix.icore.AbstractIXObject;
import ix.icore.Issue;
import ix.icore.domain.Constraint;
import ix.icore.domain.Named;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.VariableDeclaration;
import ix.iface.domain.SyntaxException;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.Function1;
import ix.util.Util;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import ix.util.match.Matcher;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class Refinement
extends AbstractIXObject
implements Named,
Cloneable {
    protected String name;
    protected LList pattern;
    protected List variableDeclarations;
    protected List nodes;
    protected List orderings;
    protected List constraints;
    protected List issues;
    protected String comments = "";
    public static final Symbol S_WORLD_STATE = Symbol.intern("world-state");
    public static final Symbol S_CONDITION = Symbol.intern("condition");
    public static final Symbol S_EFFECT = Symbol.intern("effect");
    static /* synthetic */ Class class$java$util$TreeSet;
    static /* synthetic */ Class class$ix$icore$domain$VariableDeclaration;

    public Refinement() {
    }

    public Refinement(String string, LList lList) {
        this.name = string;
        this.pattern = lList;
        Debug.noteln("New blank refinement " + Util.quote(string) + " for", lList);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public LList getPattern() {
        return this.pattern;
    }

    public void setPattern(LList lList) {
        this.pattern = lList;
    }

    public List getVariableDeclarations() {
        return this.variableDeclarations;
    }

    public void setVariableDeclarations(List list) {
        this.variableDeclarations = list;
    }

    public List getNodes() {
        return this.nodes;
    }

    public void setNodes(List list) {
        this.nodes = list;
    }

    public List getOrderings() {
        return this.orderings;
    }

    public void setOrderings(List list) {
        this.orderings = list;
    }

    public List getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List list) {
        this.constraints = list;
    }

    public List getIssues() {
        return this.issues;
    }

    public void setIssues(List list) {
        this.issues = list;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public List getFilterConditions() {
        LinkedList<PatternAssignment> linkedList = new LinkedList<PatternAssignment>();
        Iterator iterator = Collect.iterator(this.constraints);
        while (iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            if (constraint.getType() != S_WORLD_STATE || constraint.getRelation() != S_CONDITION) continue;
            PatternAssignment patternAssignment = (PatternAssignment)constraint.getParameter(0);
            linkedList.add(patternAssignment);
        }
        return linkedList;
    }

    public void checkConsistency() {
        Debug.noteln("Checking consistency of", this);
        if (this.variableDeclarations != null) {
            this.checkVariableRefs();
        }
    }

    protected void checkVariableRefs() {
        SortedSet sortedSet = (SortedSet)Collect.map(class$java$util$TreeSet == null ? (class$java$util$TreeSet = Refinement.class$("java.util.TreeSet")) : class$java$util$TreeSet, this.variableDeclarations, Fn.accessor(class$ix$icore$domain$VariableDeclaration == null ? (class$ix$icore$domain$VariableDeclaration = Refinement.class$("ix.icore.domain.VariableDeclaration")) : class$ix$icore$domain$VariableDeclaration, "getName"));
        SortedSet sortedSet2 = this.getVariablesUsed();
        SortedSet sortedSet3 = (SortedSet)Collect.difference(sortedSet2, sortedSet);
        SortedSet sortedSet4 = (SortedSet)Collect.difference(sortedSet, sortedSet2);
        Debug.noteln("Declared", sortedSet);
        Debug.noteln("Used", sortedSet2);
        Debug.noteln("Undeclared", sortedSet3);
        Debug.noteln("Unused", sortedSet4);
        if (!sortedSet4.isEmpty()) {
            throw new SyntaxException("Unused variables in refinement " + this.name + ": " + sortedSet4);
        }
        if (!sortedSet3.isEmpty()) {
            throw new SyntaxException("Undeclared variables in refinement " + this.name + ": " + sortedSet3);
        }
    }

    public SortedSet getVariablesUsed() {
        final TreeSet treeSet = new TreeSet();
        this.instantiate(Matcher.emptyEnv, new Function1(){

            public Object funcall(Object object) {
                ItemVar itemVar = (ItemVar)object;
                treeSet.add(itemVar);
                return object;
            }
        });
        return treeSet;
    }

    protected boolean isDeclared(ItemVar itemVar) {
        if (this.variableDeclarations == null) {
            return false;
        }
        Iterator iterator = this.variableDeclarations.iterator();
        while (iterator.hasNext()) {
            VariableDeclaration variableDeclaration = (VariableDeclaration)iterator.next();
            if (variableDeclaration.getName() != itemVar) continue;
            return true;
        }
        return false;
    }

    public Refinement instantiate(MatchEnv matchEnv) {
        return this.instantiate(matchEnv, new Function1(){

            public Object funcall(Object object) {
                throw new RuntimeException("Unbound variable " + object);
            }
        });
    }

    public Refinement instantiate(MatchEnv matchEnv, Function1 function1) {
        try {
            Serializable serializable;
            ListIterator<Serializable> listIterator;
            Refinement refinement = (Refinement)this.clone();
            refinement.pattern = (LList)matchEnv.instantiateTree(refinement.pattern, function1);
            if (refinement.nodes != null) {
                refinement.nodes = LList.newLList(refinement.nodes);
                listIterator = refinement.nodes.listIterator();
                while (listIterator.hasNext()) {
                    serializable = (NodeSpec)listIterator.next();
                    listIterator.set(((NodeSpec)serializable).instantiate(matchEnv, function1));
                }
            }
            if (refinement.issues != null) {
                refinement.issues = LList.newLList(refinement.issues);
                listIterator = refinement.issues.listIterator();
                while (listIterator.hasNext()) {
                    serializable = (Issue)listIterator.next();
                    listIterator.set(((Issue)serializable).instantiate(matchEnv, function1));
                }
            }
            if (refinement.constraints != null) {
                refinement.constraints = LList.newLList(refinement.constraints);
                listIterator = refinement.constraints.listIterator();
                while (listIterator.hasNext()) {
                    serializable = (Constraint)listIterator.next();
                    listIterator.set(((Constraint)serializable).instantiate(matchEnv, function1));
                }
            }
            return refinement;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Debug.noteException(cloneNotSupportedException);
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "Refinement[" + this.name + " expands " + this.pattern + "]";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

