/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.domain;

import ix.icore.AbstractIXObject;
import ix.icore.domain.Named;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainListener;
import ix.icore.domain.event.RefinementEvent;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.lisp.LListCollector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Domain
extends AbstractIXObject
implements Named,
Cloneable {
    protected String name;
    protected List variableDeclarations;
    protected List refinements = new LListCollector();
    protected List listeners = new LListCollector();
    protected Map nameMap = new HashMap();

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List getVariableDeclarations() {
        return this.variableDeclarations;
    }

    public void setVariableDeclarations(List list) {
        this.variableDeclarations = list;
    }

    public List getRefinements() {
        return this.refinements;
    }

    public void setRefinements(List list) {
        this.refinements = list;
    }

    public void takeFrom(Domain domain) {
        Object object;
        Debug.noteln(this + " takes from " + domain);
        if (domain.name != null) {
            if (this.name != null) {
                object = Strings.breakAt("+", this.name);
                if (!object.contains(domain.name)) {
                    this.name = this.name + "+" + domain.name;
                    Debug.noteln("Extended name of", this);
                }
            } else {
                this.name = domain.name;
                Debug.noteln("New name for", this);
            }
        }
        object = domain.getRefinements().iterator();
        while (object.hasNext()) {
            this.addRefinement((Refinement)object.next());
        }
    }

    public boolean isEmpty() {
        return this.refinements.isEmpty();
    }

    public void clear() {
        Debug.noteln(this + " cleared");
        this.refinements.clear();
        this.nameMap.clear();
    }

    public Refinement getNamedRefinement(String string) {
        return (Refinement)this.nameMap.get(string);
    }

    public void addRefinement(Refinement refinement) {
        Debug.assert(this.getNamedRefinement(refinement.getName()) == null, "Two refinements named", refinement.getName());
        Debug.noteln(this + " adds " + refinement);
        this.nameMap.put(refinement.getName(), refinement);
        this.refinements.add(refinement);
        this.fireRefinementAdded(refinement);
    }

    public void deleteNamedRefinement(String string) {
        this.deleteRefinement(this.getNamedRefinement(string));
    }

    public void deleteRefinement(Refinement refinement) {
        Debug.noteln(this + " deletes " + refinement);
        this.refinements.remove(refinement);
        this.nameMap.remove(refinement.getName());
    }

    public void replaceNamedRefinement(String string, Refinement refinement) {
        this.replaceRefinement(this.getNamedRefinement(string), refinement);
    }

    public void replaceRefinement(Refinement refinement, Refinement refinement2) {
        Debug.noteln(this + " replaces " + refinement + " with " + refinement2);
        int n = this.refinements.indexOf(refinement);
        this.refinements.remove(n);
        this.refinements.add(n, refinement2);
        this.nameMap.put(refinement.getName(), refinement2);
    }

    public void addDomainListener(DomainListener domainListener) {
        this.listeners.add(domainListener);
    }

    public void fireRefinementAdded(Refinement refinement) {
        RefinementEvent refinementEvent = new RefinementEvent(this, refinement);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DomainListener domainListener = (DomainListener)iterator.next();
            domainListener.refinementAdded(refinementEvent);
        }
    }

    public void analyseDomain() {
    }

    public void checkConsistency() {
        Debug.noteln("Checking consistency of", this);
        Iterator iterator = this.refinements.iterator();
        while (iterator.hasNext()) {
            Refinement refinement = (Refinement)iterator.next();
            refinement.checkConsistency();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "Domain[" + this.name + ", " + this.refinements.size() + " refinements]";
    }
}

