/*
 * Decompiled with CFR 0.152.
 */
package ix.icore;

import ix.icore.process.PNode;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.lisp.Cons;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Variable
implements Comparable {
    Object name;
    Object value;
    static List allVariables = new LListCollector();
    static int count = 0;
    public int number = ++count;
    public PNode sourceNode = null;

    public Variable(Object object) {
        this.name = object;
        allVariables.add(this);
    }

    public Object getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        Debug.noteln("Setting value of " + this + " to " + object);
        Debug.assert(!(object instanceof ItemVar));
        Debug.assert(!(object instanceof Variable));
        this.value = object;
    }

    public boolean isGlobal() {
        return this.sourceNode == null;
    }

    public static List getAllVariables() {
        return ((LListCollector)allVariables).contents();
    }

    public int compareTo(Object object) {
        if (object instanceof Variable) {
            return ((Comparable)this.name).compareTo(((Variable)object).name);
        }
        throw new ClassCastException("Cannot compare Variable " + this + " to " + object);
    }

    public String displayString() {
        return "[" + this.number + ":" + this.name + (this.value == null ? "" : "=" + this.value) + "]";
    }

    public String toString() {
        return this.displayString();
    }

    public static Set varsIn(Object object) {
        if (object instanceof Variable) {
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(object);
            return hashSet;
        }
        if (object instanceof LList) {
            return Variable.varsIn((LList)object);
        }
        return new HashSet();
    }

    public static Set varsIn(LList lList) {
        final HashSet hashSet = new HashSet();
        lList.walkTree(new Function1(){

            public Object funcall(Object object) {
                if (object instanceof Variable) {
                    hashSet.add(object);
                }
                return null;
            }
        });
        return hashSet;
    }

    public static Set unboundVarsIn(Collection collection) {
        HashSet<Variable> hashSet = new HashSet<Variable>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Variable variable = (Variable)iterator.next();
            if (variable.getValue() != null) continue;
            hashSet.add(variable);
        }
        return hashSet;
    }

    public static boolean isFullyBound(Object object) {
        if (object instanceof Variable) {
            return ((Variable)object).getValue() != null;
        }
        if (object instanceof Cons) {
            Cons cons = (Cons)object;
            return Variable.isFullyBound(cons.car()) && Variable.isFullyBound(cons.cdr());
        }
        return true;
    }

    public static Object revertVars(Object object) {
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            return variable.getName();
        }
        if (object instanceof Cons) {
            Cons cons = (Cons)object;
            return new Cons(Variable.revertVars(cons.car()), (LList)Variable.revertVars(cons.cdr()));
        }
        return object;
    }

    public static Object removeVars(Object object) {
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            Object object2 = variable.getValue();
            return object2 == null ? variable.getName() : object2;
        }
        if (object instanceof Cons) {
            Cons cons = (Cons)object;
            return new Cons(Variable.removeVars(cons.car()), (LList)Variable.removeVars(cons.cdr()));
        }
        return object;
    }
}

