/*
 * Decompiled with CFR 0.152.
 */
package ix.icore;

import ix.icore.AbstractIXObject;
import ix.icore.IXAgent;
import ix.icore.Priority;
import ix.icore.Sendable;
import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.YesNo;
import ix.util.IPC;
import ix.util.Name;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.io.Serializable;
import java.util.Set;

public abstract class TaskItem
extends AbstractIXObject
implements Serializable,
Cloneable,
Sendable {
    protected LList pattern;
    protected Status status = Status.BLANK;
    protected Priority priority = Priority.NORMAL;
    protected Name id = this.generateId();
    protected Name senderId;
    protected Name ref;
    protected YesNo reportBack;
    protected String shortDescription;
    protected Set patternVars;

    protected TaskItem() {
    }

    protected TaskItem(LList lList) {
        this();
        this.setPattern(lList);
    }

    public LList getPattern() {
        return this.pattern;
    }

    public void setPattern(LList lList) {
        this.pattern = lList;
        this.shortDescription = Lisp.elementsToString(lList);
        this.patternVars = Variable.varsIn(lList);
    }

    public Object getVerb() {
        return this.pattern.car();
    }

    public LList getParameters() {
        return this.pattern.cdr();
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public Set getPatternVars() {
        return this.patternVars;
    }

    public Set getUnboundVars() {
        return Variable.unboundVarsIn(this.patternVars);
    }

    public Name getId() {
        return this.id;
    }

    public abstract Name generateId();

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Name getSenderId() {
        return this.senderId;
    }

    public void setSenderId(Name name) {
        this.senderId = name;
    }

    public Name getRef() {
        return this.ref;
    }

    public void setRef(Name name) {
        this.ref = name;
    }

    public YesNo getReportBack() {
        return this.reportBack;
    }

    public void setReportBack(YesNo yesNo) {
        this.reportBack = yesNo;
    }

    public void forwardTo(Object object, boolean bl) {
        Object object2 = IXAgent.getAgent().getAgentIPCName();
        try {
            TaskItem taskItem = (TaskItem)this.clone();
            taskItem.setPattern((LList)Variable.removeVars(this.getPattern()));
            taskItem.setSenderId(Name.valueOf(object2));
            taskItem.setReportBack(YesNo.valueOf(bl));
            taskItem.setRef(this.id);
            IPC.sendObject(object, taskItem);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Can't clone " + this);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TaskItem taskItem = (TaskItem)super.clone();
        taskItem.id = this.generateId();
        return taskItem;
    }
}

