/*
 * Decompiled with CFR 0.152.
 */
package ix.icore;

import ix.ichat.ChatMessage;
import ix.icore.Activity;
import ix.icore.Issue;
import ix.icore.Report;
import ix.icore.Sendable;
import ix.icore.domain.Constraint;
import ix.iface.util.IfaceUtil;
import ix.iface.util.Reporting;
import ix.ispace.ContactManager;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Name;
import ix.util.Parameters;
import ix.util.TextAreaFrame;
import ix.util.Util;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class IXAgent {
    protected static IXAgent thisAgent = null;
    protected String ipcName = "anonymous";
    protected String displayName = "I-X Agent";
    protected String symbolName = "anonymous";
    protected ContactManager contactManager = new ContactManager();
    protected String ipcStrategyName = null;
    protected TextAreaFrame textFrame = null;

    public IXAgent() {
        if (thisAgent != null) {
            throw new Error("Attempt to create multiple IX Agents in one VM");
        }
        thisAgent = this;
    }

    public void mainStartup(String[] stringArray) {
        Parameters.processCommandLineArguments(stringArray);
        this.processCommandLineArguments();
        this.startup();
        if (this.ipcStrategyName != null) {
            this.startServer(this.getAgentIPCName(), this.ipcStrategyName);
        }
        Parameters.checkParameterUse();
    }

    protected void startup() {
    }

    protected void processCommandLineArguments() {
        String string;
        IfaceUtil.adjustLookAndFeel();
        Debug.on = Parameters.getBoolean("debug", true);
        if (Parameters.haveParameter("ipc-name")) {
            this.ipcName = Parameters.getParameter("ipc-name");
            Debug.noteln("Using ipc name", this.ipcName);
        } else if (Parameters.haveParameter("symbol-name")) {
            this.ipcName = Parameters.getParameter("symbol-name");
            Debug.noteln("Using symbol name " + this.ipcName + " as ipc name");
        } else {
            try {
                this.ipcName = "IX-" + Util.getUserName() + "@" + Util.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                this.ipcName = "IX-" + Util.getUserName();
                Util.displayMessage(null, "Can't get host name; using ipc-name=" + this.ipcName);
            }
        }
        this.symbolName = Parameters.getParameter("symbol-name", this.ipcName);
        String string2 = this.displayName = Parameters.haveParameter("display-name") ? Parameters.getParameter("display-name") : this.symbolName + " " + this.displayName;
        if (Parameters.haveParameter("ipc") && !(string = Parameters.getParameter("ipc")).equals("false") && !string.equals("none")) {
            this.ipcStrategyName = string;
        }
        this.contactManager.processCommandLineArguments();
    }

    public static IXAgent getAgent() {
        return thisAgent;
    }

    public Object getAgentIPCName() {
        return this.ipcName;
    }

    public String getAgentSymbolName() {
        return this.symbolName;
    }

    public String getAgentDisplayName() {
        return this.displayName;
    }

    public ContactManager getContactManager() {
        return this.contactManager;
    }

    protected void startServer(Object object, String string) {
        IPC.setDefaultCommunicationStrategy(string);
        IPC.setupServer(object, new IPC.MessageListener(){

            public synchronized void messageReceived(IPC.InputMessage inputMessage) {
                IXAgent.this.pre_handleInput(inputMessage);
            }
        });
    }

    protected void pre_handleInput(final IPC.InputMessage inputMessage) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    IXAgent.this.notePossibleNewContact(inputMessage);
                    IXAgent.this.handleInput(inputMessage);
                }
                catch (Throwable throwable) {
                    Debug.noteException(throwable);
                    IXAgent.this.tellUserOfException(inputMessage, throwable);
                }
            }
        });
    }

    protected void tellUserOfException(IPC.InputMessage inputMessage, Throwable throwable) {
        Object object = inputMessage.getContents();
        String string = object instanceof Sendable ? ((Sendable)object).getSenderId().toString() : "unknown sender";
        JOptionPane.showMessageDialog(null, new Object[]{"Problem handling message from " + string, "Contents class " + object.getClass().getName(), throwable.getClass().getName(), throwable.getMessage()}, "Error during message handling", 0);
    }

    public void notePossibleNewContact(IPC.InputMessage inputMessage) {
        Name name;
        Object object = inputMessage.getContents();
        if (object instanceof Sendable && (name = ((Sendable)object).getSenderId()) != null) {
            this.contactManager.noteAgent(name.toString());
        }
    }

    public void handleInput(IPC.InputMessage inputMessage) {
        Object object = inputMessage.getContents();
        if (object instanceof Issue) {
            this.handleNewIssue((Issue)object);
        } else if (object instanceof Activity) {
            this.handleNewActivity((Activity)object);
        } else if (object instanceof Constraint) {
            this.handleNewConstraint((Constraint)object);
        } else if (object instanceof Report) {
            this.handleNewReport((Report)object);
        } else if (object instanceof ChatMessage) {
            this.handleNewChatMessage((ChatMessage)object);
        } else {
            this.displayMessage("Unexpected message contents " + object);
        }
    }

    public void handleNewIssue(Issue issue) {
        this.displayMessage(Reporting.issueDescription(issue));
    }

    public void handleNewActivity(Activity activity) {
        this.displayMessage(Reporting.activityDescription(activity));
    }

    public void handleNewConstraint(Constraint constraint) {
        this.displayMessage(Reporting.constraintDescription(constraint));
    }

    public void handleNewReport(Report report) {
        this.displayMessage(Reporting.reportDescription(report));
    }

    public void handleNewChatMessage(ChatMessage chatMessage) {
        this.displayMessage(Reporting.chatMessageDescription(chatMessage));
    }

    protected void displayMessage(String string) {
        if (this.textFrame == null) {
            this.textFrame = new TextAreaFrame("Messages to " + this.getAgentIPCName());
        }
        this.textFrame.appendLine(string);
    }
}

