/*
 * Decompiled with CFR 0.152.
 */
package ix.ichat;

import ix.ichat.ChatMessage;
import ix.ichat.IChat;
import ix.icore.Activity;
import ix.icore.IXAgent;
import ix.icore.Issue;
import ix.icore.Sendable;
import ix.icore.TaskItem;
import ix.icore.YesNo;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.IconImage;
import ix.iface.util.Reporting;
import ix.iface.util.ToolFrame;
import ix.iface.util.TranscriptTextArea;
import ix.ip2.WaitForReportsActivity;
import ix.itest.SendPanel;
import ix.util.Debug;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ChatFrame
extends ToolFrame
implements ActionListener {
    protected Container contentPane = this.getContentPane();
    IXAgent agent;
    TranscriptPanel transcriptPanel = new TranscriptPanel();
    SendPanel sendPanel;

    public ChatFrame(IXAgent iXAgent, String string) {
        super(string);
        this.agent = iXAgent;
        ((Frame)this).setIconImage(IconImage.getIconImage(this));
        this.sendPanel = new ChatSendPanel(iXAgent);
        this.setJMenuBar(this.makeMenuBar());
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.contentPane.add(this.transcriptPanel);
        this.contentPane.add(this.sendPanel);
        this.pack();
    }

    protected JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        if (this.agent instanceof IChat) {
            jMenu.add(this.makeMenuItem("Exit"));
        } else {
            jMenu.add(this.makeMenuItem("Close"));
        }
        return jMenuBar;
    }

    protected JMenuItem makeMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(CatchingActionListener.listener(this));
        return jMenuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("ChatFrame action:", string);
        if (string.equals("Close")) {
            this.setVisible(false);
        } else if (string.equals("Exit")) {
            System.exit(0);
        } else {
            Debug.noteln("Nothing to do for", string);
        }
    }

    public void newMessage(ChatMessage chatMessage) {
        this.transcriptPanel.newMessage(chatMessage);
    }

    public void initReport(TaskItem taskItem) {
        this.sendPanel.initReport(taskItem);
    }

    public SendPanel getSendPanel() {
        return this.sendPanel;
    }

    class ChatSendPanel
    extends SendPanel {
        ChatSendPanel(IXAgent iXAgent) {
            super(iXAgent);
        }

        protected ChatMessage messageFromControls() {
            ChatMessage chatMessage = super.messageFromControls();
            ChatFrame.this.transcriptPanel.newMessage(chatMessage);
            return chatMessage;
        }

        public void send(String string, Sendable sendable) {
            if (sendable instanceof Issue || sendable instanceof Activity) {
                TaskItem taskItem = (TaskItem)sendable;
                if (!string.equalsIgnoreCase("me") && taskItem.getReportBack() == YesNo.YES && taskItem.getRef() == null) {
                    WaitForReportsActivity waitForReportsActivity = new WaitForReportsActivity(string, taskItem.getPattern());
                    taskItem.setRef(waitForReportsActivity.getId());
                    waitForReportsActivity.setPriority(taskItem.getPriority());
                    ChatFrame.this.agent.handleNewActivity(waitForReportsActivity);
                }
            }
            super.send(string, sendable);
        }
    }

    class TranscriptPanel
    extends JPanel {
        TranscriptTextArea transcript = new TranscriptTextArea(15, 40);

        TranscriptPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createTitledBorder("Transcript"));
            this.transcript.setEditable(false);
            this.add(new JScrollPane(this.transcript));
        }

        public void newMessage(ChatMessage chatMessage) {
            this.transcript.appendLine(chatMessage.getSenderId() + " at " + Reporting.dateString() + ":");
            this.transcript.appendIndentedLines(3, chatMessage.getText());
        }
    }
}

