/*
 * Decompiled with CFR 0.152.
 */
package ix.examples;

import ix.util.Debug;
import ix.util.MessageQueue;
import ix.util.Seq;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import java.util.Enumeration;
import java.util.Hashtable;

public class PicoIX {

    static class Controller {
        IX_System system;
        MessageQueue q;
        LListCollector issues = new LListCollector();
        Hashtable handlerTable = new Hashtable();

        Controller() {
        }

        Controller(IX_System iX_System) {
            this.setSystem(iX_System);
        }

        void setSystem(IX_System iX_System) {
            this.system = iX_System;
            this.q = iX_System.q;
        }

        void mainLoop() {
            while (true) {
                if (this.q.hasMessage()) {
                    this.addEventIssue(this.q);
                    continue;
                }
                if (!this.issues.isEmpty()) {
                    this.handleIssue(this.selectIssue());
                    continue;
                }
                this.q.waitForMessage();
            }
        }

        protected void addIssue(Issue issue) {
            Debug.noteln("Adding", issue);
            this.issues.addElement(issue);
        }

        protected void addEventIssue(MessageQueue messageQueue) {
            this.addIssue(this.system.eventToIssue(messageQueue.nextMessage()));
        }

        Issue selectIssue() {
            return (Issue)this.issues.popElement();
        }

        void installIssueHandlers(Object[] objectArray) {
            this.installIssueHandlers(objectArray, this.handlerTable);
        }

        void installIssueHandlers(Object[] objectArray, Hashtable hashtable) {
            Enumeration enumeration = Seq.elements(objectArray);
            while (enumeration.hasMoreElements()) {
                IssueHandler issueHandler = (IssueHandler)enumeration.nextElement();
                issueHandler.setSystem(this.system);
                hashtable.put(issueHandler.verb, issueHandler);
            }
        }

        IssueHandler findHandler(Issue issue) {
            IssueHandler issueHandler = (IssueHandler)this.handlerTable.get(issue.verb);
            Debug.assert(issueHandler != null, "no handler for", issue.verb);
            return issueHandler;
        }

        void handleIssue(Issue issue) {
            Debug.noteln("Handling", issue);
            this.findHandler(issue).handleIssue(issue);
        }
    }

    static class IX_System
    implements Runnable {
        Thread thread = new Thread(this);
        MessageQueue q = new MessageQueue();
        Controller controller;
        ModelManager model;
        IX_SystemListener listener;

        IX_System() {
            this.controller = new Controller(this);
            this.model = new ModelManager(this);
        }

        IX_System(Controller controller, ModelManager modelManager) {
            this.controller = controller != null ? controller : new Controller();
            this.model = modelManager != null ? modelManager : new ModelManager();
            this.controller.setSystem(this);
            this.model.setSystem(this);
        }

        void addIssueHandlers(Object[] objectArray) {
            this.controller.installIssueHandlers(objectArray);
        }

        void addConstraintManagers(Object[] objectArray) {
            this.model.installConstraintManagers(objectArray);
        }

        public void setListener(IX_SystemListener iX_SystemListener) {
            this.listener = iX_SystemListener;
        }

        void notifyListener(Object object) {
            if (this.listener != null) {
                this.listener.receive(object);
            } else {
                Debug.noteln("No listener for", object);
            }
        }

        public void newEvent(Object object) {
            this.q.send(object);
        }

        Issue eventToIssue(Object object) {
            return (Issue)object;
        }

        public void start() {
            this.thread.start();
        }

        public void stop() {
            this.thread.stop();
        }

        public void run() {
            this.controller.mainLoop();
        }
    }

    static class IX_SystemListener {
        void receive(Object object) {
            Debug.noteln("Listener received:", object);
        }
    }

    static class ModelManager {
        IX_System system;
        Hashtable CMTable = new Hashtable();

        ModelManager() {
        }

        ModelManager(IX_System iX_System) {
            this.setSystem(iX_System);
        }

        void setSystem(IX_System iX_System) {
            this.system = iX_System;
        }

        void installConstraintManagers(Object[] objectArray) {
            Enumeration enumeration = Seq.elements(objectArray);
            while (enumeration.hasMoreElements()) {
                ConstraintManager constraintManager = (ConstraintManager)enumeration.nextElement();
                constraintManager.setSystem(this.system);
                this.CMTable.put(constraintManager.type, constraintManager);
            }
        }

        Object addConstraint(Constraint constraint) {
            return this.findCM(constraint).addConstraint(constraint);
        }

        Object tryConstraint(Constraint constraint) {
            return this.findCM(constraint).tryConstraint(constraint);
        }

        ConstraintManager findCM(Constraint constraint) {
            ConstraintManager constraintManager = (ConstraintManager)this.CMTable.get(constraint.type);
            Debug.assert(constraintManager != null, "no CM for", constraintManager.type);
            return constraintManager;
        }
    }

    static abstract class ConstraintManager {
        IX_System system;
        Object type;

        ConstraintManager(Object object) {
            this.type = object;
        }

        void setSystem(IX_System iX_System) {
            this.system = iX_System;
        }

        abstract Object addConstraint(Constraint var1);

        abstract Object tryConstraint(Constraint var1);
    }

    static class Constraint {
        Object type;
        Object args;

        Constraint(Object object) {
            this.type = object;
        }

        public String toString() {
            return "issue[" + Lisp.printToString(this.type) + ", " + Lisp.printToString(this.args) + "]";
        }
    }

    static abstract class IssueHandler {
        Object verb;
        IX_System system;

        IssueHandler(Object object) {
            this.verb = object;
        }

        void setSystem(IX_System iX_System) {
            this.system = iX_System;
        }

        abstract void handleIssue(Issue var1);

        void postIssue(Issue issue) {
            this.system.controller.addIssue(issue);
        }

        Object addConstraint(Constraint constraint) {
            return this.system.model.addConstraint(constraint);
        }

        Object tryConstraint(Constraint constraint) {
            return this.system.model.tryConstraint(constraint);
        }
    }

    static class Issue {
        Object verb = Lisp.NIL;
        Object object = Lisp.NIL;

        Issue(Object object, Object object2) {
            this.verb = object;
            this.object = object2;
        }

        Issue(Object object) {
            this.verb = object;
        }

        public String toString() {
            return "issue[" + Lisp.printToString(this.verb) + ", " + Lisp.printToString(this.object) + "]";
        }
    }
}

