/*
 * Decompiled with CFR 0.152.
 */
package ix.examples;

import ix.examples.PicoISim;
import ix.examples.PicoIX;
import ix.examples.SimResource;
import ix.util.Debug;
import ix.util.Util;
import ix.util.lisp.Symbol;
import java.util.Hashtable;

public class PicoISimTest3
extends PicoISim {
    public static void main(String[] stringArray) {
        final PicoISim.IX_Simulator iX_Simulator = new PicoISim.IX_Simulator();
        iX_Simulator.setListener(new PicoIX.IX_SystemListener());
        iX_Simulator.addIssueHandlers(new Object[]{new PicoIX.IssueHandler("reportResourceState"){

            void handleIssue(PicoIX.Issue issue) {
                Hashtable hashtable = this.system.model.CMTable;
                ((SimResource.CM)hashtable.get(SimResource.S_RESOURCE)).printStatusReport();
            }
        }});
        iX_Simulator.addConstraintManagers(new Object[]{new SimResource.CM()});
        iX_Simulator.addSimEventHandlers(new Object[]{new ResourceEventHandler(SimResource.S_PRODUCE), new ResourceEventHandler(SimResource.S_CONSUME)});
        SimResource.Constraint constraint = new SimResource.Constraint(SimResource.S_CONSUME, 2L, "items");
        SimResource.Constraint constraint2 = new SimResource.Constraint(SimResource.S_PRODUCE, 4L, "items");
        iX_Simulator.schedule(new ResourceEvent(constraint, 5L));
        iX_Simulator.schedule(new ResourceEvent(constraint2, 20L));
        iX_Simulator.start();
        new Thread(){

            public void run() {
                while (true) {
                    Util.readLine(System.in);
                    PicoISimTest3.askForResourceReport(iX_Simulator);
                    System.out.println("OK");
                }
            }
        }.start();
    }

    static void askForResourceReport(PicoISim.IX_Simulator iX_Simulator) {
        iX_Simulator.newEvent(new PicoIX.Issue("reportResourceState"));
    }

    static class ResourceEventHandler
    extends PicoISim.SimEventHandler {
        ResourceEventHandler(Symbol symbol) {
            super(symbol);
        }

        void handleIssue(PicoIX.Issue issue) {
            long l;
            ResourceEvent resourceEvent = (ResourceEvent)issue;
            SimResource.Constraint constraint = resourceEvent.rc;
            Debug.assert(this.addConstraint(constraint).equals(Boolean.TRUE), "Could not add", constraint);
            resourceEvent.execute((PicoISim.IX_Simulator)this.system);
            resourceEvent.est = l = this.getSimTime() + resourceEvent.timeBetween;
            this.postSimEvent(resourceEvent);
        }

        boolean isAble(PicoISim.SimEvent simEvent) {
            ResourceEvent resourceEvent = (ResourceEvent)simEvent;
            SimResource.Constraint constraint = resourceEvent.rc;
            return this.tryConstraint(constraint).equals(Boolean.TRUE);
        }
    }

    static class ResourceEvent
    extends PicoISim.SimEvent {
        SimResource.Constraint rc;
        long timeBetween;

        ResourceEvent(SimResource.Constraint constraint, long l) {
            super(constraint.subtype, constraint.pattern, 0L);
            this.rc = constraint;
            this.timeBetween = l;
        }

        void execute(PicoISim.IX_Simulator iX_Simulator) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

