/*
 * Decompiled with CFR 0.152.
 */
package ix.examples;

import ix.examples.PicoIX;
import ix.util.Debug;
import ix.util.Predicate2;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.util.Hashtable;

public class PicoISim
extends PicoIX {
    static Symbol SYM(String string) {
        return Symbol.intern(string);
    }

    static abstract class SimEventHandler
    extends PicoIX.IssueHandler {
        SimEventHandler(Object object) {
            super(object);
        }

        boolean isAble(SimEvent simEvent) {
            return true;
        }

        long getSimTime() {
            return ((IX_Simulator)this.system).simTime;
        }

        void postSimEvent(SimEvent simEvent) {
            ((IX_Simulator)this.system).postSimEvent(simEvent);
        }
    }

    static class SimEvent
    extends PicoIX.Issue {
        long est = 0L;

        SimEvent(Object object, Object object2, long l) {
            super(object, object2);
            this.est = l;
        }

        void execute(IX_Simulator iX_Simulator) {
        }

        public String toString() {
            return "SimEvent[" + Lisp.printToString(this.verb) + " " + Lisp.printToString(this.object) + " at " + this.est + "]";
        }
    }

    static class SimController
    extends PicoIX.Controller {
        LListCollector simEvents = new LListCollector();
        Hashtable simHandlerTable = new Hashtable();
        static final Predicate2 EARLIER_EST_P = new Predicate2(){

            public boolean trueOf(Object object, Object object2) {
                return ((SimEvent)object).est < ((SimEvent)object2).est;
            }
        };

        SimController() {
        }

        SimController(PicoIX.IX_System iX_System) {
            super(iX_System);
        }

        void addSimEvent(SimEvent simEvent) {
            Debug.noteln("Scheduling", simEvent);
            this.simEvents.insertElement(simEvent, EARLIER_EST_P);
        }

        void mainLoop() {
            while (true) {
                if (this.q.hasMessage()) {
                    this.addEventIssue(this.q);
                    continue;
                }
                if (!this.issues.isEmpty()) {
                    this.handleIssue(this.selectIssue());
                    continue;
                }
                if (!this.simEvents.isEmpty()) {
                    boolean bl = this.simulateIfPossible();
                    if (bl) continue;
                    this.q.waitForMessage();
                    continue;
                }
                this.whenIdle();
            }
        }

        void whenIdle() {
            if (((IX_Simulator)this.system).stopWhenIdle) {
                Debug.noteln("Simulator stopping because nothing to do");
                this.system.stop();
                Debug.assert(false, "continued after thread stop()");
            } else {
                this.q.waitForMessage();
            }
        }

        boolean simulateIfPossible() {
            Debug.noteln("Agenda", this.simEvents.contents());
            LList lList = this.simEvents.contents();
            while (lList != Lisp.NIL) {
                SimEvent simEvent = (SimEvent)lList.car();
                if (this.canSimulate(simEvent)) {
                    return this.simulateIfPossible(simEvent);
                }
                lList = lList.cdr();
            }
            return false;
        }

        boolean simulateIfPossible(SimEvent simEvent) {
            this.simEvents.deleteElement(simEvent);
            this.setSimTime(simEvent.est);
            this.simulate(simEvent);
            return true;
        }

        boolean canSimulate(SimEvent simEvent) {
            SimEventHandler simEventHandler = this.findSimHandler(simEvent);
            if (simEventHandler.isAble(simEvent)) {
                return true;
            }
            Debug.noteln("Can't execute " + simEvent + " at this time");
            return false;
        }

        void simulate(SimEvent simEvent) {
            SimEventHandler simEventHandler = this.findSimHandler(simEvent);
            simEventHandler.handleIssue(simEvent);
        }

        void installSimEventHandlers(Object[] objectArray) {
            this.installIssueHandlers(objectArray, this.simHandlerTable);
        }

        SimEventHandler findSimHandler(PicoIX.Issue issue) {
            SimEventHandler simEventHandler = (SimEventHandler)this.simHandlerTable.get(issue.verb);
            Debug.assert(simEventHandler != null, "no sim handler for", issue.verb);
            return simEventHandler;
        }

        long getSimTime() {
            return ((IX_Simulator)this.system).simTime;
        }

        void setSimTime(long l) {
            ((IX_Simulator)this.system).setSimTime(l);
        }
    }

    static class IX_Simulator
    extends PicoIX.IX_System {
        long simTime = -1L;
        boolean stopWhenIdle = true;

        IX_Simulator() {
            this.controller = new SimController(this);
            this.model = new PicoIX.ModelManager(this);
            this.addIssueHandlers(this.makeBuiltinIssueHandlers());
            this.addSimEventHandlers(this.makeBuiltinSimEventHandlers());
        }

        IX_Simulator(PicoIX.Controller controller, PicoIX.ModelManager modelManager) {
            super(controller != null ? controller : new SimController(), modelManager);
            this.addIssueHandlers(this.makeBuiltinIssueHandlers());
            this.addSimEventHandlers(this.makeBuiltinSimEventHandlers());
        }

        public void addSimEventHandlers(Object[] objectArray) {
            ((SimController)this.controller).installSimEventHandlers(objectArray);
        }

        public void setStopWhenIdle(boolean bl) {
            this.stopWhenIdle = bl;
        }

        public void schedule(SimEvent simEvent) {
            this.newEvent(new PicoIX.Issue(PicoISim.SYM("schedule"), simEvent));
        }

        public void start() {
            this.setSimTime(0L);
            super.start();
        }

        void setSimTime(long l) {
            if (l > this.simTime) {
                Debug.noteln("\n- - - - - time now " + l + " - - - - -\n");
                this.simTime = l;
            }
        }

        void postSimEvent(SimEvent simEvent) {
            ((SimController)this.controller).addSimEvent(simEvent);
        }

        Object[] makeBuiltinIssueHandlers() {
            return new Object[]{new PicoIX.IssueHandler(this, PicoISim.SYM("schedule")){
                private final /* synthetic */ IX_Simulator this$0;
                {
                    this.this$0 = iX_Simulator;
                }

                void handleIssue(PicoIX.Issue issue) {
                    SimEvent simEvent = (SimEvent)issue.object;
                    ((IX_Simulator)this.system).postSimEvent(simEvent);
                }
            }};
        }

        Object[] makeBuiltinSimEventHandlers() {
            return new Object[0];
        }
    }
}

